/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.jvm.util.JvmClasspathUtilKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.IkotlinKt;
import org.jetbrains.kotlinx.jupyter.JupyterConnectionImpl;
import org.jetbrains.kotlinx.jupyter.ReplConfig;
import org.jetbrains.kotlinx.jupyter.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.api.libraries.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.libraries.EmptyResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionUtilKt;
import org.jetbrains.kotlinx.jupyter.messaging.CommManagerImpl;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternal;
import org.jetbrains.kotlinx.jupyter.messaging.ProtocolKt;
import org.jetbrains.kotlinx.jupyter.repl.creating.DefaultReplFactory;
import org.jetbrains.kotlinx.jupyter.startup.ArgumentsKt;
import org.jetbrains.kotlinx.jupyter.startup.KernelArgs;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u001a0\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u001f\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a!\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0006\u0010\u001c\u001a\u00020\u0005\"\u0015\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001d"}, d2={"iKotlinClass", "Ljava/lang/Class;", "getIKotlinClass", "()Ljava/lang/Class;", "embedKernel", "", "cfgFile", "Ljava/io/File;", "resolutionInfoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "scriptReceivers", "", "", "kernelServer", "kernelConfig", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "replConfig", "Lorg/jetbrains/kotlinx/jupyter/ReplConfig;", "runtimeProperties", "Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;", "main", "args", "", "", "([Ljava/lang/String;)V", "parseCommandLine", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelArgs;", "([Ljava/lang/String;)Lorg/jetbrains/kotlinx/jupyter/startup/KernelArgs;", "printClassPath", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nikotlin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ikotlin.kt\norg/jetbrains/kotlinx/jupyter/IkotlinKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,172:1\n13579#2:173\n13580#2:179\n11335#2:182\n11670#2,3:183\n13579#2,2:186\n1549#3:174\n1620#3,3:175\n1#4:178\n37#5,2:180\n*S KotlinDebug\n*F\n+ 1 ikotlin.kt\norg/jetbrains/kotlinx/jupyter/IkotlinKt\n*L\n29#1:173\n29#1:179\n91#1:182\n91#1:183,3\n128#1:186,2\n35#1:174\n35#1:175,3\n91#1:180,2\n*E\n"})
public final class IkotlinKt {
    @NotNull
    private static final Class<?> iKotlinClass;

    @NotNull
    public static final Class<?> getIKotlinClass() {
        return iKotlinClass;
    }

    /*
     * WARNING - void declaration
     */
    private static final KernelArgs parseCommandLine(String ... args) {
        File cfgFile = null;
        Ref.ObjectRef classpath = new Ref.ObjectRef();
        File homeDir2 = null;
        Integer debugPort = null;
        String clientType = null;
        String[] $this$forEach$iv = args;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object it;
            String element$iv;
            String arg = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (StringsKt.startsWith$default((String)arg, (String)"-cp=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)arg, (String)"-classpath=", (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list = (List)classpath.element;
                if (list != null) {
                    it = list;
                    boolean bl2 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("classpath already set to ");
                    Iterable iterable = (Iterable)it;
                    String string = File.pathSeparator;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
                    throw new IllegalArgumentException(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
                }
                CharSequence charSequence = StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null);
                Object object = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
                object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
                Ref.ObjectRef objectRef = classpath;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new File((String)it2));
                }
                objectRef.element = (List)destination$iv$iv;
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-home=", (boolean)false, (int)2, null)) {
                homeDir2 = new File(StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null));
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-debugPort=", (boolean)false, (int)2, null)) {
                debugPort = Integer.parseInt(StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null));
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-client=", (boolean)false, (int)2, null)) {
                clientType = StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null);
                continue;
            }
            File file = cfgFile;
            if (file != null) {
                it = file;
                boolean bl4 = false;
                throw new IllegalArgumentException("config file already set to " + it);
            }
            cfgFile = new File(arg);
        }
        File file = cfgFile;
        if (file == null) {
            throw new IllegalArgumentException("config file is not provided");
        }
        File cfgFileValue = file;
        if (!cfgFileValue.exists() || !cfgFileValue.isFile()) {
            throw new IllegalArgumentException("invalid config file " + cfgFileValue);
        }
        List list = (List)classpath.element;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return new KernelArgs(cfgFileValue, list, homeDir2, debugPort, clientType);
    }

    public static final void printClassPath() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)cl, (String)"cl");
        List cp = JvmClasspathUtilKt.classpathFromClassloader$default((ClassLoader)cl, (boolean)false, (int)2, null);
        if (cp != null) {
            ConfigKt.getLog().info("Current classpath: " + CollectionsKt.joinToString$default((Iterable)cp, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    public static final void main(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            ConfigKt.getLog().info("Kernel args: " + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, (Function1)main.1.INSTANCE, (int)31, null));
            KernelArgs kernelArgs = IkotlinKt.parseCommandLine(Arrays.copyOf(args, args.length));
            ResolutionInfoProvider libraryInfoProvider = ResolutionUtilKt.getDefaultClasspathResolutionInfoProvider();
            KernelConfig kernelConfig = ArgumentsKt.getConfig((KernelArgs)kernelArgs);
            ReplConfig replConfig = ReplConfig.Companion.create$default(ReplConfig.Companion, libraryInfoProvider, kernelArgs.getHomeDir(), false, 4, null);
            IkotlinKt.kernelServer$default(kernelConfig, replConfig, null, null, 12, null);
        }
        catch (Exception e) {
            ConfigKt.getLog().error("exception running kernel with args: \"" + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, null, (int)63, null) + '\"', (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void embedKernel(@NotNull File cfgFile, @Nullable ResolutionInfoProvider resolutionInfoProvider2, @Nullable List<? extends Object> scriptReceivers2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)cfgFile, (String)"cfgFile");
        String string = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.class.path\")");
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        String[] $this$toTypedArray$iv = (String[])StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = thisCollection$iv.toArray(new String[0]);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        List cp = (List)destination$iv$iv;
        KernelConfig kernelConfig = ArgumentsKt.getConfig((KernelArgs)new KernelArgs(cfgFile, cp, null, null, null));
        ResolutionInfoProvider resolutionInfoProvider3 = resolutionInfoProvider2;
        if (resolutionInfoProvider3 == null) {
            resolutionInfoProvider3 = EmptyResolutionInfoProvider.INSTANCE;
        }
        ReplConfig replConfig = ReplConfig.Companion.create(resolutionInfoProvider3, null, true);
        List list = scriptReceivers2;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        IkotlinKt.kernelServer$default(kernelConfig, replConfig, null, list, 4, null);
    }

    public static /* synthetic */ void embedKernel$default(File file, ResolutionInfoProvider resolutionInfoProvider2, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        IkotlinKt.embedKernel(file, resolutionInfoProvider2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void kernelServer(@NotNull KernelConfig kernelConfig, @NotNull ReplConfig replConfig, @NotNull ReplRuntimeProperties runtimeProperties2, @NotNull List<? extends Object> scriptReceivers2) {
        Intrinsics.checkNotNullParameter((Object)kernelConfig, (String)"kernelConfig");
        Intrinsics.checkNotNullParameter((Object)replConfig, (String)"replConfig");
        Intrinsics.checkNotNullParameter((Object)runtimeProperties2, (String)"runtimeProperties");
        Intrinsics.checkNotNullParameter(scriptReceivers2, (String)"scriptReceivers");
        ConfigKt.getLog().info("Starting server with config: " + kernelConfig);
        Closeable closeable = new JupyterConnectionImpl(kernelConfig);
        Throwable throwable = null;
        try {
            JupyterConnectionInternal conn = (JupyterConnectionInternal)((Object)closeable);
            boolean bl = false;
            IkotlinKt.printClassPath();
            ConfigKt.getLog().info("Begin listening for events");
            AtomicLong executionCount = new AtomicLong(1L);
            CommManagerImpl commManager2 = new CommManagerImpl(conn);
            ReplForJupyter repl = new DefaultReplFactory(kernelConfig, replConfig, runtimeProperties2, scriptReceivers2, conn, commManager2).createRepl();
            Thread mainThread = Thread.currentThread();
            conn.addMessageCallback(ConnectionKt.rawMessageCallback((JupyterSocketType)JupyterSocketType.CONTROL, null, (Function1)((Function1)new Function1<RawMessage, Unit>(conn, repl){
                final /* synthetic */ JupyterConnectionInternal $conn;
                final /* synthetic */ ReplForJupyter $repl;
                {
                    this.$conn = $conn;
                    this.$repl = $repl;
                    super(1);
                }

                public final void invoke(@NotNull RawMessage rawMessage) {
                    Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
                    ProtocolKt.controlMessagesHandler(this.$conn, rawMessage, this.$repl);
                }
            })));
            conn.addMessageCallback(ConnectionKt.rawMessageCallback((JupyterSocketType)JupyterSocketType.SHELL, null, (Function1)((Function1)new Function1<RawMessage, Unit>(conn, repl, commManager2, executionCount){
                final /* synthetic */ JupyterConnectionInternal $conn;
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ CommManagerImpl $commManager;
                final /* synthetic */ AtomicLong $executionCount;
                {
                    this.$conn = $conn;
                    this.$repl = $repl;
                    this.$commManager = $commManager;
                    this.$executionCount = $executionCount;
                    super(1);
                }

                public final void invoke(@NotNull RawMessage rawMessage) {
                    Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
                    this.$conn.updateSessionInfo(rawMessage);
                    ProtocolKt.shellMessagesHandler(this.$conn, rawMessage, this.$repl, this.$commManager, this.$executionCount);
                }
            })));
            Thread controlThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(mainThread, conn){
                final /* synthetic */ Thread $mainThread;
                final /* synthetic */ JupyterConnectionInternal $conn;
                {
                    this.$mainThread = $mainThread;
                    this.$conn = $conn;
                    super(0);
                }

                public final void invoke() {
                    Thread[] threadArray = new Thread[1];
                    Intrinsics.checkNotNullExpressionValue((Object)this.$mainThread, (String)"mainThread");
                    IkotlinKt.access$kernelServer$lambda$6$socketLoop("Control: Interrupted", threadArray, (Function0)new Function0<Unit>(this.$conn){
                        final /* synthetic */ JupyterConnectionInternal $conn;
                        {
                            this.$conn = $conn;
                            super(0);
                        }

                        public final void invoke() {
                            this.$conn.getControl().runCallbacksOnMessage();
                        }
                    });
                }
            }), (int)31, null);
            Thread hbThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(mainThread, conn){
                final /* synthetic */ Thread $mainThread;
                final /* synthetic */ JupyterConnectionInternal $conn;
                {
                    this.$mainThread = $mainThread;
                    this.$conn = $conn;
                    super(0);
                }

                public final void invoke() {
                    Thread[] threadArray = new Thread[1];
                    Intrinsics.checkNotNullExpressionValue((Object)this.$mainThread, (String)"mainThread");
                    IkotlinKt.access$kernelServer$lambda$6$socketLoop("Heartbeat: Interrupted", threadArray, (Function0)new Function0<Unit>(this.$conn){
                        final /* synthetic */ JupyterConnectionInternal $conn;
                        {
                            this.$conn = $conn;
                            super(0);
                        }

                        public final void invoke() {
                            this.$conn.getHeartbeat().onData((Function2)kernelServer.1.hbThread.1.INSTANCE);
                        }
                    });
                }
            }), (int)31, null);
            Thread[] threadArray = new Thread[]{controlThread2, hbThread2};
            IkotlinKt.kernelServer$lambda$6$socketLoop("Main: Interrupted", threadArray, (Function0<Unit>)((Function0)new Function0<Unit>(conn){
                final /* synthetic */ JupyterConnectionInternal $conn;
                {
                    this.$conn = $conn;
                    super(0);
                }

                public final void invoke() {
                    this.$conn.getShell().runCallbacksOnMessage();
                }
            }));
            try {
                controlThread2.join();
                hbThread2.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConfigKt.getLog().info("Shutdown server");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void kernelServer$default(KernelConfig kernelConfig, ReplConfig replConfig, ReplRuntimeProperties replRuntimeProperties, List list, int n, Object object) {
        if ((n & 4) != 0) {
            replRuntimeProperties = ConfigKt.getDefaultRuntimeProperties();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        IkotlinKt.kernelServer(kernelConfig, replConfig, replRuntimeProperties, list);
    }

    private static final void kernelServer$lambda$6$socketLoop(String interruptedMessage, Thread[] threadsToInterrupt, Function0<Unit> loopBody) {
        while (true) {
            try {
                loopBody.invoke();
            }
            catch (InterruptedException e) {
                ConfigKt.getLog().debug(interruptedMessage);
                Thread[] $this$forEach$iv = threadsToInterrupt;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    Thread element$iv;
                    Thread it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    it.interrupt();
                }
                return;
            }
        }
    }

    public static final /* synthetic */ void access$kernelServer$lambda$6$socketLoop(String interruptedMessage, Thread[] threadsToInterrupt, Function0 loopBody) {
        IkotlinKt.kernelServer$lambda$6$socketLoop(interruptedMessage, threadsToInterrupt, (Function0<Unit>)loopBody);
    }

    static {
        Class<?> clazz = new Object(){}.getClass().getEnclosingClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"object {}::class.java.enclosingClass");
        iKotlinClass = clazz;
    }
}

