/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.JupyterClientDetector;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J5\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0004\u0012\u0004\u0012\u00020\u000e0\fH\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterClientDetector;", "", "()V", "detectors", "", "Lorg/jetbrains/kotlinx/jupyter/JupyterClientDetector$Detector;", "detect", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "detector", "org/jetbrains/kotlinx/jupyter/JupyterClientDetector$detector$1", "type", "predicate", "Lkotlin/Function2;", "", "", "(Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlinx/jupyter/JupyterClientDetector$detector$1;", "doDetect", "Detector", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nJupyterClientDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterClientDetector.kt\norg/jetbrains/kotlinx/jupyter/JupyterClientDetector\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n26#2:61\n288#3,2:62\n*S KotlinDebug\n*F\n+ 1 JupyterClientDetector.kt\norg/jetbrains/kotlinx/jupyter/JupyterClientDetector\n*L\n23#1:61\n26#1:62,2\n*E\n"})
public final class JupyterClientDetector {
    @NotNull
    public static final JupyterClientDetector INSTANCE = new JupyterClientDetector();
    @NotNull
    private static final List<Detector> detectors;

    private JupyterClientDetector() {
    }

    @NotNull
    public final JupyterClientType detect() {
        JupyterClientType jupyterClientType2;
        try {
            jupyterClientType2 = this.doDetect();
        }
        catch (LinkageError e) {
            ConfigKt.getLog().error("Unable to detect Jupyter client type because of incompatible JVM version", (Throwable)e);
            jupyterClientType2 = JupyterClientType.UNKNOWN;
        }
        return jupyterClientType2;
    }

    private final JupyterClientType doDetect() {
        ConfigKt.getLog().info("Detecting Jupyter client type");
        ProcessHandle currentHandle = ProcessHandle.current();
        List ancestors2 = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)currentHandle, (Function1)doDetect.ancestors.1.INSTANCE));
        for (ProcessHandle handle : ancestors2) {
            Object v1;
            block2: {
                ProcessHandle.Info info = handle.info();
                String command = info.command().orElse("");
                boolean $i$f$emptyArray = false;
                String[] stringArray = info.arguments().orElse(new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"info.arguments().orElse(emptyArray())");
                List arguments = ArraysKt.toList((Object[])stringArray);
                ConfigKt.getLog().info("Inspecting process: " + command + ' ' + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                Iterable $this$firstOrNull$iv = detectors;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Detector it = (Detector)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)command, (String)"command");
                    if (!it.isThisClient(command, arguments)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Detector detector2 = v1;
            if (detector2 == null) continue;
            Detector correctDetector = detector2;
            ConfigKt.getLog().info("Detected type is " + correctDetector.getType());
            return correctDetector.getType();
        }
        ConfigKt.getLog().info("Client type has not been detected");
        return JupyterClientType.UNKNOWN;
    }

    private final detector.1 detector(JupyterClientType type, Function2<? super String, ? super List<String>, Boolean> predicate) {
        return new Detector(type, predicate){
            final /* synthetic */ JupyterClientType $type;
            final /* synthetic */ Function2<String, List<String>, Boolean> $predicate;
            {
                this.$type = $type;
                this.$predicate = $predicate;
            }

            @NotNull
            public JupyterClientType getType() {
                return this.$type;
            }

            public boolean isThisClient(@NotNull String command, @NotNull List<String> arguments) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
                return (Boolean)this.$predicate.invoke((Object)command, arguments);
            }
        };
    }

    static {
        Object[] objectArray = new Detector[]{INSTANCE.detector(JupyterClientType.JUPYTER_NOTEBOOK, (Function2<? super String, ? super List<String>, Boolean>)((Function2)detectors.1.INSTANCE)), INSTANCE.detector(JupyterClientType.JUPYTER_LAB, (Function2<? super String, ? super List<String>, Boolean>)((Function2)detectors.2.INSTANCE)), INSTANCE.detector(JupyterClientType.KERNEL_TESTS, (Function2<? super String, ? super List<String>, Boolean>)((Function2)detectors.3.INSTANCE))};
        detectors = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\bb\u0018\u00002\u00020\u0001J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterClientDetector$Detector;", "", "type", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "getType", "()Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "isThisClient", "", "command", "", "arguments", "", "kotlin-jupyter-kernel"})
    private static interface Detector {
        @NotNull
        public JupyterClientType getType();

        public boolean isThisClient(@NotNull String var1, @NotNull List<String> var2);
    }
}

