/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.JupyterExecutorImpl;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.messaging.InputReply;
import org.jetbrains.kotlinx.jupyter.messaging.InputRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternal;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.KernelStatus;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageData;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.StatusReply;
import org.jetbrains.kotlinx.jupyter.protocol.AbstractJupyterConnection;
import org.jetbrains.kotlinx.jupyter.protocol.HMAC;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketInfo;
import org.jetbrains.kotlinx.jupyter.protocol.SocketWrapperKt;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;
import org.zeromq.ZMQ;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001KB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u00020:2\b\u0010<\u001a\u0004\u0018\u00010\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020:0>H\u0016J\u0010\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020\u00182\u0006\u0010C\u001a\u00020DH\u0002J\u001a\u0010E\u001a\u00020:2\u0006\u0010F\u001a\u00020G2\b\u0010<\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010H\u001a\u00020:2\b\u0010I\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010J\u001a\u00020:2\u0006\u0010I\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001aR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001aR\u0014\u00101\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001aR\u0018\u00103\u001a\u000604R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010.\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterConnectionImpl;", "Lorg/jetbrains/kotlinx/jupyter/protocol/AbstractJupyterConnection;", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterConnectionInternal;", "Ljava/io/Closeable;", "config", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "(Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;)V", "_contextMessage", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "_messageId", "", "", "_sessionId", "", "_username", "getConfig", "()Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "context", "Lorg/zeromq/ZMQ$Context;", "kotlin.jvm.PlatformType", "contextMessage", "getContextMessage", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "control", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "getControl", "()Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "debugPort", "", "getDebugPort", "()Ljava/lang/Integer;", "executor", "Lorg/jetbrains/kotlinx/jupyter/JupyterExecutor;", "getExecutor", "()Lorg/jetbrains/kotlinx/jupyter/JupyterExecutor;", "heartbeat", "getHeartbeat", "hmac", "Lorg/jetbrains/kotlinx/jupyter/protocol/HMAC;", "iopub", "getIopub", "messageId", "getMessageId", "()Ljava/util/List;", "sessionId", "getSessionId", "()Ljava/lang/String;", "shell", "getShell", "stdin", "getStdin", "stdinIn", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnectionImpl$StdinInputStream;", "getStdinIn", "()Lorg/jetbrains/kotlinx/jupyter/JupyterConnectionImpl$StdinInputStream;", "username", "getUsername", "close", "", "doWrappedInBusyIdle", "incomingMessage", "action", "Lkotlin/Function0;", "fromSocketType", "type", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterSocketType;", "openSocket", "socketInfo", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketInfo;", "sendStatus", "status", "Lorg/jetbrains/kotlinx/jupyter/messaging/KernelStatus;", "setContextMessage", "message", "updateSessionInfo", "StdinInputStream", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nconnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 connection.kt\norg/jetbrains/kotlinx/jupyter/JupyterConnectionImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class JupyterConnectionImpl
extends AbstractJupyterConnection
implements JupyterConnectionInternal,
Closeable {
    @NotNull
    private final KernelConfig config;
    @NotNull
    private List<byte[]> _messageId;
    @NotNull
    private String _sessionId;
    @NotNull
    private String _username;
    @NotNull
    private final HMAC hmac;
    private final ZMQ.Context context;
    @NotNull
    private final JupyterSocket heartbeat;
    @NotNull
    private final JupyterSocket shell;
    @NotNull
    private final JupyterSocket control;
    @NotNull
    private final JupyterSocket stdin;
    @NotNull
    private final JupyterSocket iopub;
    @NotNull
    private final StdinInputStream stdinIn;
    @Nullable
    private RawMessage _contextMessage;
    @NotNull
    private final JupyterExecutor executor;

    public JupyterConnectionImpl(@NotNull KernelConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        byte[] byArray = new byte[]{1};
        this._messageId = CollectionsKt.listOf((Object)byArray);
        this._sessionId = "";
        this._username = "";
        this.hmac = new HMAC(StringsKt.replace$default((String)this.getConfig().getSignatureScheme(), (String)"-", (String)"", (boolean)false, (int)4, null), this.getConfig().getSignatureKey());
        this.context = ZMQ.context((int)1);
        this.heartbeat = this.openSocket(JupyterSocketInfo.HB);
        this.shell = this.openSocket(JupyterSocketInfo.SHELL);
        this.control = this.openSocket(JupyterSocketInfo.CONTROL);
        this.stdin = this.openSocket(JupyterSocketInfo.STDIN);
        this.iopub = this.openSocket(JupyterSocketInfo.IOPUB);
        this.stdinIn = new StdinInputStream();
        this.executor = new JupyterExecutorImpl();
    }

    @Override
    @NotNull
    public KernelConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public List<byte[]> getMessageId() {
        return this._messageId;
    }

    @Override
    @NotNull
    public String getSessionId() {
        return this._sessionId;
    }

    @Override
    @NotNull
    public String getUsername() {
        return this._username;
    }

    private final JupyterSocket openSocket(JupyterSocketInfo socketInfo) {
        ZMQ.Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return SocketWrapperKt.openServerSocket((JupyterSocketInfo)socketInfo, (ZMQ.Context)context, (HMAC)this.hmac, (KernelConfig)this.getConfig());
    }

    @Override
    @NotNull
    public JupyterSocket getHeartbeat() {
        return this.heartbeat;
    }

    @Override
    @NotNull
    public JupyterSocket getShell() {
        return this.shell;
    }

    @Override
    @NotNull
    public JupyterSocket getControl() {
        return this.control;
    }

    @Override
    @NotNull
    public JupyterSocket getStdin() {
        return this.stdin;
    }

    @Override
    @NotNull
    public JupyterSocket getIopub() {
        return this.iopub;
    }

    @NotNull
    protected JupyterSocket fromSocketType(@NotNull JupyterSocketType type) {
        JupyterSocket jupyterSocket;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                jupyterSocket = this.getHeartbeat();
                break;
            }
            case 2: {
                jupyterSocket = this.getShell();
                break;
            }
            case 3: {
                jupyterSocket = this.getControl();
                break;
            }
            case 4: {
                jupyterSocket = this.getStdin();
                break;
            }
            case 5: {
                jupyterSocket = this.getIopub();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jupyterSocket;
    }

    @Override
    public void updateSessionInfo(@NotNull RawMessage message2) {
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        JsonObject header = message2.getHeader();
        Object object2 = (JsonElement)header.get((Object)"session");
        if (object2 != null && (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) != null && (object2 = object2.getContent()) != null) {
            it = object2;
            boolean bl = false;
            this._sessionId = it;
        }
        if ((object = (JsonElement)header.get((Object)"username")) != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = object.getContent()) != null) {
            it = object;
            boolean bl = false;
            this._sessionId = it;
        }
        this._messageId = message2.getId();
    }

    @Override
    public void sendStatus(@NotNull KernelStatus status, @Nullable RawMessage incomingMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        RawMessage rawMessage = incomingMessage;
        Message message2 = rawMessage != null ? MessageKt.makeReplyMessage$default(rawMessage, MessageType.STATUS, null, null, null, null, new StatusReply(status), 60, null) : JupyterConnectionInternalKt.makeSimpleMessage(this, MessageType.STATUS, new StatusReply(status));
        JupyterConnectionInternalKt.sendMessage(this.getIopub(), message2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWrappedInBusyIdle(@Nullable RawMessage incomingMessage, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.sendStatus(KernelStatus.BUSY, incomingMessage);
        try {
            action.invoke();
        }
        finally {
            this.sendStatus(KernelStatus.IDLE, incomingMessage);
        }
    }

    @Override
    @NotNull
    public StdinInputStream getStdinIn() {
        return this.stdinIn;
    }

    @Override
    @Nullable
    public Integer getDebugPort() {
        return this.getConfig().getDebugPort();
    }

    @Override
    public void setContextMessage(@Nullable RawMessage message2) {
        this._contextMessage = message2;
    }

    @Override
    @Nullable
    public RawMessage getContextMessage() {
        return this._contextMessage;
    }

    @Override
    @NotNull
    public JupyterExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void close() {
        this.getHeartbeat().close();
        this.getShell().close();
        this.getControl().close();
        this.getStdin().close();
        this.getIopub().close();
        this.context.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterConnectionImpl$StdinInputStream;", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlinx/jupyter/JupyterConnectionImpl;)V", "currentBuf", "", "currentBufPos", "", "getInput", "", "initializeCurrentBuf", "read", "b", "off", "len", "kotlin-jupyter-kernel"})
    public final class StdinInputStream
    extends InputStream {
        @Nullable
        private byte[] currentBuf;
        private int currentBufPos;

        private final String getInput() {
            MessageContent messageContent;
            JupyterSocket jupyterSocket = JupyterConnectionImpl.this.getStdin();
            RawMessage rawMessage = JupyterConnectionImpl.this.getContextMessage();
            Intrinsics.checkNotNull((Object)rawMessage);
            JupyterConnectionInternalKt.sendMessage(jupyterSocket, MessageKt.makeReplyMessage$default(rawMessage, MessageType.INPUT_REQUEST, null, null, null, null, new InputRequest("stdin:", false, 2, null), 60, null));
            JupyterSocket jupyterSocket2 = JupyterConnectionImpl.this.getStdin();
            byte[] byArray = JupyterConnectionImpl.this.getStdin().getSocket().recv();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stdin.socket.recv()");
            Message msg = ConnectionKt.receiveMessage(jupyterSocket2, byArray);
            Object object = msg;
            MessageContent messageContent2 = messageContent = object != null && (object = ((Message)object).getData()) != null ? ((MessageData)object).getContent() : null;
            InputReply content = messageContent instanceof InputReply ? (InputReply)messageContent : null;
            Object object2 = content;
            if (object2 == null || (object2 = object2.getValue()) == null) {
                throw new UnsupportedOperationException("Unexpected input message " + msg);
            }
            return object2;
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] initializeCurrentBuf() {
            byte[] byArray;
            byte[] buf = this.currentBuf;
            if (buf != null) {
                byArray = buf;
            } else {
                void var2_3;
                String string = this.getInput();
                byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                byte[] newBuf = byArray2;
                this.currentBuf = newBuf;
                this.currentBufPos = 0;
                byArray = var2_3;
            }
            return byArray;
        }

        @Override
        public synchronized int read() {
            byte[] buf = this.initializeCurrentBuf();
            if (this.currentBufPos >= buf.length) {
                this.currentBuf = null;
                return -1;
            }
            int n = this.currentBufPos;
            this.currentBufPos = n + 1;
            return buf[n];
        }

        @Override
        public synchronized int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            byte[] buf = this.initializeCurrentBuf();
            int lenLeft = buf.length - this.currentBufPos;
            if (lenLeft <= 0) {
                this.currentBuf = null;
                return -1;
            }
            int lenToRead = Math.min(len, lenLeft);
            for (int i = 0; i < lenToRead; ++i) {
                b[off + i] = buf[this.currentBufPos + i];
            }
            this.currentBufPos += lenToRead;
            return lenToRead;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterSocketType.values().length];
            try {
                nArray[JupyterSocketType.HB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterSocketType.SHELL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterSocketType.CONTROL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterSocketType.STDIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterSocketType.IOPUB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

