/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ExecutionResult;
import org.jetbrains.kotlinx.jupyter.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J9\u0010\n\u001a\u00020\t2'\u0010\u000b\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f\u00a2\u0006\u0002\b\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0004\b\u0000\u0010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterExecutorImpl;", "Lorg/jetbrains/kotlinx/jupyter/JupyterExecutor;", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentExecutions", "", "Ljava/lang/Thread;", "interruptExecutions", "", "launchJob", "runnable", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "runExecution", "Lorg/jetbrains/kotlinx/jupyter/ExecutionResult;", "T", "classLoader", "Ljava/lang/ClassLoader;", "body", "Lkotlin/Function0;", "kotlin-jupyter-kernel"})
public final class JupyterExecutorImpl
implements JupyterExecutor {
    @NotNull
    private final Set<Thread> currentExecutions;
    @NotNull
    private final CoroutineScope coroutineScope;

    public JupyterExecutorImpl() {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(ConcurrentHashMap())");
        this.currentExecutions = set;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }

    @Override
    @NotNull
    public <T> ExecutionResult<T> runExecution(@Nullable ClassLoader classLoader, @NotNull Function0<? extends T> body) {
        ExecutionResult executionResult;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Ref.ObjectRef execRes = new Ref.ObjectRef();
        Ref.ObjectRef execException = new Ref.ObjectRef();
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        Thread execThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, (ClassLoader)classLoader2, null, (int)0, (Function0)((Function0)new Function0<Unit>(execRes, body, (Ref.ObjectRef<Throwable>)execException){
            final /* synthetic */ Ref.ObjectRef<T> $execRes;
            final /* synthetic */ Function0<T> $body;
            final /* synthetic */ Ref.ObjectRef<Throwable> $execException;
            {
                this.$execRes = $execRes;
                this.$body = $body;
                this.$execException = $execException;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$execRes.element = this.$body.invoke();
                }
                catch (Throwable e) {
                    this.$execException.element = e;
                }
            }
        }), (int)27, null);
        this.currentExecutions.add(execThread2);
        execThread2.join();
        this.currentExecutions.remove(execThread2);
        Throwable exception = (Throwable)execException.element;
        if (exception == null) {
            Object object = execRes.element;
            Intrinsics.checkNotNull((Object)object);
            executionResult = new ExecutionResult.Success<Object>(object);
        } else {
            boolean isInterrupted = exception instanceof ThreadDeath || exception instanceof ReplException && ((ReplException)exception).getCause() instanceof ThreadDeath;
            executionResult = isInterrupted ? (ExecutionResult)ExecutionResult.Interrupted.INSTANCE : (ExecutionResult)new ExecutionResult.Failure(exception);
        }
        return executionResult;
    }

    @Override
    public void interruptExecutions() {
        while (!((Collection)this.currentExecutions).isEmpty()) {
            Thread execution;
            Thread thread = execution = (Thread)CollectionsKt.firstOrNull((Iterable)this.currentExecutions);
            if (thread != null) {
                thread.stop();
            }
            TypeIntrinsics.asMutableCollection((Object)this.currentExecutions).remove(execution);
        }
    }

    @Override
    public void launchJob(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, runnable, (int)3, null);
    }
}

