/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jupyter.kotlin.JavaRuntime;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.CodeCellImpl;
import org.jetbrains.kotlinx.jupyter.DisplayContainerImpl;
import org.jetbrains.kotlinx.jupyter.EvalData;
import org.jetbrains.kotlinx.jupyter.JupyterClientDetector;
import org.jetbrains.kotlinx.jupyter.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.MutableNotebook;
import org.jetbrains.kotlinx.jupyter.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.api.DisplayResultWithCell;
import org.jetbrains.kotlinx.jupyter.api.HtmlData;
import org.jetbrains.kotlinx.jupyter.api.JREInfoProvider;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.MimeTypedResult;
import org.jetbrains.kotlinx.jupyter.api.RenderersProcessor;
import org.jetbrains.kotlinx.jupyter.api.ResultsAccessor;
import org.jetbrains.kotlinx.jupyter.api.VariableState;
import org.jetbrains.kotlinx.jupyter.api.libraries.ColorScheme;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommManager;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterConnection;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionRequest;
import org.jetbrains.kotlinx.jupyter.repl.impl.SharedReplContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010R\u001a\u00020\u00162\u0006\u0010S\u001a\u00020\u000f2\u0006\u0010T\u001a\u00020\u00112\u0006\u0010U\u001a\u00020VH\u0016J\b\u0010W\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020\fH\u0016J\u000e\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\H\u0016J\u0010\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020\u000fH\u0016J\u0018\u0010`\u001a\b\u0012\u0004\u0012\u00020]0\\2\b\u0010_\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010_\u001a\u00020\u000fH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00162\u0006\u0010c\u001a\u00020\u000fH\u0016J\u0010\u0010d\u001a\u00020e2\u0006\u0010U\u001a\u00020fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u0015j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00160+j\b\u0012\u0004\u0012\u00020\u0016`,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001b\u00101\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b2\u00103R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010:\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\"R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001bR\u000e\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020B8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0014\u0010E\u001a\u00020FX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010I\u001a\u0004\u0018\u00010JX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR \u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020P0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0013\u00a8\u0006g"}, d2={"Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;", "Lorg/jetbrains/kotlinx/jupyter/MutableNotebook;", "runtimeProperties", "Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;", "connection", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterConnection;", "commManager", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;", "explicitClientType", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "(Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterConnection;Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;)V", "_currentColorScheme", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ColorScheme;", "cellVariables", "", "", "", "", "getCellVariables", "()Ljava/util/Map;", "cells", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlinx/jupyter/MutableCodeCell;", "Lkotlin/collections/HashMap;", "cellsList", "", "getCellsList", "()Ljava/util/Collection;", "getCommManager", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;", "getConnection", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterConnection;", "currentCell", "getCurrentCell", "()Lorg/jetbrains/kotlinx/jupyter/MutableCodeCell;", "currentColorScheme", "getCurrentColorScheme", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/ColorScheme;", "displays", "Lorg/jetbrains/kotlinx/jupyter/DisplayContainerImpl;", "getDisplays", "()Lorg/jetbrains/kotlinx/jupyter/DisplayContainerImpl;", "history", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "jreInfo", "Lorg/jetbrains/kotlinx/jupyter/api/JREInfoProvider;", "getJreInfo", "()Lorg/jetbrains/kotlinx/jupyter/api/JREInfoProvider;", "jupyterClientType", "getJupyterClientType", "()Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "jupyterClientType$delegate", "Lkotlin/Lazy;", "kernelVersion", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "getKernelVersion", "()Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "lastCell", "getLastCell", "libraryRequests", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionRequest;", "getLibraryRequests", "mainCellCreated", "", "renderersProcessor", "Lorg/jetbrains/kotlinx/jupyter/api/RenderersProcessor;", "getRenderersProcessor", "()Lorg/jetbrains/kotlinx/jupyter/api/RenderersProcessor;", "resultsAccessor", "Lorg/jetbrains/kotlinx/jupyter/api/ResultsAccessor;", "getResultsAccessor", "()Lorg/jetbrains/kotlinx/jupyter/api/ResultsAccessor;", "sharedReplContext", "Lorg/jetbrains/kotlinx/jupyter/repl/impl/SharedReplContext;", "getSharedReplContext", "()Lorg/jetbrains/kotlinx/jupyter/repl/impl/SharedReplContext;", "setSharedReplContext", "(Lorg/jetbrains/kotlinx/jupyter/repl/impl/SharedReplContext;)V", "variablesState", "Lorg/jetbrains/kotlinx/jupyter/api/VariableState;", "getVariablesState", "addCell", "internalId", "preprocessedCode", "data", "Lorg/jetbrains/kotlinx/jupyter/EvalData;", "beginEvalSession", "", "changeColorScheme", "newScheme", "getAllDisplays", "", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResultWithCell;", "getCell", "id", "getDisplaysById", "getResult", "", "before", "renderHtmlAsIFrame", "Lorg/jetbrains/kotlinx/jupyter/api/MimeTypedResult;", "Lorg/jetbrains/kotlinx/jupyter/api/HtmlData;", "kotlin-jupyter-kernel"})
public final class NotebookImpl
implements MutableNotebook {
    @NotNull
    private final ReplRuntimeProperties runtimeProperties;
    @NotNull
    private final JupyterConnection connection;
    @NotNull
    private final CommManager commManager;
    @Nullable
    private final JupyterClientType explicitClientType;
    @NotNull
    private final HashMap<Integer, MutableCodeCell> cells;
    @Nullable
    private SharedReplContext sharedReplContext;
    @NotNull
    private final ResultsAccessor resultsAccessor;
    @NotNull
    private final ArrayList<MutableCodeCell> history;
    private boolean mainCellCreated;
    @NotNull
    private final DisplayContainerImpl displays;
    @NotNull
    private final Lazy jupyterClientType$delegate;
    @NotNull
    private ColorScheme _currentColorScheme;

    public NotebookImpl(@NotNull ReplRuntimeProperties runtimeProperties2, @NotNull JupyterConnection connection2, @NotNull CommManager commManager2, @Nullable JupyterClientType explicitClientType2) {
        Intrinsics.checkNotNullParameter((Object)runtimeProperties2, (String)"runtimeProperties");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)commManager2, (String)"commManager");
        this.runtimeProperties = runtimeProperties2;
        this.connection = connection2;
        this.commManager = commManager2;
        this.explicitClientType = explicitClientType2;
        this.cells = new HashMap();
        this.resultsAccessor = new ResultsAccessor(this){
            final /* synthetic */ NotebookImpl this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final Object get(int it) {
                return this.this$0.getResult(it);
            }
        };
        this.history = new ArrayList();
        this.displays = new DisplayContainerImpl();
        this.jupyterClientType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JupyterClientType>(this){
            final /* synthetic */ NotebookImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JupyterClientType invoke() {
                JupyterClientType jupyterClientType2 = NotebookImpl.access$getExplicitClientType$p(this.this$0);
                if (jupyterClientType2 == null) {
                    jupyterClientType2 = JupyterClientDetector.INSTANCE.detect();
                }
                return jupyterClientType2;
            }
        }));
        this._currentColorScheme = ColorScheme.LIGHT;
    }

    @NotNull
    public JupyterConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public CommManager getCommManager() {
        return this.commManager;
    }

    @Override
    @Nullable
    public SharedReplContext getSharedReplContext() {
        return this.sharedReplContext;
    }

    @Override
    public void setSharedReplContext(@Nullable SharedReplContext sharedReplContext) {
        this.sharedReplContext = sharedReplContext;
    }

    @NotNull
    public Collection<MutableCodeCell> getCellsList() {
        Collection<MutableCodeCell> collection = this.cells.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"cells.values");
        return collection;
    }

    @NotNull
    public Map<String, VariableState> getVariablesState() {
        Object object = this.getSharedReplContext();
        if (object == null || (object = ((SharedReplContext)object).getEvaluator()) == null || (object = object.getVariablesHolder()) == null) {
            throw new IllegalStateException("Evaluator is not initialized yet");
        }
        return object;
    }

    @NotNull
    public Map<Integer, Set<String>> getCellVariables() {
        Object object = this.getSharedReplContext();
        if (object == null || (object = ((SharedReplContext)object).getEvaluator()) == null || (object = object.getCellVariables()) == null) {
            throw new IllegalStateException("Evaluator is not initialized yet");
        }
        return object;
    }

    @NotNull
    public ResultsAccessor getResultsAccessor() {
        return this.resultsAccessor;
    }

    @NotNull
    public MutableCodeCell getCell(int id) {
        MutableCodeCell mutableCodeCell = this.cells.get(id);
        if (mutableCodeCell == null) {
            throw new ArrayIndexOutOfBoundsException("There is no cell with number '" + id + '\'');
        }
        return mutableCodeCell;
    }

    @Nullable
    public Object getResult(int id) {
        return this.getCell(id).getResult();
    }

    @Override
    @NotNull
    public DisplayContainerImpl getDisplays() {
        return this.displays;
    }

    @NotNull
    public List<DisplayResultWithCell> getAllDisplays() {
        return this.getDisplays().getAll();
    }

    @NotNull
    public List<DisplayResultWithCell> getDisplaysById(@Nullable String id) {
        return this.getDisplays().getById(id);
    }

    @NotNull
    public KotlinKernelVersion getKernelVersion() {
        KotlinKernelVersion kotlinKernelVersion = this.runtimeProperties.getVersion();
        if (kotlinKernelVersion == null) {
            throw new IllegalStateException("Kernel version is not known");
        }
        return kotlinKernelVersion;
    }

    @NotNull
    public JREInfoProvider getJreInfo() {
        return (JREInfoProvider)JavaRuntime.INSTANCE;
    }

    @NotNull
    public JupyterClientType getJupyterClientType() {
        Lazy lazy = this.jupyterClientType$delegate;
        return (JupyterClientType)lazy.getValue();
    }

    @Override
    @NotNull
    public MutableCodeCell addCell(int internalId, @NotNull String preprocessedCode, @NotNull EvalData data) {
        Intrinsics.checkNotNullParameter((Object)preprocessedCode, (String)"preprocessedCode");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CodeCellImpl cell2 = new CodeCellImpl(this, data.getExecutionCounter(), internalId, data.getRawCode(), preprocessedCode, this.getLastCell());
        ((Map)this.cells).put(data.getExecutionCounter(), cell2);
        this.history.add(cell2);
        this.mainCellCreated = true;
        return cell2;
    }

    @Override
    public void beginEvalSession() {
        this.mainCellCreated = false;
    }

    @Nullable
    public MutableCodeCell history(int before) {
        int offset = this.mainCellCreated ? 1 : 0;
        return (MutableCodeCell)CollectionsKt.getOrNull((List)this.history, (int)(this.history.size() - offset - before));
    }

    @NotNull
    public ColorScheme getCurrentColorScheme() {
        return this._currentColorScheme;
    }

    public void changeColorScheme(@NotNull ColorScheme newScheme) {
        Intrinsics.checkNotNullParameter((Object)newScheme, (String)"newScheme");
        this._currentColorScheme = newScheme;
        SharedReplContext sharedReplContext = this.getSharedReplContext();
        if (sharedReplContext == null) {
            return;
        }
        SharedReplContext context = sharedReplContext;
        context.getColorSchemeChangeCallbacksProcessor().schemeChanged(newScheme);
    }

    @NotNull
    public MimeTypedResult renderHtmlAsIFrame(@NotNull HtmlData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data.toIFrame(this._currentColorScheme);
    }

    @Override
    @Nullable
    public MutableCodeCell getCurrentCell() {
        return this.history(0);
    }

    @Nullable
    public MutableCodeCell getLastCell() {
        return this.history(1);
    }

    @NotNull
    public RenderersProcessor getRenderersProcessor() {
        SharedReplContext sharedReplContext = this.getSharedReplContext();
        if (sharedReplContext == null || (sharedReplContext = sharedReplContext.getRenderersProcessor()) == null) {
            throw new IllegalStateException("Type renderers processor is not initialized yet");
        }
        return (RenderersProcessor)sharedReplContext;
    }

    @NotNull
    public Collection<LibraryResolutionRequest> getLibraryRequests() {
        Collection collection;
        SharedReplContext sharedReplContext = this.getSharedReplContext();
        if ((sharedReplContext != null && (sharedReplContext = sharedReplContext.getLibrariesProcessor()) != null ? sharedReplContext.getRequests() : (collection = null)) == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public static final /* synthetic */ JupyterClientType access$getExplicitClientType$p(NotebookImpl $this) {
        return $this.explicitClientType;
    }
}

