/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.http4k.core.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResource;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceFallbacksBundle;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceLocation;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourcePathType;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.JsLibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionUtilKt;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResourcesProcessor;", "()V", "logger", "Lorg/slf4j/Logger;", "outputCounter", "", "loadBunch", "Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "bundle", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourceFallbacksBundle;", "classLoader", "Ljava/lang/ClassLoader;", "loadResourceAsText", "", "resource", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResource;", "wrapLibrary", "", "CodeScriptModifierFunctionGenerator", "ScriptModifierFunctionGenerator", "URLScriptModifierFunctionGenerator", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nJsLibraryResourcesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1549#2:150\n1620#2,3:151\n*S KotlinDebug\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor\n*L\n53#1:150\n53#1:151,3\n*E\n"})
public final class JsLibraryResourcesProcessor
implements LibraryResourcesProcessor {
    private int outputCounter;
    @NotNull
    private final Logger logger;

    public JsLibraryResourcesProcessor() {
        String string = Reflection.getOrCreateKotlinClass(JsLibraryResourcesProcessor.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.logger = LoggingKt.getLogger((String)string);
    }

    private final ScriptModifierFunctionGenerator loadBunch(ResourceFallbacksBundle bundle, ClassLoader classLoader) {
        List exceptions = new ArrayList();
        for (ResourceLocation resourceLocation : bundle.getLocations()) {
            ScriptModifierFunctionGenerator scriptModifierFunctionGenerator;
            String path = resourceLocation.getPath();
            try {
                ScriptModifierFunctionGenerator scriptModifierFunctionGenerator2;
                switch (WhenMappings.$EnumSwitchMapping$0[resourceLocation.getType().ordinal()]) {
                    case 1: {
                        scriptModifierFunctionGenerator2 = new URLScriptModifierFunctionGenerator(path);
                        break;
                    }
                    case 2: {
                        String scriptText = HttpUtilKt.getText((Response)((Response)HttpUtilKt.getHttp((String)path)));
                        scriptModifierFunctionGenerator2 = new CodeScriptModifierFunctionGenerator(scriptText);
                        break;
                    }
                    case 3: {
                        File file = new File(path);
                        this.logger.debug("Resolving resource file: " + file.getAbsolutePath());
                        scriptModifierFunctionGenerator2 = new CodeScriptModifierFunctionGenerator(FilesKt.readText$default((File)file, null, (int)1, null));
                        break;
                    }
                    case 4: {
                        String content = ResolutionUtilKt.loadResourceFromClassLoader(path, classLoader);
                        return new CodeScriptModifierFunctionGenerator(content);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                scriptModifierFunctionGenerator = scriptModifierFunctionGenerator2;
            }
            catch (IOException e) {
                exceptions.add(e);
                continue;
            }
            return scriptModifierFunctionGenerator;
        }
        throw new Exception("No resource fallback found! Related exceptions: " + exceptions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptModifierFunctionGenerator> loadResourceAsText(LibraryResource resource, ClassLoader classLoader) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resource.getBundles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceFallbacksBundle resourceFallbacksBundle = (ResourceFallbacksBundle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadBunch((ResourceFallbacksBundle)it, classLoader));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String wrapLibrary(@NotNull LibraryResource resource, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        String resourceName = resource.getName();
        String resourceIndex = "[\"" + resourceName + "\"]";
        String callResourceIndex = "[\"call_" + resourceName + "\"]";
        String elementId = "kotlin_out_" + this.outputCounter;
        ++this.outputCounter;
        List<ScriptModifierFunctionGenerator> generators = this.loadResourceAsText(resource, classLoader);
        String jsScriptModifiers2 = CollectionsKt.joinToString$default((Iterable)generators, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)wrapLibrary.jsScriptModifiers.1.INSTANCE, (int)24, null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n            if(!window.kotlinQueues) {\n                window.kotlinQueues = {};\n            }\n            if(!window.kotlinQueues").append(resourceIndex).append(") {\n                var resQueue = [];\n                window.kotlinQueues").append(resourceIndex).append(" = resQueue;\n                window").append(callResourceIndex).append(" = function(f) {\n                    resQueue.push(f);\n                }\n            }\n            (function (){\n                var modifiers = ").append(jsScriptModifiers2).append(";\n                var e = document.getElementById(\"").append(elementId).append("\");\n                modifiers.forEach(function (gen) {\n                    var script = document.createElement(\"script\");\n                    gen(script)\n                    script.addEventListener(\"load\", function() {\n                        window").append(callResourceIndex).append(" = function(f) {f();};\n                        window.kotlinQueues").append(resourceIndex).append(".forEach(function(f) {f();});\n                        window.kotlinQueues").append(resourceIndex).append(" = [];\n                    }, false);\n                    script.addEventListener(\"error\", function() {\n                        window").append(callResourceIndex).append(" = function(f) {};\n                        window.kotlinQueues").append(resourceIndex).append(" = [];\n                        var div = document.createElement(\"div\");\n                        div.style.color = 'darkred';\n                        div.textContent = 'Error loading resource ").append(resourceName).append("';\n                        document.getElementById(\"");
        stringBuilder.append(elementId).append("\").appendChild(div);\n                    }, false);\n                    \n                    e.appendChild(script);\n                });\n            })();\n        ");
        String wrapper = StringsKt.trimIndent((String)stringBuilder.toString());
        return StringsKt.trimIndent((String)("\n            <div id=\"" + elementId + "\"/>\n            <script type=\"text/javascript\">\n                " + wrapper + "\n            </script>\n        "));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "", "getScriptText", "", "kotlin-jupyter-kernel"})
    private static interface ScriptModifierFunctionGenerator {
        @NotNull
        public String getScriptText();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourcePathType.values().length];
            try {
                nArray[ResourcePathType.URL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.URL_EMBEDDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.LOCAL_PATH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.CLASSPATH_PATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$URLScriptModifierFunctionGenerator;", "Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "url", "", "(Ljava/lang/String;)V", "getScriptText", "kotlin-jupyter-kernel"})
    private static final class URLScriptModifierFunctionGenerator
    implements ScriptModifierFunctionGenerator {
        @NotNull
        private final String url;

        public URLScriptModifierFunctionGenerator(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @Override
        @NotNull
        public String getScriptText() {
            return StringsKt.trimIndent((String)("\n                (function(script) {\n                    script.src = \"" + this.url + "\"\n                    script.type = \"text/javascript\";\n                })\n            "));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$CodeScriptModifierFunctionGenerator;", "Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "code", "", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "(Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getScriptText", "kotlin-jupyter-kernel"})
    @SourceDebugExtension(value={"SMAP\nJsLibraryResourcesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$CodeScriptModifierFunctionGenerator\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 4 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,149:1\n113#2:150\n32#3:151\n80#4:152\n*S KotlinDebug\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$CodeScriptModifierFunctionGenerator\n*L\n122#1:150\n122#1:151\n122#1:152\n*E\n"})
    private static final class CodeScriptModifierFunctionGenerator
    implements ScriptModifierFunctionGenerator {
        @NotNull
        private final String code;

        public CodeScriptModifierFunctionGenerator(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getScriptText() {
            void $this$encodeToString$iv;
            StringFormat stringFormat = (StringFormat)Json.Default;
            String value$iv = this.code;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(String.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            String escapedCode = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv);
            return StringsKt.trimIndent((String)("\n                (function(script) {\n                    script.textContent = " + escapedCode + "\n                    script.type = \"text/javascript\";\n                })\n            "));
        }
    }
}

