/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesDefinitionDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesInstantiable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesProducerDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesScanResult;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRule;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRulesKt;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JF\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00132\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00160\u0015JE\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013H\u0002\u00a2\u0006\u0002\u0010\u001bJ:\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J2\u0010 \u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00160\u0015H\u0002JF\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0\u0015\"\f\b\u0000\u0010\"*\u0006\u0012\u0002\b\u00030\u001a*\b\u0012\u0004\u0012\u0002H\"0#2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00160#H\u0002R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner;", "", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "(Lorg/jetbrains/kotlinx/jupyter/api/Notebook;)V", "discardedFQNs", "", "", "Lorg/jetbrains/kotlinx/jupyter/api/TypeName;", "getNotebook", "()Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "processedFQNs", "addLibrariesFromClassLoader", "", "classLoader", "Ljava/lang/ClassLoader;", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "libraryOptions", "", "integrationTypeNameRules", "", "Lorg/jetbrains/kotlinx/jupyter/util/AcceptanceRule;", "instantiate", "T", "data", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;", "(Ljava/lang/ClassLoader;Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;Lorg/jetbrains/kotlinx/jupyter/api/Notebook;Ljava/util/Map;)Ljava/lang/Object;", "instantiateLibraries", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "scanResult", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesScanResult;", "scanForLibraries", "filterNamesToLoad", "I", "", "Companion", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nLibrariesScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 5 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,154:1\n766#2:155\n857#2,2:156\n1549#2:161\n1620#2,2:162\n1622#2:167\n1620#2,3:168\n1855#2,2:171\n113#3:158\n123#3:164\n32#4:159\n32#4:165\n80#5:160\n80#5:166\n*S KotlinDebug\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n*L\n31#1:155\n31#1:156,2\n63#1:161\n63#1:162,2\n63#1:167\n102#1:168,3\n108#1:171,2\n56#1:158\n65#1:164\n56#1:159\n65#1:165\n56#1:160\n65#1:166\n*E\n"})
public final class LibrariesScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Notebook notebook;
    @NotNull
    private final Set<String> processedFQNs;
    @NotNull
    private final Set<String> discardedFQNs;
    @NotNull
    private static final Logger log = LoggingKt.getLogger((String)"libraries scanning");

    public LibrariesScanner(@NotNull Notebook notebook2) {
        Intrinsics.checkNotNullParameter((Object)notebook2, (String)"notebook");
        this.notebook = notebook2;
        this.processedFQNs = new LinkedHashSet();
        this.discardedFQNs = new LinkedHashSet();
    }

    @NotNull
    public final Notebook getNotebook() {
        return this.notebook;
    }

    /*
     * WARNING - void declaration
     */
    private final <I extends LibrariesInstantiable<?>> List<I> filterNamesToLoad(Iterable<? extends I> $this$filterNamesToLoad, KotlinKernelHost host, Iterable<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$filterTo$iv$iv;
        Iterable<? extends I> $this$filter$iv = $this$filterNamesToLoad;
        boolean $i$f$filter = false;
        Iterable<? extends I> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            LibrariesInstantiable it = (LibrariesInstantiable)element$iv$iv;
            boolean bl2 = false;
            String typeName = it.getFqn();
            Object object = new Boolean[]{host.acceptsIntegrationTypeName(typeName), AcceptanceRulesKt.accepts(integrationTypeNameRules, (Object)typeName)};
            Boolean acceptance = AcceptanceRulesKt.unionAcceptance((Boolean[])object);
            log.debug("Acceptance result for " + typeName + ": " + acceptance);
            object = acceptance;
            if (Intrinsics.areEqual((Object)object, (Object)true)) {
                bl = this.processedFQNs.add(typeName);
            } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
                this.discardedFQNs.add(typeName);
                bl = false;
            } else if (object == null) {
                bl = !this.discardedFQNs.contains(typeName) && this.processedFQNs.add(typeName);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void addLibrariesFromClassLoader(@NotNull ClassLoader classLoader, @NotNull KotlinKernelHost host, @NotNull Map<String, String> libraryOptions, @NotNull List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter(integrationTypeNameRules, (String)"integrationTypeNameRules");
        LibrariesScanResult scanResult = this.scanForLibraries(classLoader, host, integrationTypeNameRules);
        StringBuilder stringBuilder = new StringBuilder().append("Scanning for libraries is done. Detected FQNs: ");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(LibrariesScanResult.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        log.debug(stringBuilder.append($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)scanResult)).toString());
        List<LibraryDefinition> libraries2 = this.instantiateLibraries(classLoader, scanResult, this.notebook, libraryOptions);
        log.debug("Number of detected definitions: " + libraries2.size());
        host.addLibraries((Collection)libraries2);
    }

    public static /* synthetic */ void addLibrariesFromClassLoader$default(LibrariesScanner librariesScanner2, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, Map map, List list, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        librariesScanner2.addLibrariesFromClassLoader(classLoader, kotlinKernelHost, map, list);
    }

    /*
     * WARNING - void declaration
     */
    private final LibrariesScanResult scanForLibraries(ClassLoader classLoader, KotlinKernelHost host, List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/kotlin-jupyter-libraries/libraries.json");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"classLoader.getResources\u2026TER_LIBRARIES_FILE_NAME\")");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
        Iterable iterable = arrayList;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            URL uRL = (URL)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
            void var14_14 = url;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)var14_14);
            String contents = new String(byArray, charset);
            StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(LibrariesScanResult.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            collection.add((LibrariesScanResult)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, contents));
        }
        List results = (List)destination$iv$iv;
        List definitions = new ArrayList();
        List producers = new ArrayList();
        for (LibrariesScanResult result2 : results) {
            definitions.addAll(result2.getDefinitions());
            producers.addAll(result2.getProducers());
        }
        return new LibrariesScanResult(LibrariesScanner.scanForLibraries$filterNames(definitions, this, host, integrationTypeNameRules), LibrariesScanner.scanForLibraries$filterNames(producers, this, host, integrationTypeNameRules));
    }

    static /* synthetic */ LibrariesScanResult scanForLibraries$default(LibrariesScanner librariesScanner2, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return librariesScanner2.scanForLibraries(classLoader, kotlinKernelHost, list);
    }

    private final List<LibraryDefinition> instantiateLibraries(ClassLoader classLoader, LibrariesScanResult scanResult, Notebook notebook2, Map<String, String> libraryOptions) {
        LibrariesProducerDeclaration declaration;
        List definitions = new ArrayList();
        Iterable $this$mapTo$iv = scanResult.getDefinitions();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            LibrariesDefinitionDeclaration librariesDefinitionDeclaration = (LibrariesDefinitionDeclaration)item$iv;
            Collection collection = definitions;
            boolean bl = false;
            collection.add((LibraryDefinition)LibrariesScanner.instantiateLibraries$withErrorsHandling((LibrariesInstantiable)declaration, (Function0)new Function0<LibraryDefinition>(this, classLoader, (LibrariesDefinitionDeclaration)declaration, notebook2, libraryOptions){
                final /* synthetic */ LibrariesScanner this$0;
                final /* synthetic */ ClassLoader $classLoader;
                final /* synthetic */ LibrariesDefinitionDeclaration $declaration;
                final /* synthetic */ Notebook $notebook;
                final /* synthetic */ Map<String, String> $libraryOptions;
                {
                    this.this$0 = $receiver;
                    this.$classLoader = $classLoader;
                    this.$declaration = $declaration;
                    this.$notebook = $notebook;
                    this.$libraryOptions = $libraryOptions;
                    super(0);
                }

                @NotNull
                public final LibraryDefinition invoke() {
                    return (LibraryDefinition)LibrariesScanner.access$instantiate(this.this$0, this.$classLoader, (LibrariesInstantiable)this.$declaration, this.$notebook, this.$libraryOptions);
                }
            }));
        }
        Iterable $this$forEach$iv = scanResult.getProducers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            declaration = (LibrariesProducerDeclaration)element$iv;
            boolean bl = false;
            LibrariesScanner.instantiateLibraries$withErrorsHandling((LibrariesInstantiable)declaration, (Function0)new Function0<Unit>(this, classLoader, declaration, notebook2, libraryOptions, (List<LibraryDefinition>)definitions){
                final /* synthetic */ LibrariesScanner this$0;
                final /* synthetic */ ClassLoader $classLoader;
                final /* synthetic */ LibrariesProducerDeclaration $declaration;
                final /* synthetic */ Notebook $notebook;
                final /* synthetic */ Map<String, String> $libraryOptions;
                final /* synthetic */ List<LibraryDefinition> $definitions;
                {
                    this.this$0 = $receiver;
                    this.$classLoader = $classLoader;
                    this.$declaration = $declaration;
                    this.$notebook = $notebook;
                    this.$libraryOptions = $libraryOptions;
                    this.$definitions = $definitions;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    LibraryDefinitionProducer producer = (LibraryDefinitionProducer)LibrariesScanner.access$instantiate(this.this$0, this.$classLoader, (LibrariesInstantiable)this.$declaration, this.$notebook, this.$libraryOptions);
                    Iterable iterable = producer.getDefinitions(this.$notebook);
                    List<LibraryDefinition> list = this.$definitions;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        LibraryDefinition it = (LibraryDefinition)element$iv;
                        boolean bl = false;
                        list.add(it);
                    }
                }
            });
        }
        return definitions;
    }

    private final <T> T instantiate(ClassLoader classLoader, LibrariesInstantiable<T> data, Notebook notebook2, Map<String, String> libraryOptions) {
        Object t;
        Class<?> clazz = classLoader.loadClass(data.getFqn());
        Object[] constructors = clazz.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructors, (String)"constructors");
        if (constructors.length == 0) {
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"clazz");
            return (T)JvmClassMappingKt.getKotlinClass(clazz).getObjectInstance();
        }
        Constructor constructor = (Constructor)ArraysKt.single((Object[])constructors);
        switch (constructor.getParameterCount()) {
            case 0: {
                t = constructor.newInstance(new Object[0]);
                break;
            }
            case 1: {
                Object[] objectArray = new Object[]{notebook2};
                t = constructor.newInstance(objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{notebook2, libraryOptions};
                t = constructor.newInstance(objectArray);
                break;
            }
            default: {
                throw new IllegalStateException("Only zero, one or two arguments are allowed for library class");
            }
        }
        return t;
    }

    private static final <I extends LibrariesInstantiable<?>> List<I> scanForLibraries$filterNames(Iterable<? extends I> $this$scanForLibraries_u24filterNames, LibrariesScanner this$0, KotlinKernelHost $host, List<? extends AcceptanceRule<String>> $integrationTypeNameRules) {
        return this$0.filterNamesToLoad($this$scanForLibraries_u24filterNames, $host, (Iterable<? extends AcceptanceRule<String>>)$integrationTypeNameRules);
    }

    private static final <T> T instantiateLibraries$withErrorsHandling(LibrariesInstantiable<?> declaration, Function0<? extends T> action) {
        Object object;
        try {
            object = action.invoke();
        }
        catch (Throwable e) {
            String errorMessage = "Failed to load library integration class '" + declaration.getFqn() + '\'';
            LoggingKt.errorForUser$default((Logger)log, null, (String)errorMessage, (Throwable)e, (int)1, null);
            throw new ReplException(errorMessage, e);
        }
        return (T)object;
    }

    public static final /* synthetic */ Object access$instantiate(LibrariesScanner $this, ClassLoader classLoader, LibrariesInstantiable data, Notebook notebook2, Map libraryOptions) {
        return $this.instantiate(classLoader, data, notebook2, libraryOptions);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin-jupyter-kernel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

