/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.Brackets;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryParsingUtilKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolutionInfoParser;
import org.jetbrains.kotlinx.jupyter.libraries.Parameter;
import org.jetbrains.kotlinx.jupyter.libraries.UtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"defaultParsers", "", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolutionInfoParser;", "parseReference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "string", "parseReferenceWithArgs", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "str", "parseResolutionInfo", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nlibraryParsingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 libraryParsingUtil.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryParsingUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1194#2,2:51\n1222#2,4:53\n*S KotlinDebug\n*F\n+ 1 libraryParsingUtil.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryParsingUtilKt\n*L\n49#1:51,2\n49#1:53,4\n*E\n"})
public final class LibraryParsingUtilKt {
    @NotNull
    private static final Map<String, LibraryResolutionInfoParser> defaultParsers;

    @NotNull
    public static final Pair<LibraryReference, List<Variable>> parseReferenceWithArgs(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Pair pair = UtilKt.parseLibraryName((String)str);
        String fullName = (String)pair.component1();
        List vars = (List)pair.component2();
        LibraryReference reference = LibraryParsingUtilKt.parseReference(fullName);
        return TuplesKt.to((Object)reference, (Object)vars);
    }

    private static final LibraryResolutionInfo parseResolutionInfo(String string) {
        if (StringsKt.isBlank((CharSequence)string)) {
            return new AbstractLibraryResolutionInfo.Default(null, 1, null);
        }
        Pair pair = UtilKt.parseCall((String)string, (Brackets)Brackets.Companion.getSQUARE());
        String type = (String)pair.component1();
        List vars = (List)pair.component2();
        LibraryResolutionInfoParser libraryResolutionInfoParser = defaultParsers.get(type);
        if (libraryResolutionInfoParser == null || (libraryResolutionInfoParser = libraryResolutionInfoParser.getInfo(vars)) == null) {
            libraryResolutionInfoParser = new AbstractLibraryResolutionInfo.Default(type);
        }
        return libraryResolutionInfoParser;
    }

    private static final LibraryReference parseReference(String string) {
        int sepIndex = StringsKt.indexOf$default((CharSequence)string, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (sepIndex == -1) {
            return new LibraryReference((LibraryResolutionInfo)new AbstractLibraryResolutionInfo.Default(null, 1, null), string);
        }
        String string2 = string.substring(0, sepIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String nameString = string2;
        String string3 = string.substring(sepIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String infoString = string3;
        LibraryResolutionInfo info = LibraryParsingUtilKt.parseResolutionInfo(infoString);
        return new LibraryReference(info, nameString);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Object[] objectArray = new LibraryResolutionInfoParser[]{LibraryResolutionInfoParser.Companion.make("ref", CollectionsKt.listOf((Object)new Parameter.Required("ref")), (Function1)defaultParsers.1.INSTANCE), LibraryResolutionInfoParser.Companion.make("file", CollectionsKt.listOf((Object)new Parameter.Required("path")), (Function1)defaultParsers.2.INSTANCE), LibraryResolutionInfoParser.Companion.make("dir", CollectionsKt.listOf((Object)new Parameter.Required("dir")), (Function1)defaultParsers.3.INSTANCE), LibraryResolutionInfoParser.Companion.make("url", CollectionsKt.listOf((Object)new Parameter.Required("url")), (Function1)defaultParsers.4.INSTANCE), LibraryResolutionInfoParser.Companion.make("classpath", CollectionsKt.emptyList(), (Function1)defaultParsers.5.INSTANCE)};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LibraryResolutionInfoParser libraryResolutionInfoParser = (LibraryResolutionInfoParser)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        defaultParsers = destination$iv$iv;
    }
}

