/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.common.ExceptionsHandler;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultInfoLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultInfoSwitch;
import org.jetbrains.kotlinx.jupyter.libraries.FallbackLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.LocalLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoSwitcher;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionUtilKt;
import org.jetbrains.kotlinx.jupyter.libraries.StandardResolutionInfoProvider;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0005\u001a\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0016"}, d2={"KERNEL_LIBRARIES", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "getKERNEL_LIBRARIES", "()Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "getDefaultClasspathResolutionInfoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "getDefaultResolutionInfoSwitcher", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoSwitcher;", "Lorg/jetbrains/kotlinx/jupyter/libraries/DefaultInfoSwitch;", "provider", "defaultDir", "Ljava/io/File;", "defaultRef", "", "getStandardResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "homeDir", "infoProvider", "loadResourceFromClassLoader", "path", "classLoader", "Ljava/lang/ClassLoader;", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nresolutionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolutionUtil.kt\norg/jetbrains/kotlinx/jupyter/libraries/ResolutionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class ResolutionUtilKt {
    @NotNull
    private static final LibraryDescriptorsManager KERNEL_LIBRARIES = LibraryDescriptorsManager.Companion.getInstance(LoggingKt.getLogger$default(null, (int)1, null), (ExceptionsHandler)KERNEL_LIBRARIES.1.INSTANCE);

    @NotNull
    public static final LibraryDescriptorsManager getKERNEL_LIBRARIES() {
        return KERNEL_LIBRARIES;
    }

    @NotNull
    public static final LibraryResolver getStandardResolver(@Nullable String homeDir2, @NotNull ResolutionInfoProvider infoProvider) {
        File file;
        Intrinsics.checkNotNullParameter((Object)infoProvider, (String)"infoProvider");
        LibraryResolver res2 = (LibraryResolver)FallbackLibraryResolver.INSTANCE;
        String string = homeDir2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = KERNEL_LIBRARIES.homeLibrariesDir(new File(it));
        } else {
            file = null;
        }
        File librariesDir = file;
        res2 = (LibraryResolver)new LocalLibraryResolver(res2, librariesDir);
        res2 = new DefaultInfoLibraryResolver(res2, infoProvider, CollectionsKt.listOf((Object)KERNEL_LIBRARIES.getUserLibrariesDir()));
        return res2;
    }

    public static /* synthetic */ LibraryResolver getStandardResolver$default(String string, ResolutionInfoProvider resolutionInfoProvider2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ResolutionUtilKt.getStandardResolver(string, resolutionInfoProvider2);
    }

    @NotNull
    public static final ResolutionInfoProvider getDefaultClasspathResolutionInfoProvider() {
        return new StandardResolutionInfoProvider(AbstractLibraryResolutionInfo.ByClasspath.INSTANCE);
    }

    @NotNull
    public static final String loadResourceFromClassLoader(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        URL resource = classLoader.getResource(path);
        if (resource != null) {
            URL uRL = resource;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            return new String(byArray, charset);
        }
        throw new IOException("Resource " + path + " not found on classpath");
    }

    @NotNull
    public static final ResolutionInfoSwitcher<DefaultInfoSwitch> getDefaultResolutionInfoSwitcher(@NotNull ResolutionInfoProvider provider, @NotNull File defaultDir, @NotNull String defaultRef) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)defaultDir, (String)"defaultDir");
        Intrinsics.checkNotNullParameter((Object)defaultRef, (String)"defaultRef");
        LibraryResolutionInfo initialInfo = provider.getFallback();
        AbstractLibraryResolutionInfo.ByDir dirInfo = initialInfo instanceof AbstractLibraryResolutionInfo.ByDir ? (AbstractLibraryResolutionInfo.ByDir)initialInfo : new AbstractLibraryResolutionInfo.ByDir(defaultDir);
        AbstractLibraryResolutionInfo.ByGitRef refInfo = initialInfo instanceof AbstractLibraryResolutionInfo.ByGitRef ? (AbstractLibraryResolutionInfo.ByGitRef)initialInfo : (AbstractLibraryResolutionInfo.ByGitRef)AbstractLibraryResolutionInfo.Companion.getGetInfoByRefWithFallback().invoke((Object)defaultRef);
        AbstractLibraryResolutionInfo.ByClasspath classpathInfo = AbstractLibraryResolutionInfo.ByClasspath.INSTANCE;
        return new ResolutionInfoSwitcher(provider, (Object)DefaultInfoSwitch.DIRECTORY, (Function1)new Function1<DefaultInfoSwitch, LibraryResolutionInfo>(dirInfo, refInfo, classpathInfo){
            final /* synthetic */ AbstractLibraryResolutionInfo.ByDir $dirInfo;
            final /* synthetic */ AbstractLibraryResolutionInfo.ByGitRef $refInfo;
            final /* synthetic */ AbstractLibraryResolutionInfo.ByClasspath $classpathInfo;
            {
                this.$dirInfo = $dirInfo;
                this.$refInfo = $refInfo;
                this.$classpathInfo = $classpathInfo;
                super(1);
            }

            @NotNull
            public final LibraryResolutionInfo invoke(@NotNull DefaultInfoSwitch defaultInfoSwitch) {
                LibraryResolutionInfo libraryResolutionInfo;
                Intrinsics.checkNotNullParameter((Object)defaultInfoSwitch, (String)"switch");
                switch (getDefaultResolutionInfoSwitcher.WhenMappings.$EnumSwitchMapping$0[defaultInfoSwitch.ordinal()]) {
                    case 1: {
                        libraryResolutionInfo = this.$dirInfo;
                        break;
                    }
                    case 2: {
                        libraryResolutionInfo = this.$refInfo;
                        break;
                    }
                    case 3: {
                        libraryResolutionInfo = this.$classpathInfo;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return libraryResolutionInfo;
            }
        });
    }
}

