/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.ChainedLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/ResourcesLibraryResolver;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ChainedLibraryResolver;", "parent", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "classLoader", "Ljava/lang/ClassLoader;", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;Ljava/lang/ClassLoader;)V", "resolveDescriptorFromResources", "", "libraryName", "shouldResolve", "", "reference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "tryResolve", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "arguments", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "kotlin-jupyter-kernel"})
public class ResourcesLibraryResolver
extends ChainedLibraryResolver {
    @NotNull
    private final ClassLoader classLoader;

    public ResourcesLibraryResolver(@Nullable LibraryResolver parent, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        super(parent);
        this.classLoader = classLoader;
    }

    @Nullable
    protected LibraryDefinition tryResolve(@NotNull LibraryReference reference, @NotNull List<Variable> arguments) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String string = this.resolveDescriptorFromResources(reference.getName());
        if (string == null) {
            return null;
        }
        String text = string;
        return ParsingKt.parseLibraryDescriptor((String)text).convertToDefinition(arguments);
    }

    @Nullable
    public final String resolveDescriptorFromResources(@Nullable String libraryName) {
        URL url;
        if (libraryName == null) {
            return null;
        }
        URL uRL = this.classLoader.getResource(ResolutionUtilKt.getKERNEL_LIBRARIES().resourceFilePath(libraryName));
        if (uRL == null) {
            return null;
        }
        URL uRL2 = url = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        return new String(byArray, charset);
    }

    protected boolean shouldResolve(@NotNull LibraryReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        LibraryResolutionInfo libraryResolutionInfo = reference.getInfo();
        return libraryResolutionInfo instanceof AbstractLibraryResolutionInfo.Default ? true : libraryResolutionInfo instanceof AbstractLibraryResolutionInfo.ByClasspath;
    }
}

