/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/SpecificLibraryResolver;", "T", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "kClass", "Lkotlin/reflect/KClass;", "resolveRaw", "Lkotlin/Function2;", "", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function2;)V", "getResolveRaw", "()Lkotlin/jvm/functions/Function2;", "accepts", "", "reference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "resolve", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "arguments", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "kotlin-jupyter-kernel"})
public final class SpecificLibraryResolver<T extends LibraryResolutionInfo>
implements LibraryResolver {
    @NotNull
    private final KClass<T> kClass;
    @NotNull
    private final Function2<T, String, String> resolveRaw;

    public SpecificLibraryResolver(@NotNull KClass<T> kClass, @NotNull Function2<? super T, ? super String, String> resolveRaw) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(resolveRaw, (String)"resolveRaw");
        this.kClass = kClass;
        this.resolveRaw = resolveRaw;
    }

    @NotNull
    public final Function2<T, String, String> getResolveRaw() {
        return this.resolveRaw;
    }

    public final boolean accepts(@NotNull LibraryReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return this.kClass.isInstance((Object)reference.getInfo());
    }

    @Nullable
    public LibraryDefinition resolve(@NotNull LibraryReference reference, @NotNull List<Variable> arguments) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        if (!this.accepts(reference)) {
            return null;
        }
        String string = (String)this.resolveRaw.invoke(KClasses.cast(this.kClass, (Object)reference.getInfo()), (Object)reference.getName());
        if (string == null) {
            return null;
        }
        String text = string;
        return ParsingKt.parseLibraryDescriptor((String)text).convertToDefinition(arguments);
    }
}

