/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "fallback", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;)V", "getFallback", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "setFallback", "get", "string", "", "tryGetAsDir", "dirName", "tryGetAsFile", "fileName", "tryGetAsRef", "ref", "tryGetAsURL", "url", "kotlin-jupyter-kernel"})
public final class StandardResolutionInfoProvider
implements ResolutionInfoProvider {
    @NotNull
    private LibraryResolutionInfo fallback;

    public StandardResolutionInfoProvider(@NotNull LibraryResolutionInfo fallback) {
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        this.fallback = fallback;
    }

    @NotNull
    public LibraryResolutionInfo getFallback() {
        return this.fallback;
    }

    public void setFallback(@NotNull LibraryResolutionInfo libraryResolutionInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryResolutionInfo, (String)"<set-?>");
        this.fallback = libraryResolutionInfo;
    }

    @NotNull
    public LibraryResolutionInfo get(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (((CharSequence)string).length() == 0) {
            return this.getFallback();
        }
        LibraryResolutionInfo libraryResolutionInfo = this.tryGetAsRef(string);
        if (libraryResolutionInfo == null && (libraryResolutionInfo = this.tryGetAsDir(string)) == null && (libraryResolutionInfo = this.tryGetAsFile(string)) == null && (libraryResolutionInfo = this.tryGetAsURL(string)) == null) {
            libraryResolutionInfo = this.getFallback();
        }
        return libraryResolutionInfo;
    }

    private final LibraryResolutionInfo tryGetAsRef(String ref) {
        return ResolutionUtilKt.getKERNEL_LIBRARIES().checkRefExistence(ref) ? (LibraryResolutionInfo)AbstractLibraryResolutionInfo.Companion.getGetInfoByRef().invoke((Object)ref) : null;
    }

    private final LibraryResolutionInfo tryGetAsDir(String dirName) {
        File file = new File(dirName);
        return file.isDirectory() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByDir(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsFile(String fileName) {
        File file = new File(fileName);
        return file.isFile() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByFile(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsURL(String url) {
        ResponseWrapper response = HttpUtilKt.getHttp((String)url);
        return response.getStatus().getSuccessful() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByURL(new URL(url)) : null;
    }
}

