/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlinx.jupyter.OutputConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J!\u0010\u001d\u001a\u00020\u000b2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001f\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/CapturingOutputStream;", "Ljava/io/OutputStream;", "stdout", "Ljava/io/PrintStream;", "conf", "Lorg/jetbrains/kotlinx/jupyter/OutputConfig;", "captureOutput", "", "onCaptured", "Lkotlin/Function1;", "", "", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlinx/jupyter/OutputConfig;ZLkotlin/jvm/functions/Function1;)V", "capturedLines", "Ljava/io/ByteArrayOutputStream;", "capturedNewLine", "contents", "", "getContents", "()[B", "newlineFound", "getOnCaptured", "()Lkotlin/jvm/functions/Function1;", "overallOutputSize", "", "timer", "Ljava/util/Timer;", "close", "flush", "flushBuffers", "buffers", "", "([Ljava/io/ByteArrayOutputStream;)V", "flushIfNeeded", "b", "write", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nprotocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 protocol.kt\norg/jetbrains/kotlinx/jupyter/messaging/CapturingOutputStream\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,557:1\n11335#2:558\n11670#2,3:559\n2661#3,7:562\n*S KotlinDebug\n*F\n+ 1 protocol.kt\norg/jetbrains/kotlinx/jupyter/messaging/CapturingOutputStream\n*L\n444#1:558\n444#1:559,3\n448#1:562,7\n*E\n"})
public final class CapturingOutputStream
extends OutputStream {
    @Nullable
    private final PrintStream stdout;
    @NotNull
    private final OutputConfig conf;
    private final boolean captureOutput;
    @NotNull
    private final Function1<String, Unit> onCaptured;
    @NotNull
    private final ByteArrayOutputStream capturedLines;
    @NotNull
    private final ByteArrayOutputStream capturedNewLine;
    private int overallOutputSize;
    private boolean newlineFound;
    @NotNull
    private final Timer timer;

    public CapturingOutputStream(@Nullable PrintStream stdout, @NotNull OutputConfig conf, boolean captureOutput, @NotNull Function1<? super String, Unit> onCaptured) {
        Timer timer2;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter(onCaptured, (String)"onCaptured");
        this.stdout = stdout;
        this.conf = conf;
        this.captureOutput = captureOutput;
        this.onCaptured = onCaptured;
        this.capturedLines = new ByteArrayOutputStream();
        this.capturedNewLine = new ByteArrayOutputStream();
        long l = this.conf.getCaptureBufferTimeLimitMs();
        long l2 = this.conf.getCaptureBufferTimeLimitMs();
        String string = null;
        boolean bl = false;
        Timer timer3 = timer2 = TimersKt.timer(string, (boolean)bl);
        timer3.schedule(new TimerTask(this){
            final /* synthetic */ CapturingOutputStream this$0;
            {
                this.this$0 = capturingOutputStream;
            }

            public void run() {
                TimerTask $this$timer_u24lambda_u240 = this;
                boolean bl = false;
                this.this$0.flush();
            }
        }, l, l2);
        this.timer = timer2;
    }

    @NotNull
    public final Function1<String, Unit> getOnCaptured() {
        return this.onCaptured;
    }

    @TestOnly
    @NotNull
    public final byte[] getContents() {
        byte[] byArray = this.capturedLines.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"capturedLines.toByteArray()");
        byte[] byArray2 = this.capturedNewLine.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"capturedNewLine.toByteArray()");
        return ArraysKt.plus((byte[])byArray, (byte[])byArray2);
    }

    private final void flushIfNeeded(int b) {
        char c = (char)b;
        if (c == '\n') {
            this.newlineFound = true;
            this.capturedNewLine.writeTo(this.capturedLines);
            this.capturedNewLine.reset();
        }
        int size = this.capturedLines.size() + this.capturedNewLine.size();
        if (this.newlineFound && size >= this.conf.getCaptureNewlineBufferSize()) {
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[]{this.capturedLines};
            this.flushBuffers(byteArrayOutputStreamArray);
            return;
        }
        if (size >= this.conf.getCaptureBufferMaxSize()) {
            this.flush();
            return;
        }
    }

    @Override
    public synchronized void write(int b) {
        ++this.overallOutputSize;
        PrintStream printStream = this.stdout;
        if (printStream != null) {
            printStream.write(b);
        }
        if (this.captureOutput && this.overallOutputSize <= this.conf.getCellOutputMaxSize()) {
            this.capturedNewLine.write(b);
            this.flushIfNeeded(b);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void flushBuffers(ByteArrayOutputStream ... buffers) {
        void $this$mapTo$iv$iv;
        this.newlineFound = false;
        ByteArrayOutputStream[] $this$map$iv = buffers;
        boolean $i$f$map = false;
        ByteArrayOutputStream[] byteArrayOutputStreamArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo2 = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void stream;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String str = stream.toString("UTF-8");
            stream.reset();
            collection.add(str);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s;
            String $i$f$mapTo2 = (String)iterator$iv.next();
            String acc = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + (String)s;
        }
        String str = (String)accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
        if (((CharSequence)str).length() > 0) {
            this.onCaptured.invoke((Object)str);
        }
    }

    @Override
    public void flush() {
        ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[]{this.capturedLines, this.capturedNewLine};
        this.flushBuffers(byteArrayOutputStreamArray);
    }

    @Override
    public void close() {
        super.close();
        this.timer.cancel();
    }
}

