/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import ch.qos.logback.classic.Level;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.CheckResult;
import org.jetbrains.kotlinx.jupyter.CommandsKt;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.DisabledStdinInputStream;
import org.jetbrains.kotlinx.jupyter.EvalRequestData;
import org.jetbrains.kotlinx.jupyter.ExecutionResult;
import org.jetbrains.kotlinx.jupyter.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.LoggingManagement;
import org.jetbrains.kotlinx.jupyter.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.OutputConfig;
import org.jetbrains.kotlinx.jupyter.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.Renderable;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.config.KernelStreams;
import org.jetbrains.kotlinx.jupyter.config.NotebookMetadataKt;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplCompilerException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplEvalRuntimeException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.messaging.AbortResponseWithMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CapturingOutputStream;
import org.jetbrains.kotlinx.jupyter.messaging.Comm;
import org.jetbrains.kotlinx.jupyter.messaging.CommClose;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.messaging.CommMsg;
import org.jetbrains.kotlinx.jupyter.messaging.CommOpen;
import org.jetbrains.kotlinx.jupyter.messaging.CompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectReply;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorResponseWithMessage;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionInputReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryRequest;
import org.jetbrains.kotlinx.jupyter.messaging.InterruptRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteReply;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternal;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ListErrorsRequest;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHeader;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.Response;
import org.jetbrains.kotlinx.jupyter.messaging.ShutdownRequest;
import org.jetbrains.kotlinx.jupyter.repl.CompletionResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalResultsKt;
import org.jetbrains.kotlinx.jupyter.repl.ListErrorsResult;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a2\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u001a*\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"controlMessagesHandler", "", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterConnectionInternal;", "rawIncomingMessage", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "repl", "Lorg/jetbrains/kotlinx/jupyter/ReplForJupyter;", "evalWithIO", "Lorg/jetbrains/kotlinx/jupyter/messaging/Response;", "incomingMessage", "allowStdIn", "", "body", "Lkotlin/Function0;", "Lorg/jetbrains/kotlinx/jupyter/repl/EvalResult;", "shellMessagesHandler", "commManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommManagerInternal;", "executionCount", "Ljava/util/concurrent/atomic/AtomicLong;", "toDisplayResult", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nprotocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 protocol.kt\norg/jetbrains/kotlinx/jupyter/messaging/ProtocolKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,557:1\n125#2:558\n152#2,3:559\n1179#3,2:562\n1253#3,4:564\n11335#4:568\n11670#4,3:569\n*S KotlinDebug\n*F\n+ 1 protocol.kt\norg/jetbrains/kotlinx/jupyter/messaging/ProtocolKt\n*L\n289#1:558\n289#1:559,3\n335#1:562,2\n335#1:564,4\n540#1:568\n540#1:569,3\n*E\n"})
public final class ProtocolKt {
    public static final void controlMessagesHandler(@NotNull JupyterConnectionInternal $this$controlMessagesHandler, @NotNull RawMessage rawIncomingMessage, @Nullable ReplForJupyter repl) {
        Intrinsics.checkNotNullParameter((Object)$this$controlMessagesHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rawIncomingMessage, (String)"rawIncomingMessage");
        Message msg = MessageKt.toMessage(rawIncomingMessage);
        MessageContent messageContent = msg.getContent();
        if (messageContent instanceof InterruptRequest) {
            $this$controlMessagesHandler.getExecutor().interruptExecutions();
            JupyterConnectionInternalKt.sendMessage($this$controlMessagesHandler.getControl(), MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.INTERRUPT_REPLY, null, null, null, null, msg.getContent(), 60, null));
        } else if (messageContent instanceof ShutdownRequest) {
            ReplForJupyter replForJupyter = repl;
            if (replForJupyter != null) {
                replForJupyter.evalOnShutdown();
            }
            JupyterConnectionInternalKt.sendMessage($this$controlMessagesHandler.getControl(), MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.SHUTDOWN_REPLY, null, null, null, null, msg.getContent(), 60, null));
            ReplForJupyter replForJupyter2 = repl;
            boolean bl = replForJupyter2 != null ? replForJupyter2.isEmbedded() : false;
            if (bl) {
                ConfigKt.getLog().info("Interrupting controlThread to trigger kernel shutdown");
                throw new InterruptedException();
            }
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void shellMessagesHandler(@NotNull JupyterConnectionInternal $this$shellMessagesHandler, @NotNull RawMessage rawIncomingMessage, @NotNull ReplForJupyter repl, @NotNull CommManagerInternal commManager2, @NotNull AtomicLong executionCount) {
        Intrinsics.checkNotNullParameter((Object)$this$shellMessagesHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rawIncomingMessage, (String)"rawIncomingMessage");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        Intrinsics.checkNotNullParameter((Object)commManager2, (String)"commManager");
        Intrinsics.checkNotNullParameter((Object)executionCount, (String)"executionCount");
        Message incomingMessage = MessageKt.toMessage(rawIncomingMessage);
        MessageContent content = incomingMessage.getContent();
        if (content instanceof KernelInfoRequest) {
            ProtocolKt.shellMessagesHandler$sendWrapped($this$shellMessagesHandler, rawIncomingMessage, MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.KERNEL_INFO_REPLY, null, null, null, null, (MessageContent)new KernelInfoReply("5.3", "Kotlin", KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()), "Kotlin kernel v. " + KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()) + ", Kotlin v. " + RuntimePropertiesKt.getCurrentKotlinVersion(), NotebookMetadataKt.getNotebookLanguageInfo(), CollectionsKt.emptyList()), 60, null));
        } else if (content instanceof HistoryRequest) {
            ProtocolKt.shellMessagesHandler$sendWrapped($this$shellMessagesHandler, rawIncomingMessage, MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.HISTORY_REPLY, null, null, null, null, new HistoryReply(CollectionsKt.emptyList()), 60, null));
        } else if (content instanceof ConnectRequest) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map = $this$shellMessagesHandler.getConfig().getPorts();
            JsonElement jsonElement = null;
            MessageHeader messageHeader = null;
            MessageHeader messageHeader2 = null;
            String string = null;
            MessageType messageType = MessageType.CONNECT_REPLY;
            RawMessage rawMessage = rawIncomingMessage;
            RawMessage rawMessage2 = rawIncomingMessage;
            JupyterConnectionInternal jupyterConnectionInternal = $this$shellMessagesHandler;
            boolean $i$f$map = false;
            void var9_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                JupyterSocketType socket = (JupyterSocketType)entry.getKey();
                int port = ((Number)entry.getValue()).intValue();
                collection.add(TuplesKt.to((Object)ConnectionKt.getPortField((JupyterSocketType)socket), (Object)port));
            }
            collection = (List)destination$iv$iv;
            JsonObject jsonObject = MessageKt.jsonObject((Iterable<? extends Pair<String, ? extends Object>>)collection);
            ProtocolKt.shellMessagesHandler$sendWrapped(jupyterConnectionInternal, rawMessage2, MessageKt.makeReplyMessage$default(rawMessage, messageType, string, messageHeader2, messageHeader, jsonElement, new ConnectReply(jsonObject), 60, null));
        } else if (content instanceof ExecuteRequest) {
            $this$shellMessagesHandler.setContextMessage(rawIncomingMessage);
            long count2 = executionCount.getAndUpdate(new LongUnaryOperator(content){
                final /* synthetic */ MessageContent $content;
                {
                    this.$content = $content;
                }

                public final long applyAsLong(long it) {
                    return ((ExecuteRequest)this.$content).getStoreHistory() ? it + 1L : it;
                }
            });
            String startedTime = MessageKt.getISO8601DateNow();
            $this$shellMessagesHandler.doWrappedInBusyIdle(rawIncomingMessage, (Function0<Unit>)((Function0)new Function0<Unit>(content, $this$shellMessagesHandler, rawIncomingMessage, count2, repl, incomingMessage, startedTime){
                final /* synthetic */ MessageContent $content;
                final /* synthetic */ JupyterConnectionInternal $this_shellMessagesHandler;
                final /* synthetic */ RawMessage $rawIncomingMessage;
                final /* synthetic */ long $count;
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ Message $incomingMessage;
                final /* synthetic */ String $startedTime;
                {
                    this.$content = $content;
                    this.$this_shellMessagesHandler = $receiver;
                    this.$rawIncomingMessage = $rawIncomingMessage;
                    this.$count = $count;
                    this.$repl = $repl;
                    this.$incomingMessage = $incomingMessage;
                    this.$startedTime = $startedTime;
                    super(0);
                }

                public final void invoke() {
                    Response response;
                    String code = ((ExecuteRequest)this.$content).getCode();
                    JupyterConnectionInternalKt.sendMessage(this.$this_shellMessagesHandler.getIopub(), MessageKt.makeReplyMessage$default(this.$rawIncomingMessage, MessageType.EXECUTE_INPUT, null, null, null, null, new ExecutionInputReply(code, this.$count), 60, null));
                    if (CommandsUtilKt.looksLikeReplCommand((String)code)) {
                        response = CommandsKt.runCommand(code, this.$repl);
                    } else {
                        MessageContent messageContent = this.$incomingMessage.getContent();
                        ExecuteRequest executeRequest = messageContent instanceof ExecuteRequest ? (ExecuteRequest)messageContent : null;
                        boolean allowStdIn = executeRequest != null ? executeRequest.getAllowStdin() : true;
                        response = ProtocolKt.evalWithIO(this.$this_shellMessagesHandler, this.$repl, this.$rawIncomingMessage, allowStdIn, (Function0<EvalResult>)((Function0)new Function0<EvalResult>(this.$repl, code, this.$count, this.$content){
                            final /* synthetic */ ReplForJupyter $repl;
                            final /* synthetic */ String $code;
                            final /* synthetic */ long $count;
                            final /* synthetic */ MessageContent $content;
                            {
                                this.$repl = $repl;
                                this.$code = $code;
                                this.$count = $count;
                                this.$content = $content;
                                super(0);
                            }

                            @Nullable
                            public final EvalResult invoke() {
                                return this.$repl.eval(new EvalRequestData(this.$code, (int)this.$count, ((ExecuteRequest)this.$content).getStoreHistory(), ((ExecuteRequest)this.$content).getSilent()));
                            }
                        }));
                    }
                    Response res2 = response;
                    res2.send(this.$this_shellMessagesHandler, this.$count, this.$rawIncomingMessage, this.$startedTime);
                }
            }));
            $this$shellMessagesHandler.setContextMessage(null);
        } else if (content instanceof CommInfoRequest) {
            void $this$associateTo$iv$iv;
            Collection comms = commManager2.getComms(((CommInfoRequest)content).getTargetName());
            Iterable $this$associate$iv = comms;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                org.jetbrains.kotlinx.jupyter.api.libraries.Comm comm = (org.jetbrains.kotlinx.jupyter.api.libraries.Comm)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)comm.getId(), (Object)new Comm(comm.getTarget()));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map replyMap = destination$iv$iv;
            ProtocolKt.shellMessagesHandler$sendWrapped($this$shellMessagesHandler, rawIncomingMessage, MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.COMM_INFO_REPLY, null, null, null, null, new CommInfoReply(replyMap), 60, null));
        } else if (content instanceof CommOpen) {
            JupyterExecutor.DefaultImpls.runExecution$default($this$shellMessagesHandler.getExecutor(), null, (Function0)new Function0<org.jetbrains.kotlinx.jupyter.api.libraries.Comm>(commManager2, incomingMessage, content){
                final /* synthetic */ CommManagerInternal $commManager;
                final /* synthetic */ Message $incomingMessage;
                final /* synthetic */ MessageContent $content;
                {
                    this.$commManager = $commManager;
                    this.$incomingMessage = $incomingMessage;
                    this.$content = $content;
                    super(0);
                }

                @Nullable
                public final org.jetbrains.kotlinx.jupyter.api.libraries.Comm invoke() {
                    return this.$commManager.processCommOpen(this.$incomingMessage, (CommOpen)this.$content);
                }
            }, 1, null);
        } else if (content instanceof CommClose) {
            JupyterExecutor.DefaultImpls.runExecution$default($this$shellMessagesHandler.getExecutor(), null, (Function0)new Function0<Unit>(commManager2, incomingMessage, content){
                final /* synthetic */ CommManagerInternal $commManager;
                final /* synthetic */ Message $incomingMessage;
                final /* synthetic */ MessageContent $content;
                {
                    this.$commManager = $commManager;
                    this.$incomingMessage = $incomingMessage;
                    this.$content = $content;
                    super(0);
                }

                public final void invoke() {
                    this.$commManager.processCommClose(this.$incomingMessage, (CommClose)this.$content);
                }
            }, 1, null);
        } else if (content instanceof CommMsg) {
            JupyterExecutor.DefaultImpls.runExecution$default($this$shellMessagesHandler.getExecutor(), null, (Function0)new Function0<Unit>(commManager2, incomingMessage, content){
                final /* synthetic */ CommManagerInternal $commManager;
                final /* synthetic */ Message $incomingMessage;
                final /* synthetic */ MessageContent $content;
                {
                    this.$commManager = $commManager;
                    this.$incomingMessage = $incomingMessage;
                    this.$content = $content;
                    super(0);
                }

                public final void invoke() {
                    this.$commManager.processCommMessage(this.$incomingMessage, (CommMsg)this.$content);
                }
            }, 1, null);
        } else if (content instanceof CompleteRequest) {
            $this$shellMessagesHandler.getExecutor().launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repl, content, rawIncomingMessage, $this$shellMessagesHandler, null){
                int label;
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ MessageContent $content;
                final /* synthetic */ RawMessage $rawIncomingMessage;
                final /* synthetic */ JupyterConnectionInternal $this_shellMessagesHandler;
                {
                    this.$repl = $repl;
                    this.$content = $content;
                    this.$rawIncomingMessage = $rawIncomingMessage;
                    this.$this_shellMessagesHandler = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$repl.complete(((CompleteRequest)this.$content).getCode(), ((CompleteRequest)this.$content).getCursorPos(), (Function1<? super CompletionResult, Unit>)((Function1)new Function1<CompletionResult, Unit>(this.$rawIncomingMessage, this.$this_shellMessagesHandler){
                                final /* synthetic */ RawMessage $rawIncomingMessage;
                                final /* synthetic */ JupyterConnectionInternal $this_shellMessagesHandler;
                                {
                                    this.$rawIncomingMessage = $rawIncomingMessage;
                                    this.$this_shellMessagesHandler = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull CompletionResult result2) {
                                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                                    ProtocolKt.access$shellMessagesHandler$sendWrapped(this.$this_shellMessagesHandler, this.$rawIncomingMessage, MessageKt.makeReplyMessage$default(this.$rawIncomingMessage, MessageType.COMPLETE_REPLY, null, null, null, null, result2.getMessage(), 60, null));
                                }
                            }), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else if (content instanceof ListErrorsRequest) {
            $this$shellMessagesHandler.getExecutor().launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repl, content, rawIncomingMessage, $this$shellMessagesHandler, null){
                int label;
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ MessageContent $content;
                final /* synthetic */ RawMessage $rawIncomingMessage;
                final /* synthetic */ JupyterConnectionInternal $this_shellMessagesHandler;
                {
                    this.$repl = $repl;
                    this.$content = $content;
                    this.$rawIncomingMessage = $rawIncomingMessage;
                    this.$this_shellMessagesHandler = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$repl.listErrors(((ListErrorsRequest)this.$content).getCode(), (Function1<? super ListErrorsResult, Unit>)((Function1)new Function1<ListErrorsResult, Unit>(this.$rawIncomingMessage, this.$this_shellMessagesHandler){
                                final /* synthetic */ RawMessage $rawIncomingMessage;
                                final /* synthetic */ JupyterConnectionInternal $this_shellMessagesHandler;
                                {
                                    this.$rawIncomingMessage = $rawIncomingMessage;
                                    this.$this_shellMessagesHandler = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull ListErrorsResult result2) {
                                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                                    ProtocolKt.access$shellMessagesHandler$sendWrapped(this.$this_shellMessagesHandler, this.$rawIncomingMessage, MessageKt.makeReplyMessage$default(this.$rawIncomingMessage, MessageType.LIST_ERRORS_REPLY, null, null, null, null, result2.getMessage(), 60, null));
                                }
                            }), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else if (content instanceof IsCompleteRequest) {
            String string;
            if (!Intrinsics.areEqual((Object)LoggingManagement.INSTANCE.mainLoggerLevel(), (Object)Level.OFF)) {
                LoggingManagement.INSTANCE.disableLogging();
            }
            if (CommandsUtilKt.looksLikeReplCommand((String)((IsCompleteRequest)content).getCode())) {
                string = "complete";
            } else {
                String result2;
                String string2;
                try {
                    CheckResult check = repl.checkComplete(((IsCompleteRequest)content).getCode());
                    string2 = check.isComplete() ? "complete" : "incomplete";
                }
                catch (ReplCompilerException ex) {
                    string2 = "invalid";
                }
                string = result2 = string2;
            }
            String resStr = string;
            JupyterConnectionInternalKt.sendMessage($this$shellMessagesHandler.getShell(), MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.IS_COMPLETE_REPLY, null, null, null, null, new IsCompleteReply(resStr, null, 2, null), 60, null));
        } else {
            JupyterConnectionInternalKt.sendMessage($this$shellMessagesHandler.getShell(), MessageKt.makeReplyMessage$default(rawIncomingMessage, MessageType.NONE, null, null, null, null, null, 124, null));
        }
    }

    @Nullable
    public static final DisplayResult toDisplayResult(@Nullable Object $this$toDisplayResult, @NotNull Notebook notebook2) {
        Intrinsics.checkNotNullParameter((Object)notebook2, (String)"notebook");
        Object object = $this$toDisplayResult;
        return object == null ? (DisplayResult)ResultsKt.textResult((String)"null") : (object instanceof DisplayResult ? (DisplayResult)$this$toDisplayResult : (object instanceof Renderable ? ((Renderable)$this$toDisplayResult).render(notebook2) : (object instanceof Unit ? null : (DisplayResult)ResultsKt.textResult((String)$this$toDisplayResult.toString()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public static final Response evalWithIO(@NotNull JupyterConnectionInternal $this$evalWithIO, @NotNull ReplForJupyter repl, @NotNull RawMessage incomingMessage, boolean allowStdIn, @NotNull Function0<EvalResult> body) {
        Intrinsics.checkNotNullParameter((Object)$this$evalWithIO, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        Intrinsics.checkNotNullParameter((Object)incomingMessage, (String)"incomingMessage");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        config = repl.getOutputConfig();
        out = System.out;
        err = System.err;
        repl.getNotebook().beginEvalSession();
        cell = (Function0)new Function0<MutableCodeCell>(repl){
            final /* synthetic */ ReplForJupyter $repl;
            {
                this.$repl = $repl;
                super(0);
            }

            @Nullable
            public final MutableCodeCell invoke() {
                return this.$repl.getNotebook().getCurrentCell();
            }
        };
        forkedOut = ProtocolKt.evalWithIO$getCapturingStream(config, (Function0<? extends MutableCodeCell>)cell, $this$evalWithIO, incomingMessage, out, JupyterOutType.STDOUT, config.getCaptureOutput());
        forkedError = ProtocolKt.evalWithIO$getCapturingStream(config, (Function0<? extends MutableCodeCell>)cell, $this$evalWithIO, incomingMessage, err, JupyterOutType.STDERR, false);
        userError = ProtocolKt.evalWithIO$getCapturingStream(config, (Function0<? extends MutableCodeCell>)cell, $this$evalWithIO, incomingMessage, null, JupyterOutType.STDERR, true);
        printForkedOut = new PrintStream((OutputStream)forkedOut, false, "UTF-8");
        printForkedErr = new PrintStream((OutputStream)forkedError, false, "UTF-8");
        printUserError = new PrintStream((OutputStream)userError, false, "UTF-8");
        KernelStreams.INSTANCE.setStreams(true, printForkedOut, printUserError);
        System.setOut(printForkedOut);
        System.setErr(printForkedErr);
        in = System.in;
        System.setIn(allowStdIn != false ? $this$evalWithIO.getStdinIn() : (InputStream)DisabledStdinInputStream.INSTANCE);
        try {
            block16: {
                block17: {
                    block15: {
                        res = $this$evalWithIO.getExecutor().runExecution(repl.getCurrentClassLoader(), body);
                        if (!(res instanceof ExecutionResult.Success)) break block15;
                        if (((ExecutionResult.Success)res).getResult() == null) {
                            v0 = new AbortResponseWithMessage("NO REPL!");
                        } else {
                            try {
                                var17_18 = EvalResultsKt.toResponse((EvalResult)((ExecutionResult.Success)res).getResult(), repl.getNotebook());
                            }
                            catch (Exception e) {
                                var17_18 = new AbortResponseWithMessage("error:  Unable to convert result to a string: " + e);
                            }
                            v0 = var17_18;
                        }
                        break block16;
                    }
                    if (!(res instanceof ExecutionResult.Failure)) break block17;
                    ex = ((ExecutionResult.Failure)res).getThrowable();
                    if (!(ex instanceof ReplException)) {
                        throw ex;
                    }
                    v1 = var18_20 = ex instanceof ReplEvalRuntimeException != false ? (ReplEvalRuntimeException)ex : null;
                    if (var18_20 == null || (var19_21 = var18_20.getCause()) == null) ** GOTO lbl-1000
                    originalThrowable = var19_21;
                    $i$a$-let-ProtocolKt$evalWithIO$1 = false;
                    var20_25 = repl.getThrowableRenderersProcessor().renderThrowable((Throwable)originalThrowable);
                    if (var20_25 == null) ** GOTO lbl-1000
                    renderedThrowable = var20_25;
                    $i$a$-let-ProtocolKt$evalWithIO$2 = false;
                    var21_28 = EvalResultsKt.rawToResponse$default(renderedThrowable, repl.getNotebook(), null, 4, null);
                    if (var21_28 != null) {
                        v0 = var21_28;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v2 = ((ReplException)ex).render();
                        v3 = ex.getClass().getCanonicalName();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ex.javaClass.canonicalName");
                        v4 = ex.getMessage();
                        if (v4 == null) {
                            v4 = "";
                        }
                        v5 = ((ReplException)ex).getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"ex.stackTrace");
                        originalThrowable = v5;
                        var34_29 = v4;
                        var33_30 = v3;
                        var32_31 = v2;
                        $i$f$map = false;
                        $i$a$-let-ProtocolKt$evalWithIO$2 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                        $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            var30_37 = (StackTraceElement)item$iv$iv;
                            var35_39 = destination$iv$iv;
                            $i$a$-map-ProtocolKt$evalWithIO$3 = false;
                            v6 = it.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it.toString()");
                            var35_39.add(v6);
                        }
                        var35_39 = (List)destination$iv$iv;
                        v7 = ((ReplException)ex).getAdditionalInfoJson();
                        if (v7 == null) {
                            v7 = SerializersKt.getEMPTY((Json)((Json)Json.Default));
                        }
                        var36_40 = v7;
                        var37_41 = var35_39;
                        var38_42 = var34_29;
                        var39_43 = var33_30;
                        var40_44 = var32_31;
                        v0 = new ErrorResponseWithMessage(var40_44, var39_43, var38_42, var37_41, var36_40);
                    }
                    break block16;
                }
                if (Intrinsics.areEqual(res, (Object)ExecutionResult.Interrupted.INSTANCE)) {
                    v0 = new AbortResponseWithMessage("The execution was interrupted");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            var16_16 = v0;
            return var16_16;
        }
        finally {
            ProtocolKt.evalWithIO$flushStreams(forkedOut, forkedError, userError);
            System.setIn(in);
            System.setErr(err);
            System.setOut(out);
            Intrinsics.checkNotNullExpressionValue((Object)out, (String)"out");
            Intrinsics.checkNotNullExpressionValue((Object)err, (String)"err");
            KernelStreams.INSTANCE.setStreams(false, out, err);
        }
    }

    private static final void shellMessagesHandler$sendWrapped(JupyterConnectionInternal $this_shellMessagesHandler, RawMessage $rawIncomingMessage, Message message2) {
        $this_shellMessagesHandler.doWrappedInBusyIdle($rawIncomingMessage, (Function0<Unit>)((Function0)new Function0<Unit>($this_shellMessagesHandler, message2){
            final /* synthetic */ JupyterConnectionInternal $this_shellMessagesHandler;
            final /* synthetic */ Message $message;
            {
                this.$this_shellMessagesHandler = $receiver;
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                JupyterConnectionInternalKt.sendMessage(this.$this_shellMessagesHandler.getShell(), this.$message);
            }
        }));
    }

    private static final CapturingOutputStream evalWithIO$getCapturingStream(OutputConfig config, Function0<? extends MutableCodeCell> cell2, JupyterConnectionInternal $this_evalWithIO, RawMessage $incomingMessage, PrintStream stream, JupyterOutType outType, boolean captureOutput) {
        return new CapturingOutputStream(stream, config, captureOutput, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(cell2, $this_evalWithIO, $incomingMessage, outType){
            final /* synthetic */ Function0<MutableCodeCell> $cell;
            final /* synthetic */ JupyterConnectionInternal $this_evalWithIO;
            final /* synthetic */ RawMessage $incomingMessage;
            final /* synthetic */ JupyterOutType $outType;
            {
                this.$cell = $cell;
                this.$this_evalWithIO = $receiver;
                this.$incomingMessage = $incomingMessage;
                this.$outType = $outType;
                super(1);
            }

            public final void invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                MutableCodeCell mutableCodeCell = (MutableCodeCell)this.$cell.invoke();
                if (mutableCodeCell != null) {
                    mutableCodeCell.appendStreamOutput(text);
                }
                JupyterConnectionInternalKt.sendOut(this.$this_evalWithIO, this.$incomingMessage, this.$outType, text);
            }
        }));
    }

    private static final void evalWithIO$flushStreams(CapturingOutputStream forkedOut, CapturingOutputStream forkedError, CapturingOutputStream userError) {
        forkedOut.flush();
        forkedError.flush();
        userError.flush();
    }

    public static final /* synthetic */ void access$shellMessagesHandler$sendWrapped(JupyterConnectionInternal $this_shellMessagesHandler, RawMessage $rawIncomingMessage, Message message2) {
        ProtocolKt.shellMessagesHandler$sendWrapped($this_shellMessagesHandler, $rawIncomingMessage, message2);
    }
}

