/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.MutableDisplayContainer;
import org.jetbrains.kotlinx.jupyter.MutableDisplayResultWithCell;
import org.jetbrains.kotlinx.jupyter.MutableNotebook;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.ExecutionHost;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.messaging.DisplayDataResponse;
import org.jetbrains.kotlinx.jupyter.messaging.DisplayHandler;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternal;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.ProtocolKt;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocket;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler;", "Lorg/jetbrains/kotlinx/jupyter/messaging/DisplayHandler;", "connection", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterConnectionInternal;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/MutableNotebook;", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterConnectionInternal;Lorg/jetbrains/kotlinx/jupyter/MutableNotebook;)V", "socket", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "handleDisplay", "", "value", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ExecutionHost;", "id", "", "handleUpdate", "render", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nprotocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 protocol.kt\norg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,557:1\n1#2:558\n1655#3,8:559\n1855#3,2:567\n*S KotlinDebug\n*F\n+ 1 protocol.kt\norg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler\n*L\n166#1:559,8\n166#1:567,2\n*E\n"})
public final class SocketDisplayHandler
implements DisplayHandler {
    @NotNull
    private final JupyterConnectionInternal connection;
    @NotNull
    private final MutableNotebook notebook;
    @NotNull
    private final JupyterSocket socket;

    public SocketDisplayHandler(@NotNull JupyterConnectionInternal connection2, @NotNull MutableNotebook notebook2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)notebook2, (String)"notebook");
        this.connection = connection2;
        this.notebook = notebook2;
        this.socket = this.connection.getIopub();
    }

    private final DisplayResult render(ExecutionHost host, Object value) {
        Object renderedValue = this.notebook.getRenderersProcessor().renderValue(host, value);
        return ProtocolKt.toDisplayResult(renderedValue, this.notebook);
    }

    @Override
    public void handleDisplay(@NotNull Object value, @NotNull ExecutionHost host, @Nullable String id) {
        DisplayResult displayResult;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                displayResult = this.render(host, value);
                if (displayResult == null) break block4;
                DisplayResult it = displayResult;
                boolean bl = false;
                String string = id;
                DisplayResult displayResult2 = string != null ? ResultsKt.withId((DisplayResult)it, (String)string) : it;
                displayResult = displayResult2;
                if (displayResult2 != null) break block5;
            }
            return;
        }
        DisplayResult display = displayResult;
        JsonObject json = display.toJson(SerializersKt.getEMPTY((Json)((Json)Json.Default)), null);
        MutableCodeCell mutableCodeCell = this.notebook.getCurrentCell();
        if (mutableCodeCell != null) {
            mutableCodeCell.addDisplay(display);
        }
        DisplayDataResponse content = new DisplayDataResponse((JsonElement)json.get((Object)"data"), (JsonElement)json.get((Object)"metadata"), (JsonElement)json.get((Object)"transient"));
        RawMessage rawMessage = this.connection.getContextMessage();
        Intrinsics.checkNotNull((Object)rawMessage);
        Message message2 = MessageKt.makeReplyMessage$default(rawMessage, MessageType.DISPLAY_DATA, null, null, null, null, content, 60, null);
        JupyterConnectionInternalKt.sendMessage(this.socket, message2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleUpdate(@NotNull Object value, @NotNull ExecutionHost host, @Nullable String id) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        DisplayResult displayResult = this.render(host, value);
        if (displayResult == null) {
            return;
        }
        DisplayResult display = displayResult;
        Map json = MapsKt.toMutableMap((Map)((Map)display.toJson(SerializersKt.getEMPTY((Json)((Json)Json.Default)), null)));
        MutableDisplayContainer container = this.notebook.getDisplays();
        container.update(id, display);
        Iterable $this$distinctBy$iv = container.getById(id);
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            MutableDisplayResultWithCell it = (MutableDisplayResultWithCell)e$iv;
            boolean bl = false;
            Integer key$iv = it.getCell().getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableDisplayResultWithCell it = (MutableDisplayResultWithCell)element$iv;
            boolean bl = false;
            it.getCell().getDisplays().update(id, display);
        }
        if (ResultsKt.setDisplayId$default((Map)json, (String)id, (boolean)false, (int)2, null) == null) {
            throw new RuntimeException("`update_display_data` response should provide an id of data being updated");
        }
        DisplayDataResponse content = new DisplayDataResponse((JsonElement)json.get("data"), (JsonElement)json.get("metadata"), (JsonElement)json.get("transient"));
        Message message2 = JupyterConnectionInternalKt.makeSimpleMessage(this.connection, MessageType.UPDATE_DISPLAY_DATA, content);
        JupyterConnectionInternalKt.sendMessage(this.socket, message2);
    }
}

