/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.repl.creating;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.ReplConfig;
import org.jetbrains.kotlinx.jupyter.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommManager;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.messaging.DisplayHandler;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternal;
import org.jetbrains.kotlinx.jupyter.messaging.SocketDisplayHandler;
import org.jetbrains.kotlinx.jupyter.repl.creating.BaseReplFactory;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u000eH\u0014J\b\u0010\u0011\u001a\u00020\fH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\tH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0007H\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0014J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/creating/DefaultReplFactory;", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/BaseReplFactory;", "_kernelConfig", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "_replConfig", "Lorg/jetbrains/kotlinx/jupyter/ReplConfig;", "_runtimeProperties", "Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;", "_scriptReceivers", "", "", "_connection", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterConnectionInternal;", "_commManager", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;", "(Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;Lorg/jetbrains/kotlinx/jupyter/ReplConfig;Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;Ljava/util/List;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterConnectionInternal;Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;)V", "provideCommManager", "provideConnection", "provideDisplayHandler", "Lorg/jetbrains/kotlinx/jupyter/messaging/DisplayHandler;", "provideExplicitClientType", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "provideHomeDir", "Ljava/io/File;", "provideIsEmbedded", "", "provideLibraryResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "provideMavenRepositories", "Lkotlin/script/experimental/dependencies/RepositoryCoordinates;", "provideResolutionInfoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "provideRuntimeProperties", "provideScriptClasspath", "provideScriptReceivers", "kotlin-jupyter-kernel"})
public final class DefaultReplFactory
extends BaseReplFactory {
    @NotNull
    private final KernelConfig _kernelConfig;
    @NotNull
    private final ReplConfig _replConfig;
    @NotNull
    private final ReplRuntimeProperties _runtimeProperties;
    @NotNull
    private final List<Object> _scriptReceivers;
    @NotNull
    private final JupyterConnectionInternal _connection;
    @NotNull
    private final CommManager _commManager;

    public DefaultReplFactory(@NotNull KernelConfig _kernelConfig, @NotNull ReplConfig _replConfig, @NotNull ReplRuntimeProperties _runtimeProperties, @NotNull List<? extends Object> _scriptReceivers, @NotNull JupyterConnectionInternal _connection, @NotNull CommManager _commManager) {
        Intrinsics.checkNotNullParameter((Object)_kernelConfig, (String)"_kernelConfig");
        Intrinsics.checkNotNullParameter((Object)_replConfig, (String)"_replConfig");
        Intrinsics.checkNotNullParameter((Object)_runtimeProperties, (String)"_runtimeProperties");
        Intrinsics.checkNotNullParameter(_scriptReceivers, (String)"_scriptReceivers");
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        Intrinsics.checkNotNullParameter((Object)_commManager, (String)"_commManager");
        this._kernelConfig = _kernelConfig;
        this._replConfig = _replConfig;
        this._runtimeProperties = _runtimeProperties;
        this._scriptReceivers = _scriptReceivers;
        this._connection = _connection;
        this._commManager = _commManager;
    }

    @Override
    @NotNull
    protected ResolutionInfoProvider provideResolutionInfoProvider() {
        return this._replConfig.getResolutionInfoProvider();
    }

    @Override
    @NotNull
    protected DisplayHandler provideDisplayHandler() {
        return new SocketDisplayHandler(this._connection, this.getNotebook());
    }

    @Override
    @NotNull
    protected List<File> provideScriptClasspath() {
        return this._kernelConfig.getScriptClasspath();
    }

    @Override
    @Nullable
    protected File provideHomeDir() {
        return this._kernelConfig.getHomeDir();
    }

    @Override
    @NotNull
    protected List<RepositoryCoordinates> provideMavenRepositories() {
        return this._replConfig.getMavenRepositories();
    }

    @Override
    @Nullable
    protected LibraryResolver provideLibraryResolver() {
        return this._replConfig.getLibraryResolver();
    }

    @Override
    @NotNull
    protected ReplRuntimeProperties provideRuntimeProperties() {
        return this._runtimeProperties;
    }

    @Override
    @NotNull
    protected List<Object> provideScriptReceivers() {
        return this._scriptReceivers;
    }

    @Override
    protected boolean provideIsEmbedded() {
        return this._replConfig.getEmbedded();
    }

    @Override
    @NotNull
    protected JupyterConnectionInternal provideConnection() {
        return this._connection;
    }

    @Override
    @NotNull
    protected CommManager provideCommManager() {
        return this._commManager;
    }

    @Override
    @Nullable
    protected JupyterClientType provideExplicitClientType() {
        JupyterClientType jupyterClientType2;
        String string = this._kernelConfig.getClientType();
        if (string != null) {
            JupyterClientType jupyterClientType3;
            String typeName = string;
            boolean bl = false;
            try {
                jupyterClientType3 = JupyterClientType.valueOf((String)CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly((String)typeName));
            }
            catch (IllegalArgumentException e) {
                ConfigKt.getLog().warn("Unknown client type: " + typeName);
                jupyterClientType3 = null;
            }
            jupyterClientType2 = jupyterClientType3;
        } else {
            jupyterClientType2 = null;
        }
        return jupyterClientType2;
    }
}

