/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.VariableState;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001a\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u001c\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0002\u001a\u001c\u0010\n\u001a\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"varsTableStyleClass", "", "generateHTMLVarsReport", "variablesState", "", "Lorg/jetbrains/kotlinx/jupyter/api/VariableState;", "generateStyleSection", "borderPx", "", "paddingPx", "generateVarsTable", "kotlin-jupyter-kernel"})
public final class HtmlUtilKt {
    @NotNull
    public static final String varsTableStyleClass = "variables_table";

    @NotNull
    public static final String generateHTMLVarsReport(@NotNull Map<String, ? extends VariableState> variablesState) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(variablesState, (String)"variablesState");
        StringBuilder $this$generateHTMLVarsReport_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateHTMLVarsReport_u24lambda_u2d0.append(HtmlUtilKt.generateStyleSection$default(0, 0, 3, null));
        if (variablesState.isEmpty()) {
            $this$generateHTMLVarsReport_u24lambda_u2d0.append("<h2 style=\"text-align:center;\">Variables State's Empty</h2>\n");
            String string = $this$generateHTMLVarsReport_u24lambda_u2d0.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
            return string;
        }
        $this$generateHTMLVarsReport_u24lambda_u2d0.append("<h2 style=\"text-align:center;\">Variables State</h2>\n");
        $this$generateHTMLVarsReport_u24lambda_u2d0.append(HtmlUtilKt.generateVarsTable(variablesState));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String generateStyleSection(int borderPx, int paddingPx) {
        return StringsKt.trimIndent((String)("\n    <style>\n    table.variables_table, .variables_table th, .variables_table td {\n      border: " + borderPx + "px solid black;\n      border-collapse: collapse;\n      text-align:center;\n    }\n    .variables_table th, .variables_table td {\n      padding: " + paddingPx + "px;\n    }\n    </style>\n    \n    "));
    }

    static /* synthetic */ String generateStyleSection$default(int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            n2 = 5;
        }
        return HtmlUtilKt.generateStyleSection(n, n2);
    }

    private static final String generateVarsTable(Map<String, ? extends VariableState> variablesState) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateVarsTable_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateVarsTable_u24lambda_u2d2.append("<table class=\"variables_table\" style=\"width:80%;margin-left:auto;margin-right:auto;\" align=\"center\">\n  <tr>\n    <th>Variable</th>\n    <th>Value</th>\n  </tr>\n");
        Iterable $this$forEach$iv = variablesState.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            $this$generateVarsTable_u24lambda_u2d2.append(StringsKt.trimIndent((String)("\n                <tr>\n                    <td>" + (String)it.getKey() + "</td>\n                    <td><pre>" + ((VariableState)it.getValue()).getStringValue() + "</pre></td>\n                </tr>\n                ")));
        }
        $this$generateVarsTable_u24lambda_u2d2.append("\n</table>\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

