/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.io.Closeable;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.HMAC;
import org.jetbrains.kotlinx.jupyter.JupyterSockets;
import org.jetbrains.kotlinx.jupyter.KernelConfig;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.messaging.InputReply;
import org.jetbrains.kotlinx.jupyter.messaging.InputRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.KernelStatus;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageData;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.StatusReply;
import org.jetbrains.kotlinx.jupyter.messaging.StreamResponse;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00039:;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020)J7\u0010+\u001a\u00020)2'\u0010,\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0.\u0012\u0006\u0012\u0004\u0018\u00010/0-\u00a2\u0006\u0002\b0\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J(\u00102\u001a\b\u0012\u0004\u0012\u0002H403\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H4062\u0006\u00107\u001a\u000208R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0011R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001a\u001a\u00060\u0011R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001e\u001a\u00060\u0011R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0015\u0010 \u001a\u00060\u0011R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0015\u0010\"\u001a\u00060\u0011R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u0015\u0010$\u001a\u00060%R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;", "Ljava/io/Closeable;", "config", "Lorg/jetbrains/kotlinx/jupyter/KernelConfig;", "(Lorg/jetbrains/kotlinx/jupyter/KernelConfig;)V", "getConfig", "()Lorg/jetbrains/kotlinx/jupyter/KernelConfig;", "context", "Lorg/zeromq/ZMQ$Context;", "kotlin.jvm.PlatformType", "contextMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "getContextMessage", "()Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "setContextMessage", "(Lorg/jetbrains/kotlinx/jupyter/messaging/Message;)V", "control", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;", "getControl", "()Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentExecutions", "Ljava/util/HashSet;", "Ljava/lang/Thread;", "Lkotlin/collections/HashSet;", "heartbeat", "getHeartbeat", "hmac", "Lorg/jetbrains/kotlinx/jupyter/HMAC;", "iopub", "getIopub", "shell", "getShell", "stdin", "getStdin", "stdinIn", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$StdinInputStream;", "getStdinIn", "()Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$StdinInputStream;", "close", "", "interruptExecution", "launchJob", "runnable", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "runExecution", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$ConnectionExecutionResult;", "T", "body", "Lkotlin/Function0;", "classLoader", "Ljava/lang/ClassLoader;", "ConnectionExecutionResult", "Socket", "StdinInputStream", "kotlin-jupyter-kernel"})
public final class JupyterConnection
implements Closeable {
    @NotNull
    private final KernelConfig config;
    @NotNull
    private final HMAC hmac;
    private final ZMQ.Context context;
    @NotNull
    private final Socket heartbeat;
    @NotNull
    private final Socket shell;
    @NotNull
    private final Socket control;
    @NotNull
    private final Socket stdin;
    @NotNull
    private final Socket iopub;
    @NotNull
    private final StdinInputStream stdinIn;
    @Nullable
    private Message contextMessage;
    @NotNull
    private final HashSet<Thread> currentExecutions;
    @NotNull
    private final CoroutineScope coroutineScope;

    public JupyterConnection(@NotNull KernelConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.hmac = new HMAC(StringsKt.replace$default((String)this.config.getSignatureScheme(), (String)"-", (String)"", (boolean)false, (int)4, null), this.config.getSignatureKey());
        this.context = ZMQ.context((int)1);
        this.heartbeat = new Socket(JupyterSockets.HB, null, 2, null);
        this.shell = new Socket(JupyterSockets.SHELL, null, 2, null);
        this.control = new Socket(JupyterSockets.CONTROL, null, 2, null);
        this.stdin = new Socket(JupyterSockets.STDIN, null, 2, null);
        this.iopub = new Socket(JupyterSockets.IOPUB, null, 2, null);
        this.stdinIn = new StdinInputStream();
        this.currentExecutions = new HashSet();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }

    @NotNull
    public final KernelConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Socket getHeartbeat() {
        return this.heartbeat;
    }

    @NotNull
    public final Socket getShell() {
        return this.shell;
    }

    @NotNull
    public final Socket getControl() {
        return this.control;
    }

    @NotNull
    public final Socket getStdin() {
        return this.stdin;
    }

    @NotNull
    public final Socket getIopub() {
        return this.iopub;
    }

    @NotNull
    public final StdinInputStream getStdinIn() {
        return this.stdinIn;
    }

    @Nullable
    public final Message getContextMessage() {
        return this.contextMessage;
    }

    public final void setContextMessage(@Nullable Message message2) {
        this.contextMessage = message2;
    }

    @NotNull
    public final <T> ConnectionExecutionResult<T> runExecution(@NotNull Function0<? extends T> body, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Ref.ObjectRef execRes = new Ref.ObjectRef();
        Ref.ObjectRef execException = new Ref.ObjectRef();
        Thread execThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, (ClassLoader)classLoader, null, (int)0, (Function0)((Function0)new Function0<Unit>(execRes, body, (Ref.ObjectRef<Throwable>)execException){
            final /* synthetic */ Ref.ObjectRef<T> $execRes;
            final /* synthetic */ Function0<T> $body;
            final /* synthetic */ Ref.ObjectRef<Throwable> $execException;
            {
                this.$execRes = $execRes;
                this.$body = $body;
                this.$execException = $execException;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$execRes.element = this.$body.invoke();
                }
                catch (Throwable e) {
                    this.$execException.element = e;
                }
            }
        }), (int)27, null);
        this.currentExecutions.add(execThread2);
        execThread2.join();
        this.currentExecutions.remove(execThread2);
        Throwable exception = (Throwable)execException.element;
        boolean isInterrupted = exception instanceof ThreadDeath || exception instanceof ReplException && ((ReplException)exception).getCause() instanceof ThreadDeath;
        return new ConnectionExecutionResult<Object>(execRes.element, exception, isInterrupted);
    }

    public final void interruptExecution() {
        while (!((Collection)this.currentExecutions).isEmpty()) {
            Thread execution;
            Thread thread = execution = (Thread)CollectionsKt.firstOrNull((Iterable)this.currentExecutions);
            if (thread != null) {
                thread.stop();
            }
            ((Collection)this.currentExecutions).remove(execution);
        }
    }

    public final void launchJob(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, runnable, (int)3, null);
    }

    @Override
    public void close() {
        this.heartbeat.close();
        this.shell.close();
        this.control.close();
        this.stdin.close();
        this.iopub.close();
        this.context.close();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u000f\u001a\u0004\u0018\u00010\u00102!\u0010\u0011\u001a\u001d\u0012\b\u0012\u00060\u0000R\u00020\b\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J6\u0010\u0016\u001a\u0004\u0018\u00010\u00102!\u0010\u0011\u001a\u001d\u0012\b\u0012\u00060\u0000R\u00020\b\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0017J\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u0016\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u0017J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;", "Lorg/zeromq/ZMQ$Socket;", "socket", "Lorg/jetbrains/kotlinx/jupyter/JupyterSockets;", "type", "Lorg/zeromq/SocketType;", "(Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;Lorg/jetbrains/kotlinx/jupyter/JupyterSockets;Lorg/zeromq/SocketType;)V", "connection", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;", "getConnection", "()Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;", "name", "", "getName", "()Ljava/lang/String;", "onData", "", "body", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Lkotlin/Unit;", "onMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "receiveMessage", "start", "send", "msg", "sendOut", "stream", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterOutType;", "text", "sendStatus", "status", "Lorg/jetbrains/kotlinx/jupyter/messaging/KernelStatus;", "sendWrapped", "incomingMessage", "kotlin-jupyter-kernel"})
    public final class Socket
    extends ZMQ.Socket {
        @NotNull
        private final JupyterSockets socket;
        @NotNull
        private final JupyterConnection connection;

        public Socket(@NotNull JupyterSockets socket, SocketType type) {
            Intrinsics.checkNotNullParameter((Object)JupyterConnection.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)socket), (String)"socket");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(JupyterConnection.this.context, type);
            this.socket = socket;
            int port = ((Number)JupyterConnection.this.getConfig().getPorts().get(this.socket.ordinal())).intValue();
            this.bind(JupyterConnection.this.getConfig().getTransport() + "://*:" + port);
            if (type == SocketType.PUB) {
                Thread.sleep(500L);
            }
            ConfigKt.getLog().debug('[' + this.getName() + "] listen: " + JupyterConnection.this.getConfig().getTransport() + "://*:" + port);
            this.connection = JupyterConnection.this;
        }

        public /* synthetic */ Socket(JupyterSockets jupyterSockets, SocketType socketType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                socketType = jupyterSockets.getZmqKernelType();
            }
            this(jupyterSockets, socketType);
        }

        @NotNull
        public final String getName() {
            return this.socket.name();
        }

        @Nullable
        public final Unit onData(@NotNull Function2<? super Socket, ? super byte[], Unit> body) {
            Unit unit;
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean $i$f$onData = false;
            byte[] byArray = this.recv();
            if (byArray == null) {
                unit = null;
            } else {
                byte[] it = byArray;
                boolean bl = false;
                body.invoke((Object)this, (Object)it);
                unit = Unit.INSTANCE;
            }
            return unit;
        }

        @Nullable
        public final Unit onMessage(@NotNull Function2<? super Socket, ? super Message, Unit> body) {
            Unit unit;
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean $i$f$onMessage = false;
            byte[] byArray = this.recv();
            if (byArray == null) {
                unit = null;
            } else {
                byte[] bytes = byArray;
                boolean bl = false;
                Message message2 = this.receiveMessage(bytes);
                if (message2 == null) {
                    unit = null;
                } else {
                    Message it = message2;
                    boolean bl2 = false;
                    body.invoke((Object)this, (Object)it);
                    unit = Unit.INSTANCE;
                }
            }
            return unit;
        }

        public final void sendStatus(@NotNull KernelStatus status, @NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.connection.getIopub().send(MessageKt.makeReplyMessage$default(msg, MessageType.STATUS, null, null, null, null, new StatusReply(status), 60, null));
        }

        public final void sendWrapped(@NotNull Message incomingMessage, @NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)incomingMessage, (String)"incomingMessage");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.sendStatus(KernelStatus.BUSY, incomingMessage);
            this.send(msg);
            this.sendStatus(KernelStatus.IDLE, incomingMessage);
        }

        public final void sendOut(@NotNull Message msg, @NotNull JupyterOutType stream, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)((Object)stream), (String)"stream");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.send(MessageKt.makeReplyMessage$default(msg, null, null, MessageKt.makeHeader$default(MessageType.STREAM, msg, null, 4, null), null, null, new StreamResponse(stream.optionName(), text), 54, null));
        }

        public final void send(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            ConfigKt.getLog().debug('[' + this.getName() + "] snd>: " + msg);
            ConnectionKt.sendMessage(this, msg, JupyterConnection.this.hmac);
        }

        @Nullable
        public final Message receiveMessage(@NotNull byte[] start) {
            Message message2;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            try {
                Message msg = ConnectionKt.receiveMessage(this, start, JupyterConnection.this.hmac);
                ConfigKt.getLog().debug('[' + this.getName() + "] >rcv: " + msg);
            }
            catch (SignatureException e) {
                ConfigKt.getLog().error('[' + this.getName() + "] " + e.getMessage());
                message2 = null;
            }
            return message2;
        }

        @NotNull
        public final JupyterConnection getConnection() {
            return this.connection;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$StdinInputStream;", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;)V", "currentBuf", "", "currentBufPos", "", "getInput", "", "initializeCurrentBuf", "read", "b", "off", "len", "kotlin-jupyter-kernel"})
    public final class StdinInputStream
    extends InputStream {
        @Nullable
        private byte[] currentBuf;
        private int currentBufPos;

        public StdinInputStream() {
            Intrinsics.checkNotNullParameter((Object)JupyterConnection.this, (String)"this$0");
        }

        private final String getInput() {
            InputReply content;
            Object object;
            Message msg;
            Socket socket = JupyterConnection.this.getStdin();
            Message message2 = JupyterConnection.this.getContextMessage();
            Intrinsics.checkNotNull((Object)message2);
            socket.send(MessageKt.makeReplyMessage$default(message2, MessageType.INPUT_REQUEST, null, null, null, null, new InputRequest("stdin:", false, 2, null), 60, null));
            Socket socket2 = JupyterConnection.this.getStdin();
            byte[] byArray = JupyterConnection.this.getStdin().recv();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stdin.recv()");
            Message message3 = msg = socket2.receiveMessage(byArray);
            if (message3 == null) {
                object = null;
            } else {
                MessageData messageData = message3.getData();
                object = messageData == null ? null : messageData.getContent();
            }
            MessageContent messageContent = object;
            InputReply inputReply = content = messageContent instanceof InputReply ? (InputReply)messageContent : null;
            String string = inputReply == null ? null : inputReply.getValue();
            if (string == null) {
                throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unexpected input message ", (Object)msg));
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] initializeCurrentBuf() {
            byte[] byArray;
            byte[] buf = this.currentBuf;
            if (buf != null) {
                byArray = buf;
            } else {
                void var2_4;
                String string = this.getInput();
                byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                byte[] newBuf = byArray2;
                this.currentBuf = newBuf;
                this.currentBufPos = 0;
                byArray = var2_4;
            }
            return byArray;
        }

        @Override
        public synchronized int read() {
            byte[] buf = this.initializeCurrentBuf();
            if (this.currentBufPos >= buf.length) {
                this.currentBuf = null;
                return -1;
            }
            int n = this.currentBufPos;
            this.currentBufPos = n + 1;
            return buf[n];
        }

        @Override
        public synchronized int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            byte[] buf = this.initializeCurrentBuf();
            int lenLeft = buf.length - this.currentBufPos;
            if (lenLeft <= 0) {
                this.currentBuf = null;
                return -1;
            }
            int lenToRead = Math.min(len, lenLeft);
            int n = 0;
            while (n < lenToRead) {
                int i = n++;
                b[off + i] = buf[this.currentBufPos + i];
            }
            this.currentBufPos += lenToRead;
            return lenToRead;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$ConnectionExecutionResult;", "T", "", "result", "throwable", "", "isInterrupted", "", "(Ljava/lang/Object;Ljava/lang/Throwable;Z)V", "()Z", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getThrowable", "()Ljava/lang/Throwable;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Throwable;Z)Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$ConnectionExecutionResult;", "equals", "other", "hashCode", "", "toString", "", "kotlin-jupyter-kernel"})
    public static final class ConnectionExecutionResult<T> {
        @Nullable
        private final T result;
        @Nullable
        private final Throwable throwable;
        private final boolean isInterrupted;

        public ConnectionExecutionResult(@Nullable T result2, @Nullable Throwable throwable, boolean isInterrupted) {
            this.result = result2;
            this.throwable = throwable;
            this.isInterrupted = isInterrupted;
        }

        @Nullable
        public final T getResult() {
            return this.result;
        }

        @Nullable
        public final Throwable getThrowable() {
            return this.throwable;
        }

        public final boolean isInterrupted() {
            return this.isInterrupted;
        }

        @Nullable
        public final T component1() {
            return this.result;
        }

        @Nullable
        public final Throwable component2() {
            return this.throwable;
        }

        public final boolean component3() {
            return this.isInterrupted;
        }

        @NotNull
        public final ConnectionExecutionResult<T> copy(@Nullable T result2, @Nullable Throwable throwable, boolean isInterrupted) {
            return new ConnectionExecutionResult<T>(result2, throwable, isInterrupted);
        }

        public static /* synthetic */ ConnectionExecutionResult copy$default(ConnectionExecutionResult connectionExecutionResult, Object object, Throwable throwable, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = connectionExecutionResult.result;
            }
            if ((n & 2) != 0) {
                throwable = connectionExecutionResult.throwable;
            }
            if ((n & 4) != 0) {
                bl = connectionExecutionResult.isInterrupted;
            }
            return connectionExecutionResult.copy(object, throwable, bl);
        }

        @NotNull
        public String toString() {
            return "ConnectionExecutionResult(result=" + this.result + ", throwable=" + this.throwable + ", isInterrupted=" + this.isInterrupted + ')';
        }

        public int hashCode() {
            int result2 = this.result == null ? 0 : this.result.hashCode();
            result2 = result2 * 31 + (this.throwable == null ? 0 : this.throwable.hashCode());
            int n = this.isInterrupted ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionExecutionResult)) {
                return false;
            }
            ConnectionExecutionResult connectionExecutionResult = (ConnectionExecutionResult)other;
            if (!Intrinsics.areEqual(this.result, connectionExecutionResult.result)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.throwable, (Object)connectionExecutionResult.throwable)) {
                return false;
            }
            return this.isInterrupted == connectionExecutionResult.isInterrupted;
        }
    }
}

