/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.KernelArgs;
import org.jetbrains.kotlinx.jupyter.KernelJupyterParams;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ@\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/jupyter/KernelArgs;", "", "cfgFile", "Ljava/io/File;", "scriptClasspath", "", "homeDir", "debugPort", "", "(Ljava/io/File;Ljava/util/List;Ljava/io/File;Ljava/lang/Integer;)V", "getCfgFile", "()Ljava/io/File;", "getDebugPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHomeDir", "getScriptClasspath", "()Ljava/util/List;", "argsList", "", "component1", "component2", "component3", "component4", "copy", "(Ljava/io/File;Ljava/util/List;Ljava/io/File;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/jupyter/KernelArgs;", "equals", "", "other", "hashCode", "parseParams", "Lorg/jetbrains/kotlinx/jupyter/KernelJupyterParams;", "toString", "kotlin-jupyter-kernel"})
public final class KernelArgs {
    @NotNull
    private final File cfgFile;
    @NotNull
    private final List<File> scriptClasspath;
    @Nullable
    private final File homeDir;
    @Nullable
    private final Integer debugPort;

    public KernelArgs(@NotNull File cfgFile, @NotNull List<? extends File> scriptClasspath, @Nullable File homeDir, @Nullable Integer debugPort) {
        Intrinsics.checkNotNullParameter((Object)cfgFile, (String)"cfgFile");
        Intrinsics.checkNotNullParameter(scriptClasspath, (String)"scriptClasspath");
        this.cfgFile = cfgFile;
        this.scriptClasspath = scriptClasspath;
        this.homeDir = homeDir;
        this.debugPort = debugPort;
    }

    @NotNull
    public final File getCfgFile() {
        return this.cfgFile;
    }

    @NotNull
    public final List<File> getScriptClasspath() {
        return this.scriptClasspath;
    }

    @Nullable
    public final File getHomeDir() {
        return this.homeDir;
    }

    @Nullable
    public final Integer getDebugPort() {
        return this.debugPort;
    }

    @NotNull
    public final KernelJupyterParams parseParams() {
        return KernelJupyterParams.Companion.fromFile(this.cfgFile);
    }

    @NotNull
    public final List<String> argsList() {
        List list;
        List $this$argsList_u24lambda_u2d2 = list = (List)new ArrayList();
        boolean bl = false;
        String string = this.getCfgFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cfgFile.absolutePath");
        $this$argsList_u24lambda_u2d2.add(string);
        File file = this.getHomeDir();
        if (file != null) {
            File it = file;
            boolean bl2 = false;
            $this$argsList_u24lambda_u2d2.add(Intrinsics.stringPlus((String)"-home=", (Object)it.getAbsolutePath()));
        }
        if (!((Collection)this.getScriptClasspath()).isEmpty()) {
            Iterable iterable = this.getScriptClasspath();
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            String classPathString2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, (Function1)argsList.1.classPathString.1.INSTANCE, (int)30, null);
            $this$argsList_u24lambda_u2d2.add(Intrinsics.stringPlus((String)"-cp=", (Object)classPathString2));
        }
        Integer n = this.getDebugPort();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            $this$argsList_u24lambda_u2d2.add(Intrinsics.stringPlus((String)"-debugPort=", (Object)it));
        }
        return list;
    }

    @NotNull
    public final File component1() {
        return this.cfgFile;
    }

    @NotNull
    public final List<File> component2() {
        return this.scriptClasspath;
    }

    @Nullable
    public final File component3() {
        return this.homeDir;
    }

    @Nullable
    public final Integer component4() {
        return this.debugPort;
    }

    @NotNull
    public final KernelArgs copy(@NotNull File cfgFile, @NotNull List<? extends File> scriptClasspath, @Nullable File homeDir, @Nullable Integer debugPort) {
        Intrinsics.checkNotNullParameter((Object)cfgFile, (String)"cfgFile");
        Intrinsics.checkNotNullParameter(scriptClasspath, (String)"scriptClasspath");
        return new KernelArgs(cfgFile, scriptClasspath, homeDir, debugPort);
    }

    public static /* synthetic */ KernelArgs copy$default(KernelArgs kernelArgs, File file, List list, File file2, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = kernelArgs.cfgFile;
        }
        if ((n2 & 2) != 0) {
            list = kernelArgs.scriptClasspath;
        }
        if ((n2 & 4) != 0) {
            file2 = kernelArgs.homeDir;
        }
        if ((n2 & 8) != 0) {
            n = kernelArgs.debugPort;
        }
        return kernelArgs.copy(file, list, file2, n);
    }

    @NotNull
    public String toString() {
        return "KernelArgs(cfgFile=" + this.cfgFile + ", scriptClasspath=" + this.scriptClasspath + ", homeDir=" + this.homeDir + ", debugPort=" + this.debugPort + ')';
    }

    public int hashCode() {
        int result2 = this.cfgFile.hashCode();
        result2 = result2 * 31 + ((Object)this.scriptClasspath).hashCode();
        result2 = result2 * 31 + (this.homeDir == null ? 0 : this.homeDir.hashCode());
        result2 = result2 * 31 + (this.debugPort == null ? 0 : ((Object)this.debugPort).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KernelArgs)) {
            return false;
        }
        KernelArgs kernelArgs = (KernelArgs)other;
        if (!Intrinsics.areEqual((Object)this.cfgFile, (Object)kernelArgs.cfgFile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scriptClasspath, kernelArgs.scriptClasspath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.homeDir, (Object)kernelArgs.homeDir)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.debugPort, (Object)kernelArgs.debugPort);
    }
}

