/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jupyter.kotlin.JavaRuntime;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.CodeCellImpl;
import org.jetbrains.kotlinx.jupyter.DisplayContainerImpl;
import org.jetbrains.kotlinx.jupyter.EvalData;
import org.jetbrains.kotlinx.jupyter.HtmlUtilKt;
import org.jetbrains.kotlinx.jupyter.NotebookImpl;
import org.jetbrains.kotlinx.jupyter.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.api.DisplayResultWithCell;
import org.jetbrains.kotlinx.jupyter.api.JREInfoProvider;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.RenderersProcessor;
import org.jetbrains.kotlinx.jupyter.api.ResultsAccessor;
import org.jetbrains.kotlinx.jupyter.api.VariableState;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionRequest;
import org.jetbrains.kotlinx.jupyter.libraries.LibrariesProcessor;
import org.jetbrains.kotlinx.jupyter.repl.InternalEvaluator;
import org.jetbrains.kotlinx.jupyter.repl.impl.SharedReplContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0016J\u0010\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u0007H\u0016J\u0018\u0010P\u001a\b\u0012\u0004\u0012\u00020M0L2\b\u0010O\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010O\u001a\u00020\u0007H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010S\u001a\u00020\u0007H\u0016J\u0006\u0010T\u001a\u00020\tJ\u0006\u0010U\u001a\u00020\tR&\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u001cj\b\u0012\u0004\u0012\u00020\u000e`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020#8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0016R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0013R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R \u0010A\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020B0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u000b\u00a8\u0006V"}, d2={"Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "runtimeProperties", "Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;", "(Lorg/jetbrains/kotlinx/jupyter/ReplRuntimeProperties;)V", "cellVariables", "", "", "", "", "getCellVariables", "()Ljava/util/Map;", "cells", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlinx/jupyter/CodeCellImpl;", "Lkotlin/collections/HashMap;", "cellsList", "", "getCellsList", "()Ljava/util/Collection;", "currentCell", "getCurrentCell", "()Lorg/jetbrains/kotlinx/jupyter/CodeCellImpl;", "displays", "Lorg/jetbrains/kotlinx/jupyter/DisplayContainerImpl;", "getDisplays", "()Lorg/jetbrains/kotlinx/jupyter/DisplayContainerImpl;", "history", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "jreInfo", "Lorg/jetbrains/kotlinx/jupyter/api/JREInfoProvider;", "getJreInfo", "()Lorg/jetbrains/kotlinx/jupyter/api/JREInfoProvider;", "jupyterClientType", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "getJupyterClientType", "()Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "jupyterClientType$delegate", "Lkotlin/Lazy;", "kernelVersion", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "getKernelVersion", "()Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "lastCell", "getLastCell", "libraryRequests", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionRequest;", "getLibraryRequests", "mainCellCreated", "", "renderersProcessor", "Lorg/jetbrains/kotlinx/jupyter/api/RenderersProcessor;", "getRenderersProcessor", "()Lorg/jetbrains/kotlinx/jupyter/api/RenderersProcessor;", "resultsAccessor", "Lorg/jetbrains/kotlinx/jupyter/api/ResultsAccessor;", "getResultsAccessor", "()Lorg/jetbrains/kotlinx/jupyter/api/ResultsAccessor;", "sharedReplContext", "Lorg/jetbrains/kotlinx/jupyter/repl/impl/SharedReplContext;", "getSharedReplContext$kotlin_jupyter_kernel", "()Lorg/jetbrains/kotlinx/jupyter/repl/impl/SharedReplContext;", "setSharedReplContext$kotlin_jupyter_kernel", "(Lorg/jetbrains/kotlinx/jupyter/repl/impl/SharedReplContext;)V", "variablesState", "Lorg/jetbrains/kotlinx/jupyter/api/VariableState;", "getVariablesState", "addCell", "internalId", "preprocessedCode", "data", "Lorg/jetbrains/kotlinx/jupyter/EvalData;", "beginEvalSession", "", "getAllDisplays", "", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResultWithCell;", "getCell", "id", "getDisplaysById", "getResult", "", "before", "variablesReport", "variablesReportAsHTML", "kotlin-jupyter-kernel"})
public final class NotebookImpl
implements Notebook {
    @NotNull
    private final ReplRuntimeProperties runtimeProperties;
    @NotNull
    private final HashMap<Integer, CodeCellImpl> cells;
    @Nullable
    private SharedReplContext sharedReplContext;
    @NotNull
    private final ResultsAccessor resultsAccessor;
    @NotNull
    private final ArrayList<CodeCellImpl> history;
    private boolean mainCellCreated;
    @NotNull
    private final DisplayContainerImpl displays;
    @NotNull
    private final Lazy jupyterClientType$delegate;

    public NotebookImpl(@NotNull ReplRuntimeProperties runtimeProperties) {
        Intrinsics.checkNotNullParameter((Object)runtimeProperties, (String)"runtimeProperties");
        this.runtimeProperties = runtimeProperties;
        this.cells = new HashMap();
        this.resultsAccessor = new ResultsAccessor(this){
            final /* synthetic */ NotebookImpl this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final Object get(int it) {
                return this.this$0.getResult(it);
            }
        };
        this.history = new ArrayList();
        this.displays = new DisplayContainerImpl();
        this.jupyterClientType$delegate = LazyKt.lazy((Function0)jupyterClientType.2.INSTANCE);
    }

    @Nullable
    public final SharedReplContext getSharedReplContext$kotlin_jupyter_kernel() {
        return this.sharedReplContext;
    }

    public final void setSharedReplContext$kotlin_jupyter_kernel(@Nullable SharedReplContext sharedReplContext) {
        this.sharedReplContext = sharedReplContext;
    }

    @NotNull
    public Collection<CodeCellImpl> getCellsList() {
        Collection<CodeCellImpl> collection = this.cells.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"cells.values");
        return collection;
    }

    @NotNull
    public Map<String, VariableState> getVariablesState() {
        Map<String, VariableState> map;
        Map<String, Object> map2;
        SharedReplContext sharedReplContext = this.sharedReplContext;
        if (sharedReplContext == null) {
            map2 = null;
        } else {
            InternalEvaluator internalEvaluator = sharedReplContext.getEvaluator();
            map2 = map = internalEvaluator == null ? null : internalEvaluator.getVariablesHolder();
        }
        if (map == null) {
            throw new IllegalStateException("Evaluator is not initialized yet");
        }
        return map;
    }

    @NotNull
    public Map<Integer, Set<String>> getCellVariables() {
        Map<Integer, Set<String>> map;
        Map<Integer, Set<String>> map2;
        SharedReplContext sharedReplContext = this.sharedReplContext;
        if (sharedReplContext == null) {
            map2 = null;
        } else {
            InternalEvaluator internalEvaluator = sharedReplContext.getEvaluator();
            map2 = map = internalEvaluator == null ? null : internalEvaluator.getCellVariables();
        }
        if (map == null) {
            throw new IllegalStateException("Evaluator is not initialized yet");
        }
        return map;
    }

    @NotNull
    public ResultsAccessor getResultsAccessor() {
        return this.resultsAccessor;
    }

    @NotNull
    public CodeCellImpl getCell(int id) {
        CodeCellImpl codeCellImpl = this.cells.get(id);
        if (codeCellImpl == null) {
            throw new ArrayIndexOutOfBoundsException("There is no cell with number '" + id + '\'');
        }
        return codeCellImpl;
    }

    @Nullable
    public Object getResult(int id) {
        return this.getCell(id).getResult();
    }

    @NotNull
    public final DisplayContainerImpl getDisplays() {
        return this.displays;
    }

    @NotNull
    public List<DisplayResultWithCell> getAllDisplays() {
        return this.displays.getAll();
    }

    @NotNull
    public List<DisplayResultWithCell> getDisplaysById(@Nullable String id) {
        return this.displays.getById(id);
    }

    @NotNull
    public KotlinKernelVersion getKernelVersion() {
        KotlinKernelVersion kotlinKernelVersion = this.runtimeProperties.getVersion();
        if (kotlinKernelVersion == null) {
            throw new IllegalStateException("Kernel version is not known");
        }
        return kotlinKernelVersion;
    }

    @NotNull
    public JREInfoProvider getJreInfo() {
        return (JREInfoProvider)JavaRuntime.INSTANCE;
    }

    @NotNull
    public JupyterClientType getJupyterClientType() {
        Lazy lazy = this.jupyterClientType$delegate;
        return (JupyterClientType)lazy.getValue();
    }

    @NotNull
    public final String variablesReportAsHTML() {
        return HtmlUtilKt.generateHTMLVarsReport(this.getVariablesState());
    }

    @NotNull
    public final String variablesReport() {
        String string;
        if (this.getVariablesState().isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$variablesReport_u24lambda_u2d1 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$variablesReport_u24lambda_u2d1.append("Visible vars: \n");
            Map<String, VariableState> $this$forEach$iv = this.getVariablesState();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, VariableState>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, VariableState> element$iv;
                Map.Entry<String, VariableState> $dstr$name$currentState = element$iv = iterator.next();
                boolean bl2 = false;
                String name = $dstr$name$currentState.getKey();
                VariableState currentState = $dstr$name$currentState.getValue();
                $this$variablesReport_u24lambda_u2d1.append('\t' + name + " : " + currentState.getStringValue() + '\n');
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            string = string2;
        }
        return string;
    }

    @NotNull
    public final CodeCellImpl addCell(int internalId, @NotNull String preprocessedCode, @NotNull EvalData data) {
        Intrinsics.checkNotNullParameter((Object)preprocessedCode, (String)"preprocessedCode");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CodeCellImpl cell2 = new CodeCellImpl(this, data.getExecutionCounter(), internalId, data.getRawCode(), preprocessedCode, this.getLastCell());
        Map map = this.cells;
        Integer n = data.getExecutionCounter();
        map.put(n, cell2);
        this.history.add(cell2);
        this.mainCellCreated = true;
        return cell2;
    }

    public final void beginEvalSession() {
        this.mainCellCreated = false;
    }

    @Nullable
    public CodeCellImpl history(int before) {
        int offset = this.mainCellCreated ? 1 : 0;
        return (CodeCellImpl)CollectionsKt.getOrNull((List)this.history, (int)(this.history.size() - offset - before));
    }

    @Nullable
    public CodeCellImpl getCurrentCell() {
        return this.history(0);
    }

    @Nullable
    public CodeCellImpl getLastCell() {
        return this.history(1);
    }

    @NotNull
    public RenderersProcessor getRenderersProcessor() {
        SharedReplContext sharedReplContext = this.sharedReplContext;
        Object object = sharedReplContext == null ? null : sharedReplContext.getRenderersProcessor();
        if (object == null) {
            throw new IllegalStateException("Type renderers processor is not initialized yet");
        }
        return (RenderersProcessor)object;
    }

    @NotNull
    public Collection<LibraryResolutionRequest> getLibraryRequests() {
        Collection collection;
        Collection collection2;
        SharedReplContext sharedReplContext = this.sharedReplContext;
        if (sharedReplContext == null) {
            collection2 = null;
        } else {
            LibrariesProcessor librariesProcessor = sharedReplContext.getLibrariesProcessor();
            collection2 = collection = librariesProcessor == null ? null : librariesProcessor.getRequests();
        }
        if (collection2 == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }
}

