/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionRequest;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.libraries.LibrariesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryParsingUtilKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.TrivialLibraryDefinitionProducer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesProcessorImpl;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesProcessor;", "libraries", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "kernelVersion", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;)V", "_requests", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionRequest;", "requests", "", "getRequests", "()Ljava/util/Collection;", "checkKernelVersionRequirements", "", "name", "", "library", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "processNewLibraries", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinitionProducer;", "arg", "kotlin-jupyter-kernel"})
public final class LibrariesProcessorImpl
implements LibrariesProcessor {
    @Nullable
    private final LibraryResolver libraries;
    @Nullable
    private final KotlinKernelVersion kernelVersion;
    @NotNull
    private final List<LibraryResolutionRequest> _requests;

    public LibrariesProcessorImpl(@Nullable LibraryResolver libraries2, @Nullable KotlinKernelVersion kernelVersion) {
        this.libraries = libraries2;
        this.kernelVersion = kernelVersion;
        this._requests = new ArrayList();
    }

    @NotNull
    public Collection<LibraryResolutionRequest> getRequests() {
        return this._requests;
    }

    private final void checkKernelVersionRequirements(String name, LibraryDefinition library) {
        KotlinKernelVersion kotlinKernelVersion = library.getMinKernelVersion();
        if (kotlinKernelVersion != null) {
            KotlinKernelVersion minVersion = kotlinKernelVersion;
            boolean bl = false;
            KotlinKernelVersion kotlinKernelVersion2 = this.kernelVersion;
            if (kotlinKernelVersion2 != null) {
                KotlinKernelVersion currentVersion = kotlinKernelVersion2;
                boolean bl2 = false;
                if (currentVersion.compareTo(minVersion) < 0) {
                    throw new ReplException("Library '" + name + "' requires at least " + minVersion + " version of kernel. Current kernel version is " + currentVersion + ". Please update kernel", null, 2, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<LibraryDefinitionProducer> processNewLibraries(@NotNull String arg) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Iterable $this$map$iv = LibraryParsingUtilKt.splitLibraryCalls(arg);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LibraryDefinition libraryDefinition;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<LibraryReference, List<Variable>> pair = LibraryParsingUtilKt.parseReferenceWithArgs((String)it);
            LibraryReference libRef = (LibraryReference)pair.component1();
            List vars = (List)pair.component2();
            LibraryResolver libraryResolver = this.libraries;
            LibraryDefinition libraryDefinition2 = libraryDefinition = libraryResolver == null ? null : libraryResolver.resolve(libRef, vars);
            if (libraryDefinition == null) {
                throw new ReplException("Unknown library '" + libRef + '\'', null, 2, null);
            }
            LibraryDefinition library = libraryDefinition;
            this._requests.add(new LibraryResolutionRequest(libRef, vars, library));
            this.checkKernelVersionRequirements(libRef.toString(), library);
            collection.add(new TrivialLibraryDefinitionProducer(library));
        }
        return (List)destination$iv$iv;
    }
}

