/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.SourceCodeCompletionVariant;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.UtilKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.common.ReplEnum;
import org.jetbrains.kotlinx.jupyter.common.ReplLineMagic;
import org.jetbrains.kotlinx.jupyter.compiler.util.CodeInterval;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.ArgParseResult;
import org.jetbrains.kotlinx.jupyter.libraries.Brackets;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryParsingUtilKt;
import org.jetbrains.kotlinx.jupyter.magics.AbstractMagicsProcessor;
import org.jetbrains.kotlinx.jupyter.magics.CompletionMagicsProcessor;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor;", "Lorg/jetbrains/kotlinx/jupyter/magics/AbstractMagicsProcessor;", "homeDir", "Ljava/io/File;", "(Ljava/io/File;)V", "process", "Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Result;", "code", "", "cursor", "", "Companion", "Handler", "Result", "kotlin-jupyter-kernel"})
public final class CompletionMagicsProcessor
extends AbstractMagicsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File homeDir;
    @NotNull
    private static final Regex MAVEN_DEP_REGEX = new Regex("^([^:]+):([^:]+):([^:]+)$");
    @NotNull
    private static final Function1<Companion.ArtifactLocation, List<String>> getVersions = UtilKt.createCachedFun(Companion.getVersions.1.INSTANCE);

    public CompletionMagicsProcessor(@Nullable File homeDir) {
        super(false, 1, null);
        this.homeDir = homeDir;
    }

    @NotNull
    public final Result process(@NotNull String code, int cursor) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Sequence magics2 = this.magicsIntervals(code);
        boolean insideMagic = false;
        Handler handler = new Handler();
        for (CodeInterval magicRange : magics2) {
            int n = magicRange.getFrom() + 1;
            boolean bl = cursor <= magicRange.getTo() ? n <= cursor : false;
            if (!bl) continue;
            insideMagic = true;
            if (code.charAt(magicRange.getFrom()) != '%' || cursor == magicRange.getFrom()) continue;
            String string = code.substring(magicRange.getFrom() + 1, magicRange.getTo());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String magicText = string;
            LoggingKt.catchAll$default((Logger)ConfigKt.getLog(), null, (String)("Handling completion of " + magicText + " failed"), (Function0)((Function0)new Function0<Unit>(handler, magicText, cursor, magicRange){
                final /* synthetic */ Handler $handler;
                final /* synthetic */ String $magicText;
                final /* synthetic */ int $cursor;
                final /* synthetic */ CodeInterval $magicRange;
                {
                    this.$handler = $handler;
                    this.$magicText = $magicText;
                    this.$cursor = $cursor;
                    this.$magicRange = $magicRange;
                    super(0);
                }

                public final void invoke() {
                    this.$handler.handle(this.$magicText, this.$cursor - this.$magicRange.getFrom() - 1);
                }
            }), (int)1, null);
        }
        return new Result(this.getCleanCode(code, magics2), insideMagic, handler.getCompletions());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Result;", "", "code", "", "cursorInsideMagic", "", "completions", "", "Lkotlin/script/experimental/api/SourceCodeCompletionVariant;", "(Ljava/lang/String;ZLjava/util/List;)V", "getCode", "()Ljava/lang/String;", "getCompletions", "()Ljava/util/List;", "getCursorInsideMagic", "()Z", "kotlin-jupyter-kernel"})
    public static final class Result {
        @NotNull
        private final String code;
        private final boolean cursorInsideMagic;
        @NotNull
        private final List<SourceCodeCompletionVariant> completions;

        public Result(@NotNull String code, boolean cursorInsideMagic, @NotNull List<SourceCodeCompletionVariant> completions) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter(completions, (String)"completions");
            this.code = code;
            this.cursorInsideMagic = cursorInsideMagic;
            this.completions = completions;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public final boolean getCursorInsideMagic() {
            return this.cursorInsideMagic;
        }

        @NotNull
        public final List<SourceCodeCompletionVariant> getCompletions() {
            return this.completions;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Handler;", "", "(Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor;)V", "_completions", "", "Lkotlin/script/experimental/api/SourceCodeCompletionVariant;", "completions", "", "getCompletions", "()Ljava/util/List;", "handle", "", "magicText", "", "cursor", "", "handleLibrary", "librarySubstring", "kotlin-jupyter-kernel"})
    private final class Handler {
        @NotNull
        private final List<SourceCodeCompletionVariant> _completions;

        public Handler() {
            Intrinsics.checkNotNullParameter((Object)((Object)CompletionMagicsProcessor.this), (String)"this$0");
            this._completions = new ArrayList();
        }

        @NotNull
        public final List<SourceCodeCompletionVariant> getCompletions() {
            Iterable $this$distinctBy$iv = this._completions;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                SourceCodeCompletionVariant it = (SourceCodeCompletionVariant)e$iv;
                boolean bl = false;
                String key$iv = it.getText();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final void handle(@NotNull String magicText, int cursor) {
            block3: {
                int firstSpaceIndex;
                block4: {
                    void $this$mapTo$iv;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)magicText, (String)"magicText");
                    firstSpaceIndex = StringsKt.indexOf$default((CharSequence)magicText, (char)' ', (int)0, (boolean)false, (int)6, null);
                    if (cursor > firstSpaceIndex && firstSpaceIndex != -1) break block4;
                    String string = magicText;
                    int n = 0;
                    String string2 = string.substring(n, cursor);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String magicPrefix = string2;
                    Iterable $this$filter$iv = ReplLineMagic.Companion.getCodeInsightValues();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        ReplEnum.CodeInsightValue it = (ReplEnum.CodeInsightValue)element$iv$iv;
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)it.getName(), (String)magicPrefix, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List suggestions = (List)destination$iv$iv;
                    $this$filter$iv = suggestions;
                    Collection destination$iv = this._completions;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void mg;
                        ReplEnum.CodeInsightValue codeInsightValue = (ReplEnum.CodeInsightValue)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        collection.add(Companion.variant(mg.getName(), mg.getType().getName()));
                    }
                    break block3;
                }
                String suggestions = magicText;
                int $this$mapTo$iv = 0;
                String string = suggestions.substring($this$mapTo$iv, firstSpaceIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String magicName = string;
                string = magicText.substring(firstSpaceIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String argument = string;
                int cursorToArgument = cursor - firstSpaceIndex;
                ReplEnum.CodeInsightValue codeInsightValue = ReplLineMagic.Companion.valueOfOrNull(magicName);
                ReplLineMagic replLineMagic = codeInsightValue == null ? null : (ReplLineMagic)codeInsightValue.getValue();
                if ((replLineMagic == null ? -1 : WhenMappings.$EnumSwitchMapping$0[replLineMagic.ordinal()]) != 1) break block3;
                for (Pair<Integer, Integer> pair : LibraryParsingUtilKt.libraryCommaRanges(argument)) {
                    int from = ((Number)pair.component1()).intValue();
                    int to = ((Number)pair.component2()).intValue();
                    boolean bl = from + 1 <= cursorToArgument ? cursorToArgument <= to : false;
                    if (!bl) continue;
                    String string3 = argument;
                    int n = from + 1;
                    String string4 = string3.substring(n, to);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String libArgPart = string4;
                    this.handleLibrary(libArgPart, cursorToArgument - from - 1);
                    break;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleLibrary(String librarySubstring, int cursor) {
            if (CompletionMagicsProcessor.this.homeDir == null) {
                return;
            }
            Map descriptors = (Map)UtilKt.getLibraryDescriptors().invoke((Object)CompletionMagicsProcessor.this.homeDir);
            int firstBracketIndex = StringsKt.indexOf$default((CharSequence)librarySubstring, (char)'(', (int)0, (boolean)false, (int)6, null);
            if (cursor <= firstBracketIndex || firstBracketIndex == -1) {
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                String string = librarySubstring;
                int n = 0;
                String string2 = string.substring(n, cursor);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String libNamePrefix = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
                Iterable $this$filter$iv = descriptors.keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)libNamePrefix, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List sufficientNames = (List)destination$iv$iv;
                $this$filter$iv = sufficientNames;
                Collection destination$iv = this._completions;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    String string3 = (String)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(Companion.variant((String)it, "library"));
                }
            } else {
                CharSequence charSequence;
                Collection collection;
                void destination$iv;
                void $this$mapTo$iv;
                Object object;
                int argIndex;
                int n;
                Object it;
                List callArgs;
                block24: {
                    int n2;
                    callArgs = SequencesKt.toList((Sequence)org.jetbrains.kotlinx.jupyter.libraries.UtilKt.parseLibraryArguments((String)Intrinsics.stringPlus((String)librarySubstring, (Object)")"), (Brackets)Brackets.Companion.getROUND(), (int)(firstBracketIndex + 1)));
                    if (callArgs.isEmpty()) {
                        return;
                    }
                    List $this$indexOfFirst$iv = callArgs;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        it = (ArgParseResult)item$iv;
                        n = 0;
                        if (cursor < it.getEnd()) {
                            n2 = index$iv;
                            break block24;
                        }
                        ++index$iv;
                    }
                    n2 = argIndex = -1;
                }
                if (argIndex == -1) {
                    return;
                }
                int argCallStart = argIndex == 0 ? firstBracketIndex + 1 : ((ArgParseResult)callArgs.get(argIndex - 1)).getEnd();
                String destination$iv$iv = librarySubstring.substring(argCallStart, cursor);
                Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Object argCall = destination$iv$iv;
                String argName = ((ArgParseResult)callArgs.get(argIndex)).getVariable().getName();
                if (((CharSequence)argName).length() > 0) {
                    if (!StringsKt.contains$default((CharSequence)((CharSequence)argCall), (char)'=', (boolean)false, (int)2, null)) {
                        return;
                    }
                    object = ((Object)StringsKt.trimStart((CharSequence)StringsKt.substringAfter$default((String)argCall, (char)'=', null, (int)2, null))).toString();
                } else {
                    object = argCall;
                }
                Object argValuePrefix = object;
                it = librarySubstring;
                n = 0;
                Object it2 = ((String)it).substring(n, firstBracketIndex);
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String libName = ((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString();
                LibraryDescriptor libraryDescriptor = (LibraryDescriptor)descriptors.get(libName);
                if (libraryDescriptor == null) {
                    return;
                }
                LibraryDescriptor descriptor = libraryDescriptor;
                it2 = descriptor.getVariables();
                Collection bl = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it3;
                    Variable variable = (Variable)item$iv;
                    collection = destination$iv;
                    boolean bl2 = false;
                    collection.add(it3.getName());
                }
                Set paramNames = (Set)destination$iv;
                if (paramNames.isEmpty()) {
                    return;
                }
                CharSequence charSequence2 = argName;
                if (charSequence2.length() == 0) {
                    boolean bl3 = false;
                    charSequence = (String)CollectionsKt.singleOrNull((Iterable)paramNames);
                    if (charSequence == null) {
                        return;
                    }
                } else {
                    charSequence = charSequence2;
                }
                String paramName = (String)charSequence;
                for (String dependencyStr : descriptor.getDependencies()) {
                    void $this$mapTo$iv2;
                    void $this$filterTo$iv$iv;
                    List list;
                    Object object2;
                    Object repo2;
                    Object item$iv$iv2;
                    block25: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        MatchResult match;
                        if (MAVEN_DEP_REGEX.matchEntire((CharSequence)dependencyStr) == null) continue;
                        MatchGroup matchGroup = match.getGroups().get(1);
                        Intrinsics.checkNotNull((Object)matchGroup);
                        String group = matchGroup.getValue();
                        MatchGroup matchGroup2 = match.getGroups().get(2);
                        Intrinsics.checkNotNull((Object)matchGroup2);
                        String artifact = matchGroup2.getValue();
                        MatchGroup matchGroup3 = match.getGroups().get(3);
                        Intrinsics.checkNotNull((Object)matchGroup3);
                        String versionTemplate = matchGroup3.getValue();
                        if (!StringsKt.startsWith$default((String)versionTemplate, (String)"$", (boolean)false, (int)2, null)) continue;
                        String string = versionTemplate;
                        int n3 = 1;
                        String string4 = string.substring(n3);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                        String dependencyParamName = string4;
                        if (!Intrinsics.areEqual((Object)dependencyParamName, (Object)paramName)) continue;
                        Iterable iterable = ConfigKt.getDefaultRepositories();
                        collection = descriptor.getRepositories();
                        boolean $i$f$map = false;
                        void var25_52 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                            void it4;
                            RepositoryCoordinates repositoryCoordinates = (RepositoryCoordinates)item$iv$iv2;
                            Collection collection2 = destination$iv$iv2;
                            boolean bl4 = false;
                            collection2.add(it4.getString());
                        }
                        for (Object repo2 : (Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2))) {
                            boolean bl5 = false;
                            repo2 = (List)getVersions.invoke((Object)new Companion.ArtifactLocation((String)repo2, group, artifact));
                            if (repo2 == null) continue;
                            object2 = repo2;
                            break block25;
                        }
                        object2 = list = null;
                    }
                    if (object2 == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List versions = list;
                    Iterable $this$filter$iv = versions;
                    boolean $i$f$filter = false;
                    repo2 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    item$iv$iv2 = $this$filterTo$iv$iv.iterator();
                    while (item$iv$iv2.hasNext()) {
                        Object element$iv$iv = item$iv$iv2.next();
                        String it5 = (String)element$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it5, (String)"it");
                        if (!StringsKt.startsWith$default((String)it5, (String)argValuePrefix, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List matchingVersions = CollectionsKt.reversed((Iterable)((List)destination$iv$iv3));
                    $this$filter$iv = matchingVersions;
                    Collection destination$iv2 = this._completions;
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv : $this$mapTo$iv2) {
                        void it6;
                        item$iv$iv2 = (String)item$iv;
                        collection = destination$iv2;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it6, (String)"it");
                        collection.add(Companion.variant((String)it6, "version"));
                    }
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReplLineMagic.values().length];
                nArray[ReplLineMagic.USE.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\b*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Companion;", "", "()V", "MAVEN_DEP_REGEX", "Lkotlin/text/Regex;", "getVersions", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Companion$ArtifactLocation;", "", "", "kotlin.jvm.PlatformType", "loadXML", "Lorg/w3c/dom/Document;", "xml", "metadataUrl", "artifactLocation", "variant", "Lkotlin/script/experimental/api/SourceCodeCompletionVariant;", "text", "icon", "singleOrNull", "Lorg/w3c/dom/Node;", "Lorg/w3c/dom/NodeList;", "toList", "ArtifactLocation", "kotlin-jupyter-kernel"})
    public static final class Companion {
        private Companion() {
        }

        private final SourceCodeCompletionVariant variant(String text, String icon) {
            return new SourceCodeCompletionVariant(text, text, icon, icon, null, 16, null);
        }

        private final String metadataUrl(ArtifactLocation artifactLocation) {
            String $this$metadataUrl_u24lambda_u2d0 = artifactLocation.getRepository();
            boolean bl = false;
            String repo = StringsKt.endsWith$default((CharSequence)$this$metadataUrl_u24lambda_u2d0, (char)'/', (boolean)false, (int)2, null) ? $this$metadataUrl_u24lambda_u2d0 : Intrinsics.stringPlus((String)$this$metadataUrl_u24lambda_u2d0, (Object)"/");
            return repo + StringsKt.replace$default((String)artifactLocation.getGroup(), (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + artifactLocation.getArtifact() + "/maven-metadata.xml";
        }

        private final Document loadXML(String xml) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance()");
            DocumentBuilderFactory factory = documentBuilderFactory;
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"factory.newDocumentBuilder()");
            DocumentBuilder builder = documentBuilder;
            InputSource inputSource = new InputSource(new StringReader(xml));
            Document document = builder.parse(inputSource);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"builder.parse(inputSource)");
            return document;
        }

        private final List<Node> toList(NodeList $this$toList) {
            return (List)new AbstractList<Node>($this$toList){
                final /* synthetic */ NodeList $this_toList;
                {
                    this.$this_toList = $receiver;
                }

                public int getSize() {
                    return this.$this_toList.getLength();
                }

                public Node get(int index) {
                    return this.$this_toList.item(index);
                }
            };
        }

        private final Node singleOrNull(NodeList $this$singleOrNull) {
            return (Node)CollectionsKt.singleOrNull(this.toList($this$singleOrNull));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ String access$metadataUrl(Companion $this, ArtifactLocation artifactLocation) {
            return $this.metadataUrl(artifactLocation);
        }

        public static final /* synthetic */ Document access$loadXML(Companion $this, String xml) {
            return $this.loadXML(xml);
        }

        public static final /* synthetic */ Node access$singleOrNull(Companion $this, NodeList $receiver) {
            return $this.singleOrNull($receiver);
        }

        public static final /* synthetic */ List access$toList(Companion $this, NodeList $receiver) {
            return $this.toList($receiver);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Companion$ArtifactLocation;", "", "repository", "", "group", "artifact", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getGroup", "getRepository", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-jupyter-kernel"})
        private static final class ArtifactLocation {
            @NotNull
            private final String repository;
            @NotNull
            private final String group;
            @NotNull
            private final String artifact;

            public ArtifactLocation(@NotNull String repository, @NotNull String group, @NotNull String artifact) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
                this.repository = repository;
                this.group = group;
                this.artifact = artifact;
            }

            @NotNull
            public final String getRepository() {
                return this.repository;
            }

            @NotNull
            public final String getGroup() {
                return this.group;
            }

            @NotNull
            public final String getArtifact() {
                return this.artifact;
            }

            @NotNull
            public final String component1() {
                return this.repository;
            }

            @NotNull
            public final String component2() {
                return this.group;
            }

            @NotNull
            public final String component3() {
                return this.artifact;
            }

            @NotNull
            public final ArtifactLocation copy(@NotNull String repository, @NotNull String group, @NotNull String artifact) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
                return new ArtifactLocation(repository, group, artifact);
            }

            public static /* synthetic */ ArtifactLocation copy$default(ArtifactLocation artifactLocation, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = artifactLocation.repository;
                }
                if ((n & 2) != 0) {
                    string2 = artifactLocation.group;
                }
                if ((n & 4) != 0) {
                    string3 = artifactLocation.artifact;
                }
                return artifactLocation.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "ArtifactLocation(repository=" + this.repository + ", group=" + this.group + ", artifact=" + this.artifact + ')';
            }

            public int hashCode() {
                int result2 = this.repository.hashCode();
                result2 = result2 * 31 + this.group.hashCode();
                result2 = result2 * 31 + this.artifact.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ArtifactLocation)) {
                    return false;
                }
                ArtifactLocation artifactLocation = (ArtifactLocation)other;
                if (!Intrinsics.areEqual((Object)this.repository, (Object)artifactLocation.repository)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.group, (Object)artifactLocation.group)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.artifact, (Object)artifactLocation.artifact);
            }
        }
    }
}

