/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.JupyterConnection;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteErrorReply;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.Response;
import org.jetbrains.kotlinx.jupyter.messaging.ResponseState;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/ErrorResponseWithMessage;", "Lorg/jetbrains/kotlinx/jupyter/messaging/Response;", "stdErr", "", "errorName", "errorValue", "traceback", "", "additionalInfo", "Lkotlinx/serialization/json/JsonObject;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlinx/serialization/json/JsonObject;)V", "state", "Lorg/jetbrains/kotlinx/jupyter/messaging/ResponseState;", "getState", "()Lorg/jetbrains/kotlinx/jupyter/messaging/ResponseState;", "sendBody", "", "socket", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;", "requestCount", "", "requestMsg", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "startedTime", "kotlin-jupyter-kernel"})
public final class ErrorResponseWithMessage
extends Response {
    @NotNull
    private final String errorName;
    @NotNull
    private String errorValue;
    @NotNull
    private final List<String> traceback;
    @NotNull
    private final JsonObject additionalInfo;
    @NotNull
    private final ResponseState state;

    public ErrorResponseWithMessage(@Nullable String stdErr, @NotNull String errorName, @NotNull String errorValue, @NotNull List<String> traceback, @NotNull JsonObject additionalInfo) {
        Intrinsics.checkNotNullParameter((Object)errorName, (String)"errorName");
        Intrinsics.checkNotNullParameter((Object)errorValue, (String)"errorValue");
        Intrinsics.checkNotNullParameter(traceback, (String)"traceback");
        Intrinsics.checkNotNullParameter((Object)additionalInfo, (String)"additionalInfo");
        super(null, stdErr);
        this.errorName = errorName;
        this.errorValue = errorValue;
        this.traceback = traceback;
        this.additionalInfo = additionalInfo;
        this.state = ResponseState.Error;
    }

    public /* synthetic */ ErrorResponseWithMessage(String string, String string2, String string3, List list, JsonObject jsonObject, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = "Unknown error";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            jsonObject = MessageKt.getEmptyJsonObject();
        }
        this(string, string2, string3, list, jsonObject);
    }

    @Override
    @NotNull
    public ResponseState getState() {
        return this.state;
    }

    @Override
    protected void sendBody(@NotNull JupyterConnection.Socket socket, long requestCount, @NotNull Message requestMsg, @NotNull String startedTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)socket), (String)"socket");
        Intrinsics.checkNotNullParameter((Object)requestMsg, (String)"requestMsg");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        Message errorReply = MessageKt.makeReplyMessage$default(requestMsg, MessageType.EXECUTE_REPLY, null, null, null, null, (MessageContent)new ExecuteErrorReply(requestCount, this.errorName, this.errorValue, this.traceback, this.additionalInfo), 60, null);
        System.err.println(Intrinsics.stringPlus((String)"Sending error: ", (Object)errorReply));
        socket.send(errorReply);
    }

    public ErrorResponseWithMessage() {
        this(null, null, null, null, null, 31, null);
    }
}

