/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import ch.qos.logback.classic.Level;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.CheckResult;
import org.jetbrains.kotlinx.jupyter.CodeCellImpl;
import org.jetbrains.kotlinx.jupyter.CommandsKt;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.DisabledStdinInputStream;
import org.jetbrains.kotlinx.jupyter.EvalRequestData;
import org.jetbrains.kotlinx.jupyter.JupyterConnection;
import org.jetbrains.kotlinx.jupyter.JupyterSockets;
import org.jetbrains.kotlinx.jupyter.LoggingManagement;
import org.jetbrains.kotlinx.jupyter.OutputConfig;
import org.jetbrains.kotlinx.jupyter.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.Renderable;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.config.KernelStreams;
import org.jetbrains.kotlinx.jupyter.config.NotebookMetadataKt;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplCompilerException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplEvalRuntimeException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.messaging.AbortResponseWithMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CapturingOutputStream;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.CompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectReply;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorResponseWithMessage;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionInputReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryRequest;
import org.jetbrains.kotlinx.jupyter.messaging.InterruptRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteReply;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.KernelStatus;
import org.jetbrains.kotlinx.jupyter.messaging.ListErrorsRequest;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHeader;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.Response;
import org.jetbrains.kotlinx.jupyter.messaging.ShutdownRequest;
import org.jetbrains.kotlinx.jupyter.messaging.SocketDisplayHandler;
import org.jetbrains.kotlinx.jupyter.repl.CompletionResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalResultsKt;
import org.jetbrains.kotlinx.jupyter.repl.ListErrorsResult;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00060\u0002R\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a*\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u001a&\u0010\u000e\u001a\u00020\u0001*\u00060\u0002R\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"controlMessagesHandler", "", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;", "msg", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "repl", "Lorg/jetbrains/kotlinx/jupyter/ReplForJupyter;", "evalWithIO", "Lorg/jetbrains/kotlinx/jupyter/messaging/Response;", "srcMessage", "body", "Lkotlin/Function0;", "Lorg/jetbrains/kotlinx/jupyter/repl/EvalResult;", "shellMessagesHandler", "executionCount", "Ljava/util/concurrent/atomic/AtomicLong;", "toDisplayResult", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "kotlin-jupyter-kernel"})
public final class ProtocolKt {
    public static final void controlMessagesHandler(@NotNull JupyterConnection.Socket $this$controlMessagesHandler, @NotNull Message msg, @Nullable ReplForJupyter repl) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$controlMessagesHandler), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        MessageContent messageContent = msg.getContent();
        if (messageContent instanceof InterruptRequest) {
            $this$controlMessagesHandler.getConnection().interruptExecution();
            $this$controlMessagesHandler.send(MessageKt.makeReplyMessage$default(msg, MessageType.INTERRUPT_REPLY, null, null, null, null, msg.getContent(), 60, null));
        } else if (messageContent instanceof ShutdownRequest) {
            ReplForJupyter replForJupyter = repl;
            if (replForJupyter != null) {
                replForJupyter.evalOnShutdown();
            }
            $this$controlMessagesHandler.send(MessageKt.makeReplyMessage$default(msg, MessageType.SHUTDOWN_REPLY, null, null, null, null, msg.getContent(), 60, null));
            ReplForJupyter replForJupyter2 = repl;
            if (replForJupyter2 == null ? false : replForJupyter2.isEmbedded()) {
                ConfigKt.getLog().info("Interrupting controlThread to trigger kernel shutdown");
                throw new InterruptedException();
            }
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void shellMessagesHandler(@NotNull JupyterConnection.Socket $this$shellMessagesHandler, @NotNull Message msg, @NotNull ReplForJupyter repl, @NotNull AtomicLong executionCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$shellMessagesHandler), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        Intrinsics.checkNotNullParameter((Object)executionCount, (String)"executionCount");
        MessageContent content = msg.getContent();
        if (content instanceof KernelInfoRequest) {
            $this$shellMessagesHandler.sendWrapped(msg, MessageKt.makeReplyMessage$default(msg, MessageType.KERNEL_INFO_REPLY, null, null, null, null, (MessageContent)new KernelInfoReply("5.3", "Kotlin", KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()), "Kotlin kernel v. " + KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()) + ", Kotlin v. " + RuntimePropertiesKt.getCurrentKotlinVersion(), NotebookMetadataKt.getNotebookLanguageInfo(), CollectionsKt.emptyList()), 60, null));
        } else if (content instanceof HistoryRequest) {
            $this$shellMessagesHandler.sendWrapped(msg, MessageKt.makeReplyMessage$default(msg, MessageType.HISTORY_REPLY, null, null, null, null, new HistoryReply(CollectionsKt.emptyList()), 60, null));
        } else if (content instanceof ConnectRequest) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JupyterSockets[] jupyterSocketsArray = JupyterSockets.values();
            JsonElement jsonElement = null;
            MessageHeader messageHeader = null;
            MessageHeader messageHeader2 = null;
            String string = null;
            MessageType messageType = MessageType.CONNECT_REPLY;
            Message message2 = msg;
            Message message3 = msg;
            JupyterConnection.Socket socket = $this$shellMessagesHandler;
            boolean $i$f$map = false;
            void var7_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var14_31 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)Intrinsics.stringPlus((String)it.getNameForUser(), (Object)"_port"), (Object)$this$shellMessagesHandler.getConnection().getConfig().getPorts().get(it.ordinal())));
            }
            collection = (List)destination$iv$iv;
            JsonObject jsonObject = MessageKt.jsonObject((Iterable<? extends Pair<String, ? extends Object>>)collection);
            socket.sendWrapped(message3, MessageKt.makeReplyMessage$default(message2, messageType, string, messageHeader2, messageHeader, jsonElement, new ConnectReply(jsonObject), 60, null));
        } else if (content instanceof ExecuteRequest) {
            $this$shellMessagesHandler.getConnection().setContextMessage(msg);
            long count2 = executionCount.getAndUpdate(new LongUnaryOperator(content){
                final /* synthetic */ MessageContent $content;
                {
                    this.$content = $content;
                }

                public final long applyAsLong(long it) {
                    return ((ExecuteRequest)this.$content).getStoreHistory() ? it + 1L : it;
                }
            });
            String startedTime = MessageKt.getISO8601DateNow();
            SocketDisplayHandler displayHandler = new SocketDisplayHandler($this$shellMessagesHandler.getConnection().getIopub(), repl.getNotebook(), msg);
            $this$shellMessagesHandler.getConnection().getIopub().sendStatus(KernelStatus.BUSY, msg);
            String code = ((ExecuteRequest)content).getCode();
            $this$shellMessagesHandler.getConnection().getIopub().send(MessageKt.makeReplyMessage$default(msg, MessageType.EXECUTE_INPUT, null, null, null, null, new ExecutionInputReply(code, count2), 60, null));
            Response res2 = CommandsUtilKt.looksLikeReplCommand((String)code) ? CommandsKt.runCommand(code, repl) : ProtocolKt.evalWithIO($this$shellMessagesHandler.getConnection(), repl, msg, (Function0<EvalResult>)((Function0)new Function0<EvalResult>(repl, code, displayHandler, count2, content){
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ String $code;
                final /* synthetic */ SocketDisplayHandler $displayHandler;
                final /* synthetic */ long $count;
                final /* synthetic */ MessageContent $content;
                {
                    this.$repl = $repl;
                    this.$code = $code;
                    this.$displayHandler = $displayHandler;
                    this.$count = $count;
                    this.$content = $content;
                    super(0);
                }

                @Nullable
                public final EvalResult invoke() {
                    return this.$repl.eval(new EvalRequestData(this.$code, this.$displayHandler, (int)this.$count, ((ExecuteRequest)this.$content).getStoreHistory(), ((ExecuteRequest)this.$content).getSilent()));
                }
            }));
            res2.send($this$shellMessagesHandler, count2, msg, startedTime);
            $this$shellMessagesHandler.getConnection().getIopub().sendStatus(KernelStatus.IDLE, msg);
            $this$shellMessagesHandler.getConnection().setContextMessage(null);
        } else if (content instanceof CommInfoRequest) {
            $this$shellMessagesHandler.sendWrapped(msg, MessageKt.makeReplyMessage$default(msg, MessageType.COMM_INFO_REPLY, null, null, null, null, new CommInfoReply(MapsKt.emptyMap()), 60, null));
        } else if (content instanceof CompleteRequest) {
            $this$shellMessagesHandler.getConnection().launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repl, content, $this$shellMessagesHandler, msg, null){
                int label;
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ MessageContent $content;
                final /* synthetic */ JupyterConnection.Socket $this_shellMessagesHandler;
                final /* synthetic */ Message $msg;
                {
                    this.$repl = $repl;
                    this.$content = $content;
                    this.$this_shellMessagesHandler = $receiver;
                    this.$msg = $msg;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$repl.complete(((CompleteRequest)this.$content).getCode(), ((CompleteRequest)this.$content).getCursorPos(), (Function1<? super CompletionResult, Unit>)((Function1)new Function1<CompletionResult, Unit>(this.$this_shellMessagesHandler, this.$msg){
                                final /* synthetic */ JupyterConnection.Socket $this_shellMessagesHandler;
                                final /* synthetic */ Message $msg;
                                {
                                    this.$this_shellMessagesHandler = $receiver;
                                    this.$msg = $msg;
                                    super(1);
                                }

                                public final void invoke(@NotNull CompletionResult result2) {
                                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                                    this.$this_shellMessagesHandler.sendWrapped(this.$msg, MessageKt.makeReplyMessage$default(this.$msg, MessageType.COMPLETE_REPLY, null, null, null, null, result2.getMessage(), 60, null));
                                }
                            }), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else if (content instanceof ListErrorsRequest) {
            $this$shellMessagesHandler.getConnection().launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repl, content, $this$shellMessagesHandler, msg, null){
                int label;
                final /* synthetic */ ReplForJupyter $repl;
                final /* synthetic */ MessageContent $content;
                final /* synthetic */ JupyterConnection.Socket $this_shellMessagesHandler;
                final /* synthetic */ Message $msg;
                {
                    this.$repl = $repl;
                    this.$content = $content;
                    this.$this_shellMessagesHandler = $receiver;
                    this.$msg = $msg;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$repl.listErrors(((ListErrorsRequest)this.$content).getCode(), (Function1<? super ListErrorsResult, Unit>)((Function1)new Function1<ListErrorsResult, Unit>(this.$this_shellMessagesHandler, this.$msg){
                                final /* synthetic */ JupyterConnection.Socket $this_shellMessagesHandler;
                                final /* synthetic */ Message $msg;
                                {
                                    this.$this_shellMessagesHandler = $receiver;
                                    this.$msg = $msg;
                                    super(1);
                                }

                                public final void invoke(@NotNull ListErrorsResult result2) {
                                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                                    this.$this_shellMessagesHandler.sendWrapped(this.$msg, MessageKt.makeReplyMessage$default(this.$msg, MessageType.LIST_ERRORS_REPLY, null, null, null, null, result2.getMessage(), 60, null));
                                }
                            }), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else if (content instanceof IsCompleteRequest) {
            String string;
            if (!Intrinsics.areEqual((Object)LoggingManagement.INSTANCE.mainLoggerLevel(), (Object)Level.OFF)) {
                LoggingManagement.INSTANCE.disableLogging();
            }
            if (CommandsUtilKt.looksLikeReplCommand((String)((IsCompleteRequest)content).getCode())) {
                string = "complete";
            } else {
                String result2;
                String string2;
                try {
                    CheckResult check = repl.checkComplete(((IsCompleteRequest)content).getCode());
                    string2 = check.isComplete() ? "complete" : "incomplete";
                }
                catch (ReplCompilerException ex) {
                    string2 = "invalid";
                }
                string = result2 = string2;
            }
            String resStr = string;
            $this$shellMessagesHandler.send(MessageKt.makeReplyMessage$default(msg, MessageType.IS_COMPLETE_REPLY, null, null, null, null, new IsCompleteReply(resStr, null, 2, null), 60, null));
        } else {
            $this$shellMessagesHandler.send(MessageKt.makeReplyMessage$default(msg, MessageType.NONE, null, null, null, null, null, 124, null));
        }
    }

    @Nullable
    public static final DisplayResult toDisplayResult(@Nullable Object $this$toDisplayResult, @NotNull Notebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Object object = $this$toDisplayResult;
        return object == null ? (DisplayResult)ResultsKt.textResult((String)"null") : (object instanceof DisplayResult ? (DisplayResult)$this$toDisplayResult : (object instanceof Renderable ? ((Renderable)$this$toDisplayResult).render(notebook) : (object instanceof Unit ? null : (DisplayResult)ResultsKt.textResult((String)$this$toDisplayResult.toString()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Response evalWithIO(@NotNull JupyterConnection $this$evalWithIO, @NotNull ReplForJupyter repl, @NotNull Message srcMessage, @NotNull Function0<EvalResult> body) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$evalWithIO, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        Intrinsics.checkNotNullParameter((Object)srcMessage, (String)"srcMessage");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        OutputConfig config = repl.getOutputConfig();
        PrintStream out = System.out;
        PrintStream err = System.err;
        repl.getNotebook().beginEvalSession();
        Function0 cell2 = (Function0)new Function0<CodeCellImpl>(repl){
            final /* synthetic */ ReplForJupyter $repl;
            {
                this.$repl = $repl;
                super(0);
            }

            @Nullable
            public final CodeCellImpl invoke() {
                return this.$repl.getNotebook().getCurrentCell();
            }
        };
        CapturingOutputStream forkedOut = ProtocolKt.evalWithIO$getCapturingStream(config, (Function0<CodeCellImpl>)cell2, $this$evalWithIO, srcMessage, out, JupyterOutType.STDOUT, config.getCaptureOutput());
        CapturingOutputStream forkedError = ProtocolKt.evalWithIO$getCapturingStream(config, (Function0<CodeCellImpl>)cell2, $this$evalWithIO, srcMessage, err, JupyterOutType.STDERR, false);
        CapturingOutputStream userError = ProtocolKt.evalWithIO$getCapturingStream(config, (Function0<CodeCellImpl>)cell2, $this$evalWithIO, srcMessage, null, JupyterOutType.STDERR, true);
        PrintStream printForkedOut = new PrintStream((OutputStream)forkedOut, false, "UTF-8");
        PrintStream printForkedErr = new PrintStream((OutputStream)forkedError, false, "UTF-8");
        PrintStream printUserError = new PrintStream((OutputStream)userError, false, "UTF-8");
        KernelStreams.INSTANCE.setStreams(true, printForkedOut, printUserError);
        System.setOut(printForkedOut);
        System.setErr(printForkedErr);
        InputStream in = System.in;
        MessageContent messageContent = srcMessage.getContent();
        ExecuteRequest executeRequest = messageContent instanceof ExecuteRequest ? (ExecuteRequest)messageContent : null;
        boolean allowStdIn = executeRequest == null ? true : (bl = executeRequest.getAllowStdin());
        System.setIn(allowStdIn ? (InputStream)$this$evalWithIO.getStdinIn() : (InputStream)DisabledStdinInputStream.INSTANCE);
        try {
            Object object;
            try {
                Response response;
                object = $this$evalWithIO.runExecution(body, repl.getCurrentClassLoader());
                EvalResult exec = ((JupyterConnection.ConnectionExecutionResult)object).component1();
                Throwable execException = ((JupyterConnection.ConnectionExecutionResult)object).component2();
                boolean executionInterrupted = ((JupyterConnection.ConnectionExecutionResult)object).component3();
                if (executionInterrupted) {
                    ProtocolKt.evalWithIO$flushStreams(forkedOut, forkedError, userError);
                    response = new AbortResponseWithMessage("The execution was interrupted");
                } else {
                    if (execException != null) {
                        throw execException;
                    }
                    if (exec == null) {
                        response = new AbortResponseWithMessage("NO REPL!");
                    } else {
                        Response response2;
                        ProtocolKt.evalWithIO$flushStreams(forkedOut, forkedError, userError);
                        try {
                            response2 = EvalResultsKt.toResponse(exec, repl.getNotebook());
                        }
                        catch (Exception e) {
                            response2 = new AbortResponseWithMessage(Intrinsics.stringPlus((String)"error:  Unable to convert result to a string: ", (Object)e));
                        }
                        response = response2;
                    }
                }
                object = response;
            }
            catch (ReplException ex) {
                Response response;
                Object e;
                Response response3;
                Object[] executionInterrupted;
                ProtocolKt.evalWithIO$flushStreams(forkedOut, forkedError, userError);
                Object[] objectArray = executionInterrupted = ex instanceof ReplEvalRuntimeException ? (Object[])ex : null;
                if (executionInterrupted == null) {
                    response3 = null;
                } else {
                    Throwable throwable = executionInterrupted.getCause();
                    if (throwable == null) {
                        response3 = null;
                    } else {
                        Throwable originalThrowable = throwable;
                        boolean bl2 = false;
                        e = repl.getThrowableRenderersProcessor().renderThrowable(originalThrowable);
                        if (e == null) {
                            response3 = null;
                        } else {
                            Object renderedThrowable = e;
                            boolean bl3 = false;
                            response3 = EvalResultsKt.rawToResponse$default(renderedThrowable, repl.getNotebook(), null, 4, null);
                        }
                    }
                }
                Response response4 = response3;
                if (response4 == null) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    String string = ex.render();
                    executionInterrupted = ((Object)((Object)ex)).getClass().getCanonicalName();
                    Intrinsics.checkNotNullExpressionValue((Object)executionInterrupted, (String)"ex.javaClass.canonicalName");
                    Object object2 = executionInterrupted;
                    String string2 = ex.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    executionInterrupted = ex.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)executionInterrupted, (String)"ex.stackTrace");
                    executionInterrupted = executionInterrupted;
                    String string3 = string2;
                    Object object3 = object2;
                    String string4 = string;
                    boolean $i$f$map = false;
                    e = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        String string5 = it.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.toString()");
                        collection.add(string5);
                    }
                    collection = (List)destination$iv$iv;
                    JsonObject jsonObject = ex.getAdditionalInfoJson();
                    if (jsonObject == null) {
                        jsonObject = MessageKt.getEmptyJsonObject();
                    }
                    JsonObject jsonObject2 = jsonObject;
                    List list = collection;
                    String string6 = string3;
                    Object object4 = object3;
                    String string7 = string4;
                    response = new ErrorResponseWithMessage(string7, (String)object4, string6, list, jsonObject2);
                } else {
                    response = response4;
                }
                object = response;
            }
            return object;
        }
        finally {
            ProtocolKt.evalWithIO$flushStreams(forkedOut, forkedError, userError);
            System.setIn(in);
            System.setErr(err);
            System.setOut(out);
            Intrinsics.checkNotNullExpressionValue((Object)out, (String)"out");
            Intrinsics.checkNotNullExpressionValue((Object)err, (String)"err");
            KernelStreams.INSTANCE.setStreams(false, out, err);
        }
    }

    private static final CapturingOutputStream evalWithIO$getCapturingStream(OutputConfig config, Function0<CodeCellImpl> cell2, JupyterConnection $this_evalWithIO, Message $srcMessage, PrintStream stream, JupyterOutType outType, boolean captureOutput) {
        return new CapturingOutputStream(stream, config, captureOutput, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(cell2, $this_evalWithIO, $srcMessage, outType){
            final /* synthetic */ Function0<CodeCellImpl> $cell;
            final /* synthetic */ JupyterConnection $this_evalWithIO;
            final /* synthetic */ Message $srcMessage;
            final /* synthetic */ JupyterOutType $outType;
            {
                this.$cell = $cell;
                this.$this_evalWithIO = $receiver;
                this.$srcMessage = $srcMessage;
                this.$outType = $outType;
                super(1);
            }

            public final void invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                CodeCellImpl codeCellImpl = (CodeCellImpl)this.$cell.invoke();
                if (codeCellImpl != null) {
                    codeCellImpl.appendStreamOutput(text);
                }
                this.$this_evalWithIO.getIopub().sendOut(this.$srcMessage, this.$outType, text);
            }
        }));
    }

    private static final void evalWithIO$flushStreams(CapturingOutputStream forkedOut, CapturingOutputStream forkedError, CapturingOutputStream userError) {
        forkedOut.flush();
        forkedError.flush();
        userError.flush();
    }
}

