/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.CodeCellImpl;
import org.jetbrains.kotlinx.jupyter.DisplayContainerImpl;
import org.jetbrains.kotlinx.jupyter.JupyterConnection;
import org.jetbrains.kotlinx.jupyter.NotebookImpl;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.ExecutionHost;
import org.jetbrains.kotlinx.jupyter.messaging.DisplayDataResponse;
import org.jetbrains.kotlinx.jupyter.messaging.DisplayHandler;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.ProtocolKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler;", "Lorg/jetbrains/kotlinx/jupyter/messaging/DisplayHandler;", "socket", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;", "Lorg/jetbrains/kotlinx/jupyter/JupyterConnection;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;", "message", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "(Lorg/jetbrains/kotlinx/jupyter/JupyterConnection$Socket;Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;Lorg/jetbrains/kotlinx/jupyter/messaging/Message;)V", "handleDisplay", "", "value", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ExecutionHost;", "handleUpdate", "id", "", "render", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "kotlin-jupyter-kernel"})
public final class SocketDisplayHandler
implements DisplayHandler {
    @NotNull
    private final JupyterConnection.Socket socket;
    @NotNull
    private final NotebookImpl notebook;
    @NotNull
    private final Message message;

    public SocketDisplayHandler(@NotNull JupyterConnection.Socket socket, @NotNull NotebookImpl notebook, @NotNull Message message2) {
        Intrinsics.checkNotNullParameter((Object)((Object)socket), (String)"socket");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.socket = socket;
        this.notebook = notebook;
        this.message = message2;
    }

    private final DisplayResult render(ExecutionHost host, Object value) {
        Object renderedValue = this.notebook.getRenderersProcessor().renderValue(host, value);
        return ProtocolKt.toDisplayResult(renderedValue, this.notebook);
    }

    @Override
    public void handleDisplay(@NotNull Object value, @NotNull ExecutionHost host) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        DisplayResult displayResult = this.render(host, value);
        if (displayResult == null) {
            return;
        }
        DisplayResult display = displayResult;
        JsonObject json = DisplayResult.DefaultImpls.toJson$default((DisplayResult)display, null, (int)1, null);
        CodeCellImpl codeCellImpl = this.notebook.getCurrentCell();
        if (codeCellImpl != null) {
            codeCellImpl.addDisplay(display);
        }
        this.socket.send(MessageKt.makeReplyMessage$default(this.message, MessageType.DISPLAY_DATA, null, null, null, null, new DisplayDataResponse((JsonElement)json.get((Object)"data"), (JsonElement)json.get((Object)"metadata"), (JsonElement)json.get((Object)"transient")), 60, null));
    }

    @Override
    public void handleUpdate(@NotNull Object value, @NotNull ExecutionHost host, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        DisplayResult displayResult = this.render(host, value);
        if (displayResult == null) {
            return;
        }
        DisplayResult display = displayResult;
        Map json = MapsKt.toMutableMap((Map)((Map)DisplayResult.DefaultImpls.toJson$default((DisplayResult)display, null, (int)1, null)));
        CodeCellImpl codeCellImpl = this.notebook.getCurrentCell();
        if (codeCellImpl != null) {
            DisplayContainerImpl displayContainerImpl = codeCellImpl.getDisplays();
            if (displayContainerImpl != null) {
                displayContainerImpl.update(id, display);
            }
        }
        if (ResultsKt.setDisplayId$default((Map)json, (String)id, (boolean)false, (int)2, null) == null) {
            throw new RuntimeException("`update_display_data` response should provide an id of data being updated");
        }
        this.socket.send(MessageKt.makeReplyMessage$default(this.message, MessageType.UPDATE_DISPLAY_DATA, null, null, null, null, new DisplayDataResponse((JsonElement)json.get("data"), (JsonElement)json.get("metadata"), (JsonElement)json.get("transient")), 60, null));
    }
}

