/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.repl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jupyter.kotlin.KotlinContext;
import jupyter.kotlin.KotlinFunctionInfo;
import jupyter.kotlin.KotlinVariableInfo;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.script.experimental.jvm.BasicJvmReplEvaluator;
import kotlin.script.experimental.jvm.KJvmEvaluatedSnippet;
import kotlin.script.experimental.util.LinkedSnippet;
import kotlin.script.experimental.util.LinkedSnippetImpl;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/ContextUpdater;", "", "context", "Ljupyter/kotlin/KotlinContext;", "evaluator", "Lkotlin/script/experimental/jvm/BasicJvmReplEvaluator;", "(Ljupyter/kotlin/KotlinContext;Lkotlin/script/experimental/jvm/BasicJvmReplEvaluator;)V", "getContext", "()Ljupyter/kotlin/KotlinContext;", "lastProcessedSnippet", "Lkotlin/script/experimental/util/LinkedSnippet;", "Lkotlin/script/experimental/jvm/KJvmEvaluatedSnippet;", "findVariables", "", "fields", "", "Ljava/lang/reflect/Field;", "o", "([Ljava/lang/reflect/Field;Ljava/lang/Object;)V", "refreshMethods", "lines", "", "refreshVariables", "update", "Companion", "kotlin-jupyter-kernel"})
public final class ContextUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinContext context;
    @NotNull
    private final BasicJvmReplEvaluator evaluator;
    @Nullable
    private LinkedSnippet<KJvmEvaluatedSnippet> lastProcessedSnippet;
    private static final Logger logger = LoggerFactory.getLogger(ContextUpdater.class);
    @NotNull
    private static final HashSet<Method> objectMethods;

    public ContextUpdater(@NotNull KotlinContext context, @NotNull BasicJvmReplEvaluator evaluator2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)evaluator2, (String)"evaluator");
        this.context = context;
        this.evaluator = evaluator2;
    }

    @NotNull
    public final KotlinContext getContext() {
        return this.context;
    }

    public final void update() {
        try {
            List newSnippets = new ArrayList();
            for (LinkedSnippetImpl lastSnippet = this.evaluator.getLastEvaluatedSnippet(); !Intrinsics.areEqual((Object)lastSnippet, this.lastProcessedSnippet) && lastSnippet != null; lastSnippet = lastSnippet.getPrevious()) {
                Object line = ((KJvmEvaluatedSnippet)lastSnippet.get()).getResult().getScriptInstance();
                if (line == null) continue;
                newSnippets.add(line);
            }
            CollectionsKt.reverse((List)newSnippets);
            this.refreshVariables(newSnippets);
            this.refreshMethods(newSnippets);
            this.lastProcessedSnippet = (LinkedSnippet)this.evaluator.getLastEvaluatedSnippet();
        }
        catch (ReflectiveOperationException e) {
            logger.error("Exception updating current variables", (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error("Exception updating current variables", (Throwable)e);
        }
    }

    private final void refreshMethods(List<? extends Object> lines) {
        for (Object object : lines) {
            Method[] methods = object.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
            for (Method method : methods) {
                KFunction function;
                if (objectMethods.contains(method) || Intrinsics.areEqual((Object)method.getName(), (Object)"main")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                if (ReflectJvmMapping.getKotlinFunction((Method)method) == null) continue;
                ((Map)this.context.getFunctions()).put(function.getName(), new KotlinFunctionInfo(function, object));
            }
        }
    }

    private final void refreshVariables(List<? extends Object> lines) throws ReflectiveOperationException {
        for (Object object : lines) {
            Field[] fields = object.getClass().getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
            this.findVariables(fields, object);
        }
    }

    private final void findVariables(Field[] fields, Object o) throws IllegalAccessException {
        for (Field field : fields) {
            String fieldName = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
            if (StringsKt.contains$default((CharSequence)fieldName, (CharSequence)"$$implicitReceiver", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fieldName, (CharSequence)"script$", (boolean)false, (int)2, null)) continue;
            field.setAccessible(true);
            Object value = field.get(o);
            KProperty descriptor = ReflectJvmMapping.getKotlinProperty((Field)field);
            if (descriptor == null) continue;
            ((Map)this.context.getVars()).put(fieldName, new KotlinVariableInfo(value, descriptor, o));
        }
    }

    static {
        Method[] methodArray = Object.class.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"Any::class.java.methods");
        Method[] methodArray2 = methodArray;
        objectMethods = new HashSet(CollectionsKt.listOf((Object[])Arrays.copyOf(methodArray2, methodArray2.length)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/ContextUpdater$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMethods", "Ljava/util/HashSet;", "Ljava/lang/reflect/Method;", "kotlin-jupyter-kernel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

