/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.HomeDirLibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultLibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.DescriptorOptionsParsingKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;
import org.jetbrains.kotlinx.jupyter.libraries.ResourceLibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.util.MemoizationKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/jupyter/HomeDirLibraryDescriptorsProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResourceLibraryDescriptorsProvider;", "homeDir", "Ljava/io/File;", "libraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "(Ljava/io/File;Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;)V", "descriptorOptions", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "getDescriptorOptions", "()Lkotlin/jvm/functions/Function1;", "libraryDescriptors", "", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptor;", "getLibraryDescriptors", "getDescriptorGlobalOptions", "getDescriptors", "kotlin-jupyter-kernel"})
public final class HomeDirLibraryDescriptorsProvider
extends ResourceLibraryDescriptorsProvider {
    @Nullable
    private final File homeDir;
    @NotNull
    private final LibraryDescriptorsManager libraryDescriptorsManager;
    @NotNull
    private final Function1<File, LibraryDescriptorGlobalOptions> descriptorOptions;
    @NotNull
    private final Function1<File, Map<String, LibraryDescriptor>> libraryDescriptors;

    public HomeDirLibraryDescriptorsProvider(@Nullable File homeDir, @NotNull LibraryDescriptorsManager libraryDescriptorsManager) {
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorsManager, (String)"libraryDescriptorsManager");
        this.homeDir = homeDir;
        this.libraryDescriptorsManager = libraryDescriptorsManager;
        this.descriptorOptions = MemoizationKt.createCachedFun((Function1)descriptorOptions.1.INSTANCE, (Function1)((Function1)new Function1<File, LibraryDescriptorGlobalOptions>(this){
            final /* synthetic */ HomeDirLibraryDescriptorsProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LibraryDescriptorGlobalOptions invoke(@NotNull File homeDir) {
                Intrinsics.checkNotNullParameter((Object)homeDir, (String)"homeDir");
                File globalOptions = FilesKt.resolve((File)HomeDirLibraryDescriptorsProvider.access$getLibraryDescriptorsManager$p(this.this$0).homeLibrariesDir(homeDir), (String)HomeDirLibraryDescriptorsProvider.access$getLibraryDescriptorsManager$p(this.this$0).optionsFileName());
                return globalOptions.exists() ? DescriptorOptionsParsingKt.parseLibraryDescriptorGlobalOptions((String)FilesKt.readText$default((File)globalOptions, null, (int)1, null)) : (LibraryDescriptorGlobalOptions)DefaultLibraryDescriptorGlobalOptions.INSTANCE;
            }
        }));
        this.libraryDescriptors = MemoizationKt.createCachedFun((Function1)libraryDescriptors.1.INSTANCE, (Function1)((Function1)new Function1<File, Map<String, ? extends LibraryDescriptor>>(this){
            final /* synthetic */ HomeDirLibraryDescriptorsProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, LibraryDescriptor> invoke(@NotNull File homeDir) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)homeDir, (String)"homeDir");
                LibraryDescriptorsManager libraryDescriptorsManager = HomeDirLibraryDescriptorsProvider.access$getLibraryDescriptorsManager$p(this.this$0);
                Object[] $this$orEmpty$iv = HomeDirLibraryDescriptorsProvider.access$getLibraryDescriptorsManager$p(this.this$0).homeLibrariesDir(homeDir).listFiles(new FileFilter(libraryDescriptorsManager){
                    final /* synthetic */ LibraryDescriptorsManager $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    public final boolean accept(@NotNull File p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return this.$tmp0.isLibraryDescriptor(p0);
                    }
                });
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new File[]{};
                }
                Object[] libraryFiles2 = objectArray;
                Iterable $this$mapNotNull$iv = ArraysKt.toList((Object[])libraryFiles2);
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$emptyArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    File file = (File)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)file);
                    String libraryName = FilesKt.getNameWithoutExtension((File)file);
                    ConfigKt.getLog().info("Parsing descriptor for library '" + libraryName + '\'');
                    if ((Pair)LoggingKt.catchAll$default((Logger)ConfigKt.getLog(), null, (String)("Parsing descriptor for library '" + libraryName + "' failed"), (Function0)((Function0)new Function0<Pair<? extends String, ? extends LibraryDescriptor>>(libraryName, file){
                        final /* synthetic */ String $libraryName;
                        final /* synthetic */ File $file;
                        {
                            this.$libraryName = $libraryName;
                            this.$file = $file;
                            super(0);
                        }

                        @NotNull
                        public final Pair<String, LibraryDescriptor> invoke() {
                            File file = this.$file;
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"$file");
                            return TuplesKt.to((Object)this.$libraryName, (Object)ParsingKt.parseLibraryDescriptor((String)FilesKt.readText$default((File)file, null, (int)1, null)));
                        }
                    }), (int)1, null) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public Map<String, LibraryDescriptor> getDescriptors() {
        return this.homeDir == null ? super.getDescriptors() : (Map)this.libraryDescriptors.invoke((Object)this.homeDir);
    }

    @NotNull
    public LibraryDescriptorGlobalOptions getDescriptorGlobalOptions() {
        return this.homeDir == null ? super.getDescriptorGlobalOptions() : (LibraryDescriptorGlobalOptions)this.descriptorOptions.invoke((Object)this.homeDir);
    }

    @NotNull
    public final Function1<File, LibraryDescriptorGlobalOptions> getDescriptorOptions() {
        return this.descriptorOptions;
    }

    @NotNull
    public final Function1<File, Map<String, LibraryDescriptor>> getLibraryDescriptors() {
        return this.libraryDescriptors;
    }

    public static final /* synthetic */ LibraryDescriptorsManager access$getLibraryDescriptorsManager$p(HomeDirLibraryDescriptorsProvider $this) {
        return $this.libraryDescriptorsManager;
    }
}

