/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.jvm.util.JvmClasspathUtilKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.ConfigKt;
import org.jetbrains.kotlinx.jupyter.IkotlinKt;
import org.jetbrains.kotlinx.jupyter.UtilKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommManager;
import org.jetbrains.kotlinx.jupyter.api.libraries.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterConnection;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutorImpl;
import org.jetbrains.kotlinx.jupyter.libraries.EmptyResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtil;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterBaseSockets;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityImpl;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionImpl;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternal;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterSocketManager;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProviderImpl;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHandler;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHandlerImpl;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerImpl;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.repl.ReplConfig;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.repl.config.DefaultReplSettings;
import org.jetbrains.kotlinx.jupyter.repl.creating.CreatingUtilKt;
import org.jetbrains.kotlinx.jupyter.repl.creating.DefaultReplComponentsProvider;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplComponentsProvider;
import org.jetbrains.kotlinx.jupyter.startup.ArgumentsKt;
import org.jetbrains.kotlinx.jupyter.startup.KernelArgs;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;
import org.jetbrains.kotlinx.jupyter.util.Provider;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u001a\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001f\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a!\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0006\u0010\u001c\u001a\u00020\u000b\"\u0015\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001d"}, d2={"iKotlinClass", "Ljava/lang/Class;", "getIKotlinClass", "()Ljava/lang/Class;", "createMessageHandler", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHandler;", "replSettings", "Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;", "embedKernel", "", "cfgFile", "Ljava/io/File;", "resolutionInfoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "scriptReceivers", "", "", "kernelServer", "main", "args", "", "", "([Ljava/lang/String;)V", "parseCommandLine", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelArgs;", "([Ljava/lang/String;)Lorg/jetbrains/kotlinx/jupyter/startup/KernelArgs;", "printClassPath", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nikotlin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ikotlin.kt\norg/jetbrains/kotlinx/jupyter/IkotlinKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,201:1\n13291#2:202\n13292#2:208\n11047#2:211\n11382#2,3:212\n13291#2,2:215\n1547#3:203\n1618#3,3:204\n1#4:207\n37#5,2:209\n*S KotlinDebug\n*F\n+ 1 ikotlin.kt\norg/jetbrains/kotlinx/jupyter/IkotlinKt\n*L\n42#1:202\n42#1:208\n108#1:211\n108#1:212,3\n158#1:215,2\n48#1:203\n48#1:204,3\n108#1:209,2\n*E\n"})
public final class IkotlinKt {
    @NotNull
    private static final Class<?> iKotlinClass;

    @NotNull
    public static final Class<?> getIKotlinClass() {
        return iKotlinClass;
    }

    /*
     * WARNING - void declaration
     */
    private static final KernelArgs parseCommandLine(String ... args) {
        File cfgFile = null;
        Ref.ObjectRef classpath = new Ref.ObjectRef();
        File homeDir = null;
        Integer debugPort = null;
        String clientType = null;
        String jvmTargetForSnippets = null;
        String[] $this$forEach$iv = args;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object it;
            String element$iv;
            String arg = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (StringsKt.startsWith$default((String)arg, (String)"-cp=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)arg, (String)"-classpath=", (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list = (List)classpath.element;
                if (list != null) {
                    it = list;
                    boolean bl2 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("classpath already set to ");
                    Iterable iterable = (Iterable)it;
                    String string = File.pathSeparator;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
                    throw new IllegalArgumentException(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
                }
                CharSequence charSequence = StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null);
                Object object = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
                object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
                Ref.ObjectRef objectRef = classpath;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new File((String)it2));
                }
                objectRef.element = (List)destination$iv$iv;
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-home=", (boolean)false, (int)2, null)) {
                homeDir = new File(StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null));
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-debugPort=", (boolean)false, (int)2, null)) {
                debugPort = Integer.parseInt(StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null));
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-client=", (boolean)false, (int)2, null)) {
                clientType = StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-jvmTarget", (boolean)false, (int)2, null)) {
                jvmTargetForSnippets = StringsKt.substringAfter$default((String)arg, (char)'=', null, (int)2, null);
                continue;
            }
            File file = cfgFile;
            if (file != null) {
                it = file;
                boolean bl4 = false;
                throw new IllegalArgumentException("config file already set to " + it);
            }
            cfgFile = new File(arg);
        }
        File file = cfgFile;
        if (file == null) {
            throw new IllegalArgumentException("config file is not provided");
        }
        File cfgFileValue = file;
        if (!cfgFileValue.exists() || !cfgFileValue.isFile()) {
            throw new IllegalArgumentException("invalid config file " + cfgFileValue);
        }
        List list = (List)classpath.element;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return new KernelArgs(cfgFileValue, list, homeDir, debugPort, clientType, jvmTargetForSnippets);
    }

    public static final void printClassPath() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNull((Object)cl);
        List cp = JvmClasspathUtilKt.classpathFromClassloader$default((ClassLoader)cl, (boolean)false, (int)2, null);
        if (cp != null) {
            ConfigKt.getLog().info("Current classpath: " + CollectionsKt.joinToString$default((Iterable)cp, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    public static final void main(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            ConfigKt.getLog().info("Kernel args: " + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, (Function1)main.1.INSTANCE, (int)31, null));
            KernelArgs kernelArgs = IkotlinKt.parseCommandLine(Arrays.copyOf(args, args.length));
            KernelConfig kernelConfig = ArgumentsKt.getConfig((KernelArgs)kernelArgs);
            ReplConfig replConfig2 = ReplConfig.Companion.create$default((ReplConfig.Companion)ReplConfig.Companion, (Function1)main.replConfig.1.INSTANCE, null, (File)kernelArgs.getHomeDir(), (boolean)false, (int)10, null);
            ReplRuntimeProperties runtimeProperties = RuntimePropertiesKt.createRuntimeProperties$default((KernelConfig)kernelConfig, null, (int)2, null);
            DefaultReplSettings replSettings = new DefaultReplSettings(kernelConfig, replConfig2, runtimeProperties, null, 8, null);
            IkotlinKt.kernelServer(replSettings);
        }
        catch (Exception e) {
            ConfigKt.getLog().error("exception running kernel with args: \"" + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, null, (int)63, null) + '\"', (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void embedKernel(@NotNull File cfgFile, @Nullable ResolutionInfoProvider resolutionInfoProvider, @Nullable List<? extends Object> scriptReceivers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)cfgFile, (String)"cfgFile");
        String string = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        String[] $this$toTypedArray$iv = (String[])StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = thisCollection$iv.toArray(new String[0]);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        List cp = (List)destination$iv$iv;
        KernelConfig kernelConfig = ArgumentsKt.getConfig((KernelArgs)new KernelArgs(cfgFile, cp, null, null, null, null));
        ReplConfig replConfig2 = ReplConfig.Companion.create$default((ReplConfig.Companion)ReplConfig.Companion, (Function1)((Function1)new Function1<LibraryHttpUtil, ResolutionInfoProvider>(resolutionInfoProvider){
            final /* synthetic */ ResolutionInfoProvider $resolutionInfoProvider;
            {
                this.$resolutionInfoProvider = $resolutionInfoProvider;
                super(1);
            }

            @NotNull
            public final ResolutionInfoProvider invoke(@NotNull LibraryHttpUtil httpUtil) {
                Intrinsics.checkNotNullParameter((Object)httpUtil, (String)"httpUtil");
                ResolutionInfoProvider resolutionInfoProvider = this.$resolutionInfoProvider;
                if (resolutionInfoProvider == null) {
                    resolutionInfoProvider = (ResolutionInfoProvider)new EmptyResolutionInfoProvider(httpUtil.getLibraryInfoCache());
                }
                return resolutionInfoProvider;
            }
        }), null, null, (boolean)true, (int)2, null);
        List list = scriptReceivers;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        DefaultReplSettings replSettings = new DefaultReplSettings(kernelConfig, replConfig2, null, list, 4, null);
        IkotlinKt.kernelServer(replSettings);
    }

    public static /* synthetic */ void embedKernel$default(File file, ResolutionInfoProvider resolutionInfoProvider, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        IkotlinKt.embedKernel(file, resolutionInfoProvider, list);
    }

    @NotNull
    public static final MessageHandler createMessageHandler(@NotNull DefaultReplSettings replSettings, @NotNull JupyterBaseSockets socketManager2) {
        Intrinsics.checkNotNullParameter((Object)replSettings, (String)"replSettings");
        Intrinsics.checkNotNullParameter((Object)socketManager2, (String)"socketManager");
        MessageFactoryProvider messageFactoryProvider = (MessageFactoryProvider)new MessageFactoryProviderImpl();
        JupyterCommunicationFacility communicationFacility = (JupyterCommunicationFacility)new JupyterCommunicationFacilityImpl(socketManager2, (Provider)messageFactoryProvider);
        JupyterExecutor executor = (JupyterExecutor)new JupyterExecutorImpl();
        CommManagerInternal commManager = (CommManagerInternal)new CommManagerImpl(communicationFacility);
        ReplForJupyter repl = CreatingUtilKt.createRepl((ReplComponentsProvider)new DefaultReplComponentsProvider(replSettings, communicationFacility, (CommManager)commManager));
        return (MessageHandler)new MessageHandlerImpl(repl, commManager, messageFactoryProvider, socketManager2, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void kernelServer(@NotNull DefaultReplSettings replSettings) {
        Intrinsics.checkNotNullParameter((Object)replSettings, (String)"replSettings");
        KernelConfig kernelConfig = replSettings.getKernelConfig();
        ConfigKt.getLog().info("Starting server with config: " + kernelConfig);
        Closeable closeable = new JupyterConnectionImpl(kernelConfig);
        Throwable throwable = null;
        try {
            JupyterConnectionInternal conn = (JupyterConnectionInternal)closeable;
            boolean bl = false;
            IkotlinKt.printClassPath();
            ConfigKt.getLog().info("Begin listening for events");
            JupyterSocketManager socketManager2 = conn.getSocketManager();
            MessageHandler messageHandler = IkotlinKt.createMessageHandler(replSettings, (JupyterBaseSockets)socketManager2);
            Thread mainThread = Thread.currentThread();
            IkotlinKt.kernelServer$lambda$6$addMessageCallbackForSocket((JupyterConnection)conn, messageHandler, JupyterSocketType.CONTROL);
            IkotlinKt.kernelServer$lambda$6$addMessageCallbackForSocket((JupyterConnection)conn, messageHandler, JupyterSocketType.SHELL);
            Thread controlThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(mainThread, socketManager2){
                final /* synthetic */ Thread $mainThread;
                final /* synthetic */ JupyterSocketManager $socketManager;
                {
                    this.$mainThread = $mainThread;
                    this.$socketManager = $socketManager;
                    super(0);
                }

                public final void invoke() {
                    Thread[] threadArray = new Thread[1];
                    Intrinsics.checkNotNullExpressionValue((Object)this.$mainThread, (String)"$mainThread");
                    IkotlinKt.access$kernelServer$lambda$6$socketLoop("Control: Interrupted", threadArray, (Function0)new Function0<Unit>(this.$socketManager){
                        final /* synthetic */ JupyterSocketManager $socketManager;
                        {
                            this.$socketManager = $socketManager;
                            super(0);
                        }

                        public final void invoke() {
                            this.$socketManager.getControl().runCallbacksOnMessage();
                        }
                    });
                }
            }), (int)31, null);
            Thread hbThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(mainThread, socketManager2){
                final /* synthetic */ Thread $mainThread;
                final /* synthetic */ JupyterSocketManager $socketManager;
                {
                    this.$mainThread = $mainThread;
                    this.$socketManager = $socketManager;
                    super(0);
                }

                public final void invoke() {
                    Thread[] threadArray = new Thread[1];
                    Intrinsics.checkNotNullExpressionValue((Object)this.$mainThread, (String)"$mainThread");
                    IkotlinKt.access$kernelServer$lambda$6$socketLoop("Heartbeat: Interrupted", threadArray, (Function0)new Function0<Unit>(this.$socketManager){
                        final /* synthetic */ JupyterSocketManager $socketManager;
                        {
                            this.$socketManager = $socketManager;
                            super(0);
                        }

                        public final void invoke() {
                            this.$socketManager.getHeartbeat().onData((Function2)kernelServer.1.hbThread.1.INSTANCE);
                        }
                    });
                }
            }), (int)31, null);
            Thread[] threadArray = new Thread[]{controlThread2, hbThread2};
            IkotlinKt.kernelServer$lambda$6$socketLoop("Main: Interrupted", threadArray, (Function0<Unit>)((Function0)new Function0<Unit>(socketManager2){
                final /* synthetic */ JupyterSocketManager $socketManager;
                {
                    this.$socketManager = $socketManager;
                    super(0);
                }

                public final void invoke() {
                    this.$socketManager.getShell().runCallbacksOnMessage();
                }
            }));
            try {
                controlThread2.join();
                hbThread2.join();
                UtilKt.closeIfPossible(messageHandler);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConfigKt.getLog().info("Shutdown server");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void kernelServer$lambda$6$socketLoop(String interruptedMessage, Thread[] threadsToInterrupt, Function0<Unit> loopBody) {
        while (true) {
            try {
                loopBody.invoke();
            }
            catch (InterruptedException e) {
                ConfigKt.getLog().debug(interruptedMessage);
                Thread[] $this$forEach$iv = threadsToInterrupt;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    Thread element$iv;
                    Thread it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    it.interrupt();
                }
                return;
            }
        }
    }

    private static final void kernelServer$lambda$6$addMessageCallbackForSocket(JupyterConnection $this$kernelServer_u24lambda_u246_u24addMessageCallbackForSocket, MessageHandler messageHandler, JupyterSocketType socketType) {
        $this$kernelServer_u24lambda_u246_u24addMessageCallbackForSocket.addMessageCallback(ConnectionKt.rawMessageCallback((JupyterSocketType)socketType, null, (Function1)((Function1)new Function1<RawMessage, Unit>(messageHandler, socketType){
            final /* synthetic */ MessageHandler $messageHandler;
            final /* synthetic */ JupyterSocketType $socketType;
            {
                this.$messageHandler = $messageHandler;
                this.$socketType = $socketType;
                super(1);
            }

            public final void invoke(@NotNull RawMessage rawMessage) {
                Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
                this.$messageHandler.handleMessage(this.$socketType, rawMessage);
            }
        })));
    }

    public static final /* synthetic */ void access$kernelServer$lambda$6$socketLoop(String interruptedMessage, Thread[] threadsToInterrupt, Function0 loopBody) {
        IkotlinKt.kernelServer$lambda$6$socketLoop(interruptedMessage, threadsToInterrupt, (Function0<Unit>)loopBody);
    }

    static {
        Class<?> clazz = new Object(){}.getClass().getEnclosingClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getEnclosingClass(...)");
        iKotlinClass = clazz;
    }
}

