/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResource;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceType;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.libraries.CssLibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.JsLibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResourcesProcessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResourcesProcessorImpl;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResourcesProcessor;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "(Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;)V", "processorMap", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourceType;", "wrapLibrary", "", "resource", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResource;", "classLoader", "Ljava/lang/ClassLoader;", "kotlin-jupyter-kernel"})
public final class LibraryResourcesProcessorImpl
implements LibraryResourcesProcessor {
    @NotNull
    private final EnumMap<ResourceType, LibraryResourcesProcessor> processorMap;

    public LibraryResourcesProcessorImpl(@NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.processorMap = new EnumMap(ResourceType.class);
        ((Map)this.processorMap).put(ResourceType.JS, new JsLibraryResourcesProcessor(httpClient));
        ((Map)this.processorMap).put(ResourceType.CSS, new CssLibraryResourcesProcessor(httpClient));
    }

    @NotNull
    public String wrapLibrary(@NotNull LibraryResource resource, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return ((LibraryResourcesProcessor)MapsKt.getValue((Map)this.processorMap, (Object)resource.getType())).wrapLibrary(resource, classLoader);
    }
}

