/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0015J\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0018R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/jupyter/LoggingManager;", "", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "basicEncoder", "Lch/qos/logback/classic/encoder/PatternLayoutEncoder;", "loggerContext", "Lch/qos/logback/classic/LoggerContext;", "getLoggerContext", "()Lch/qos/logback/classic/LoggerContext;", "rootLogger", "Lch/qos/logback/classic/Logger;", "addAppender", "", "name", "", "appender", "Lch/qos/logback/core/Appender;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "allLogAppenders", "", "disableLogging", "mainLoggerLevel", "Lch/qos/logback/classic/Level;", "removeAppender", "appenderName", "setRootLoggingLevel", "level", "kotlin-jupyter-kernel"})
public final class LoggingManager {
    @Nullable
    private final ch.qos.logback.classic.Logger rootLogger;
    @Nullable
    private final PatternLayoutEncoder basicEncoder;

    /*
     * WARNING - void declaration
     */
    public LoggingManager(@NotNull KernelLoggerFactory loggerFactory) {
        PatternLayoutEncoder patternLayoutEncoder;
        void $this$basicEncoder_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Logger logger = loggerFactory.getLogger("ROOT");
        this.rootLogger = logger instanceof ch.qos.logback.classic.Logger ? (ch.qos.logback.classic.Logger)logger : null;
        LoggingManager loggingManager = this;
        LoggingManager loggingManager2 = this;
        boolean bl = false;
        if (super.getLoggerContext() == null) {
            patternLayoutEncoder = null;
        } else {
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)super.getLoggerContext());
            encoder.setPattern("%-4relative [%thread] %-5level %logger{35} - %msg %n");
            encoder.start();
            patternLayoutEncoder = encoder;
        }
        loggingManager2.basicEncoder = patternLayoutEncoder;
    }

    private final LoggerContext getLoggerContext() {
        ch.qos.logback.classic.Logger logger = this.rootLogger;
        return logger != null ? logger.getLoggerContext() : null;
    }

    public final void setRootLoggingLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ch.qos.logback.classic.Logger logger = this.rootLogger;
        if (logger != null) {
            logger.setLevel(level);
        }
    }

    public final void disableLogging() {
        Level level = Level.OFF;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"OFF");
        this.setRootLoggingLevel(level);
    }

    @NotNull
    public final Level mainLoggerLevel() {
        ch.qos.logback.classic.Logger logger = this.rootLogger;
        if (logger == null) {
            Level level = Level.DEBUG;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"DEBUG");
            return level;
        }
        ch.qos.logback.classic.Logger mainLogger = logger;
        Level level = mainLogger.getEffectiveLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getEffectiveLevel(...)");
        return level;
    }

    @NotNull
    public final List<Appender<ILoggingEvent>> allLogAppenders() {
        ch.qos.logback.classic.Logger logger = this.rootLogger;
        if (logger == null) {
            return CollectionsKt.emptyList();
        }
        ch.qos.logback.classic.Logger mainLogger = logger;
        List result2 = new ArrayList();
        mainLogger.iteratorForAppenders().forEachRemaining(new Consumer(result2){
            final /* synthetic */ List<Appender<ILoggingEvent>> $result;
            {
                this.$result = $result;
            }

            public final void accept(Appender<ILoggingEvent> it) {
                Intrinsics.checkNotNull(it);
                this.$result.add(it);
            }
        });
        return result2;
    }

    public final void addAppender(@NotNull String name, @NotNull Appender<ILoggingEvent> appender) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(appender, (String)"appender");
            if (this.getLoggerContext() == null || this.basicEncoder == null) {
                return;
            }
            appender.setName(name);
            appender.setContext((Context)this.getLoggerContext());
            OutputStreamAppender outputStreamAppender = appender instanceof OutputStreamAppender ? (OutputStreamAppender)appender : null;
            if (outputStreamAppender != null) {
                outputStreamAppender.setEncoder((Encoder)this.basicEncoder);
            }
            appender.start();
            ch.qos.logback.classic.Logger logger = this.rootLogger;
            if (logger == null) break block2;
            logger.addAppender(appender);
        }
    }

    public final void removeAppender(@NotNull String appenderName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)appenderName, (String)"appenderName");
            ch.qos.logback.classic.Logger logger = this.rootLogger;
            if (logger == null) break block0;
            logger.detachAppender(appenderName);
        }
    }
}

