/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00072\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/VariablesUsagesPerCellWatcher;", "K", "", "V", "()V", "cellVariables", "", "", "getCellVariables", "()Ljava/util/Map;", "variablesDeclarationInfo", "addDeclaration", "", "address", "variableRef", "(Ljava/lang/Object;Ljava/lang/Object;)V", "addUsage", "", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;", "ensureStorageCreation", "(Ljava/lang/Object;)Ljava/util/Set;", "removeOldUsages", "newAddress", "(Ljava/lang/Object;)V", "kotlin-jupyter-kernel"})
public final class VariablesUsagesPerCellWatcher<K, V> {
    @NotNull
    private final Map<K, Set<V>> cellVariables = new LinkedHashMap();
    @NotNull
    private final Map<V, K> variablesDeclarationInfo = new LinkedHashMap();

    @NotNull
    public final Map<K, Set<V>> getCellVariables() {
        return this.cellVariables;
    }

    public final void addDeclaration(@NotNull K address, @NotNull V variableRef) {
        block2: {
            K oldCellId;
            Intrinsics.checkNotNullParameter(address, (String)"address");
            Intrinsics.checkNotNullParameter(variableRef, (String)"variableRef");
            this.ensureStorageCreation(address);
            if (this.variablesDeclarationInfo.containsKey(variableRef) && !Intrinsics.areEqual(oldCellId = this.variablesDeclarationInfo.get(variableRef), address)) {
                Set<V> set = this.cellVariables.get(oldCellId);
                if (set != null) {
                    set.remove(variableRef);
                }
            }
            this.variablesDeclarationInfo.put(variableRef, address);
            Set<V> set = this.cellVariables.get(address);
            if (set == null) break block2;
            set.add(variableRef);
        }
    }

    @Nullable
    public final Boolean addUsage(@NotNull K address, @NotNull V variableRef) {
        Intrinsics.checkNotNullParameter(address, (String)"address");
        Intrinsics.checkNotNullParameter(variableRef, (String)"variableRef");
        Set<V> set = this.cellVariables.get(address);
        return set != null ? Boolean.valueOf(set.add(variableRef)) : null;
    }

    public final void removeOldUsages(@NotNull K newAddress) {
        block0: {
            Intrinsics.checkNotNullParameter(newAddress, (String)"newAddress");
            Set<V> set = this.cellVariables.get(newAddress);
            if (set == null) break block0;
            set.removeIf(new Predicate(this, newAddress){
                final /* synthetic */ VariablesUsagesPerCellWatcher<K, V> this$0;
                final /* synthetic */ K $newAddress;
                {
                    this.this$0 = $receiver;
                    this.$newAddress = $newAddress;
                }

                public final boolean test(@NotNull V it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return !Intrinsics.areEqual(VariablesUsagesPerCellWatcher.access$getVariablesDeclarationInfo$p(this.this$0).get(it), this.$newAddress);
                }
            });
        }
    }

    @Nullable
    public final Set<V> ensureStorageCreation(@NotNull K address) {
        Intrinsics.checkNotNullParameter(address, (String)"address");
        return this.cellVariables.putIfAbsent(address, new LinkedHashSet());
    }

    public static final /* synthetic */ Map access$getVariablesDeclarationInfo$p(VariablesUsagesPerCellWatcher $this) {
        return $this.variablesDeclarationInfo;
    }
}

