/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.SourceCodeCompletionVariant;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.jetbrains.kotlinx.jupyter.common.Status;
import org.jetbrains.kotlinx.jupyter.compiler.util.CodeInterval;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.magics.AbstractCompletionMagicsProcessor;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor;", "Lorg/jetbrains/kotlinx/jupyter/magics/AbstractCompletionMagicsProcessor;", "Lkotlin/script/experimental/api/SourceCodeCompletionVariant;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "libraryDescriptorsProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorsProvider;", "parseOutCellMarker", "", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorsProvider;ZLorg/jetbrains/kotlinx/jupyter/common/HttpClient;)V", "logger", "Lorg/slf4j/Logger;", "getHttpResponseText", "", "url", "key", "variant", "process", "Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Result;", "code", "cursor", "", "text", "icon", "Result", "kotlin-jupyter-kernel"})
public final class CompletionMagicsProcessor
extends AbstractCompletionMagicsProcessor<SourceCodeCompletionVariant> {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Logger logger;

    public CompletionMagicsProcessor(@NotNull KernelLoggerFactory loggerFactory, @NotNull LibraryDescriptorsProvider libraryDescriptorsProvider, boolean parseOutCellMarker, @NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorsProvider, (String)"libraryDescriptorsProvider");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        super(libraryDescriptorsProvider, parseOutCellMarker);
        this.httpClient = httpClient;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()));
    }

    public /* synthetic */ CompletionMagicsProcessor(KernelLoggerFactory kernelLoggerFactory, LibraryDescriptorsProvider libraryDescriptorsProvider, boolean bl, HttpClient httpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(kernelLoggerFactory, libraryDescriptorsProvider, bl, httpClient);
    }

    @NotNull
    protected SourceCodeCompletionVariant variant(@NotNull String text, @NotNull String icon) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return new SourceCodeCompletionVariant(text, text, icon, icon, null, 16, null);
    }

    @NotNull
    protected String key(@NotNull SourceCodeCompletionVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return variant.getText();
    }

    @Nullable
    protected String getHttpResponseText(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ResponseWrapper response = HttpUtilKt.getHttp((HttpClient)this.httpClient, (String)url);
        Status status = response.getStatus();
        if (!ResponseKt.getSuccessful((Status)status)) {
            this.logger.warn("Magic completion request failed: " + status);
            return null;
        }
        return response.getText();
    }

    @NotNull
    public final Result process(@NotNull String code, int cursor) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Sequence magics = this.magicsIntervals(code);
        boolean insideMagic = false;
        AbstractCompletionMagicsProcessor.Handler handler = new AbstractCompletionMagicsProcessor.Handler((AbstractCompletionMagicsProcessor)this);
        for (CodeInterval magicRange : magics) {
            String magicText;
            int n = magicRange.getFrom() + 1;
            boolean bl = cursor <= magicRange.getTo() ? n <= cursor : false;
            if (!bl) continue;
            insideMagic = true;
            if (code.charAt(magicRange.getFrom()) != '%' || cursor == magicRange.getFrom()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)code.substring(magicRange.getFrom() + 1, magicRange.getTo()), (String)"substring(...)");
            LoggingKt.catchAll$default((Logger)this.logger, null, (String)("Handling completion of " + magicText + " failed"), (Function0)((Function0)new Function0<Unit>(handler, magicText, cursor, magicRange){
                final /* synthetic */ AbstractCompletionMagicsProcessor.Handler $handler;
                final /* synthetic */ String $magicText;
                final /* synthetic */ int $cursor;
                final /* synthetic */ CodeInterval $magicRange;
                {
                    this.$handler = $handler;
                    this.$magicText = $magicText;
                    this.$cursor = $cursor;
                    this.$magicRange = $magicRange;
                    super(0);
                }

                public final void invoke() {
                    this.$handler.handle(this.$magicText, this.$cursor - this.$magicRange.getFrom() - 1);
                }
            }), (int)1, null);
        }
        return new Result(this.getCleanCode(code, magics), insideMagic, handler.getCompletions());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompletionMagicsProcessor$Result;", "", "code", "", "cursorInsideMagic", "", "completions", "", "Lkotlin/script/experimental/api/SourceCodeCompletionVariant;", "(Ljava/lang/String;ZLjava/util/List;)V", "getCode", "()Ljava/lang/String;", "getCompletions", "()Ljava/util/List;", "getCursorInsideMagic", "()Z", "kotlin-jupyter-kernel"})
    public static final class Result {
        @NotNull
        private final String code;
        private final boolean cursorInsideMagic;
        @NotNull
        private final List<SourceCodeCompletionVariant> completions;

        public Result(@NotNull String code, boolean cursorInsideMagic, @NotNull List<SourceCodeCompletionVariant> completions) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter(completions, (String)"completions");
            this.code = code;
            this.cursorInsideMagic = cursorInsideMagic;
            this.completions = completions;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public final boolean getCursorInsideMagic() {
            return this.cursorInsideMagic;
        }

        @NotNull
        public final List<SourceCodeCompletionVariant> getCompletions() {
            return this.completions;
        }
    }
}

