/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.UtilKt;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.common.ReplEnum;
import org.jetbrains.kotlinx.jupyter.common.ReplLineMagic;
import org.jetbrains.kotlinx.jupyter.compiler.util.CodeInterval;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.magics.AbstractMagicsProcessor;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/ErrorsMagicsProcessor;", "Lorg/jetbrains/kotlinx/jupyter/magics/AbstractMagicsProcessor;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "parseOutCellMarker", "", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Z)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "process", "Lorg/jetbrains/kotlinx/jupyter/magics/ErrorsMagicsProcessor$Result;", "code", "", "Handler", "Result", "kotlin-jupyter-kernel"})
public final class ErrorsMagicsProcessor
extends AbstractMagicsProcessor {
    @NotNull
    private final Logger logger;

    public ErrorsMagicsProcessor(@NotNull KernelLoggerFactory loggerFactory, boolean parseOutCellMarker) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        super(parseOutCellMarker);
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()));
    }

    public /* synthetic */ ErrorsMagicsProcessor(KernelLoggerFactory kernelLoggerFactory, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(kernelLoggerFactory, bl);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Result process(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Sequence magics = this.magicsIntervals(code);
        Handler handler = new Handler(code);
        for (CodeInterval magicRange : magics) {
            String magicText;
            if (code.charAt(magicRange.getFrom()) != '%') continue;
            Intrinsics.checkNotNullExpressionValue((Object)code.substring(magicRange.getFrom() + 1, magicRange.getTo()), (String)"substring(...)");
            LoggingKt.catchAll$default((Logger)this.logger, null, (String)("Handling errors of " + magicText + " failed"), (Function0)((Function0)new Function0<Unit>(handler, magicText, magicRange){
                final /* synthetic */ Handler $handler;
                final /* synthetic */ String $magicText;
                final /* synthetic */ CodeInterval $magicRange;
                {
                    this.$handler = $handler;
                    this.$magicText = $magicText;
                    this.$magicRange = $magicRange;
                    super(0);
                }

                public final void invoke() {
                    this.$handler.handle(this.$magicText, this.$magicRange);
                }
            }), (int)1, null);
        }
        return new Result(this.getCleanCode(code, magics), (Sequence<ScriptDiagnostic>)CollectionsKt.asSequence((Iterable)handler.getDiagnostics()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/ErrorsMagicsProcessor$Handler;", "", "code", "", "(Lorg/jetbrains/kotlinx/jupyter/magics/ErrorsMagicsProcessor;Ljava/lang/String;)V", "_diagnostics", "", "Lkotlin/script/experimental/api/ScriptDiagnostic;", "getCode", "()Ljava/lang/String;", "diagnostics", "", "getDiagnostics", "()Ljava/util/List;", "addError", "", "message", "codeInterval", "Lorg/jetbrains/kotlinx/jupyter/compiler/util/CodeInterval;", "handle", "magicText", "magicRange", "kotlin-jupyter-kernel"})
    private final class Handler {
        @NotNull
        private final String code;
        @NotNull
        private final List<ScriptDiagnostic> _diagnostics;

        public Handler(String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
            this._diagnostics = new ArrayList();
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final List<ScriptDiagnostic> getDiagnostics() {
            return this._diagnostics;
        }

        public final void handle(@NotNull String magicText, @NotNull CodeInterval magicRange) {
            Intrinsics.checkNotNullParameter((Object)magicText, (String)"magicText");
            Intrinsics.checkNotNullParameter((Object)magicRange, (String)"magicRange");
            String magicName = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)magicText, (char)' ', null, (int)2, null))).toString();
            ReplEnum.CodeInsightValue magic = ReplLineMagic.Companion.valueOfOrNull(magicName);
            if (magic == null) {
                this.addError("Unknown magic", magicRange);
                return;
            }
        }

        public final void addError(@NotNull String message, @NotNull CodeInterval codeInterval) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)codeInterval, (String)"codeInterval");
            this._diagnostics.add(UtilKt.diagnostic$default(codeInterval, this.code, message, null, 4, null));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/ErrorsMagicsProcessor$Result;", "", "code", "", "diagnostics", "Lkotlin/sequences/Sequence;", "Lkotlin/script/experimental/api/ScriptDiagnostic;", "(Ljava/lang/String;Lkotlin/sequences/Sequence;)V", "getCode", "()Ljava/lang/String;", "getDiagnostics", "()Lkotlin/sequences/Sequence;", "kotlin-jupyter-kernel"})
    public static final class Result {
        @NotNull
        private final String code;
        @NotNull
        private final Sequence<ScriptDiagnostic> diagnostics;

        public Result(@NotNull String code, @NotNull Sequence<ScriptDiagnostic> diagnostics2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
            this.code = code;
            this.diagnostics = diagnostics2;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final Sequence<ScriptDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }
    }
}

