/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterSocketManager;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketInfo;
import org.jetbrains.kotlinx.jupyter.util.TerminationKt;
import org.zeromq.ZMQ;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0006H\u0002R\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0016\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterSocketManagerImpl;", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterSocketManager;", "terminationTimeout", "Lkotlin/time/Duration;", "openSocketAction", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketInfo;", "Lorg/zeromq/ZMQ$Context;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "(JLkotlin/jvm/functions/Function2;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "control", "getControl", "()Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "heartbeat", "getHeartbeat", "iopub", "getIopub", "shell", "getShell", "socketsMap", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterSocketType;", "stdin", "getStdin", "J", "zmqContext", "close", "", "doClose", "fromSocketType", "type", "openSocket", "socketInfo", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nJupyterSocketManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterSocketManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterSocketManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1855#2,2:47\n*S KotlinDebug\n*F\n+ 1 JupyterSocketManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterSocketManagerImpl\n*L\n42#1:47,2\n*E\n"})
public final class JupyterSocketManagerImpl
implements JupyterSocketManager {
    private final long terminationTimeout;
    @NotNull
    private final Function2<JupyterSocketInfo, ZMQ.Context, JupyterSocket> openSocketAction;
    @NotNull
    private final ZMQ.Context zmqContext;
    @NotNull
    private final JupyterSocket heartbeat;
    @NotNull
    private final JupyterSocket shell;
    @NotNull
    private final JupyterSocket control;
    @NotNull
    private final JupyterSocket stdin;
    @NotNull
    private final JupyterSocket iopub;
    @NotNull
    private final Map<JupyterSocketType, JupyterSocket> socketsMap;

    /*
     * WARNING - void declaration
     */
    private JupyterSocketManagerImpl(long terminationTimeout, Function2<? super JupyterSocketInfo, ? super ZMQ.Context, ? extends JupyterSocket> openSocketAction) {
        void $this$socketsMap_u24lambda_u240;
        Map map;
        Intrinsics.checkNotNullParameter(openSocketAction, (String)"openSocketAction");
        this.terminationTimeout = terminationTimeout;
        this.openSocketAction = openSocketAction;
        ZMQ.Context context = ZMQ.context((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context(...)");
        this.zmqContext = context;
        this.heartbeat = this.openSocket(JupyterSocketInfo.HB);
        this.shell = this.openSocket(JupyterSocketInfo.SHELL);
        this.control = this.openSocket(JupyterSocketInfo.CONTROL);
        this.stdin = this.openSocket(JupyterSocketInfo.STDIN);
        this.iopub = this.openSocket(JupyterSocketInfo.IOPUB);
        Map map2 = map = MapsKt.createMapBuilder();
        JupyterSocketManagerImpl jupyterSocketManagerImpl = this;
        boolean bl = false;
        $this$socketsMap_u24lambda_u240.put(JupyterSocketType.HB, this.getHeartbeat());
        $this$socketsMap_u24lambda_u240.put(JupyterSocketType.SHELL, this.getShell());
        $this$socketsMap_u24lambda_u240.put(JupyterSocketType.CONTROL, this.getControl());
        $this$socketsMap_u24lambda_u240.put(JupyterSocketType.STDIN, this.getStdin());
        $this$socketsMap_u24lambda_u240.put(JupyterSocketType.IOPUB, this.getIopub());
        jupyterSocketManagerImpl.socketsMap = MapsKt.build((Map)map);
    }

    public /* synthetic */ JupyterSocketManagerImpl(long l, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS);
        }
        this(l, function2, null);
    }

    private final JupyterSocket openSocket(JupyterSocketInfo socketInfo) {
        return (JupyterSocket)this.openSocketAction.invoke((Object)socketInfo, (Object)this.zmqContext);
    }

    @NotNull
    public JupyterSocket getHeartbeat() {
        return this.heartbeat;
    }

    @NotNull
    public JupyterSocket getShell() {
        return this.shell;
    }

    @NotNull
    public JupyterSocket getControl() {
        return this.control;
    }

    @NotNull
    public JupyterSocket getStdin() {
        return this.stdin;
    }

    @NotNull
    public JupyterSocket getIopub() {
        return this.iopub;
    }

    @NotNull
    public JupyterSocket fromSocketType(@NotNull JupyterSocketType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        JupyterSocket jupyterSocket = this.socketsMap.get(type);
        if (jupyterSocket == null) {
            throw new RuntimeException("Unknown socket type: " + type);
        }
        return jupyterSocket;
    }

    public void close() {
        TerminationKt.closeWithTimeout((long)Duration.getInWholeMilliseconds-impl((long)this.terminationTimeout), (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                JupyterSocketManagerImpl.access$doClose((JupyterSocketManagerImpl)this.receiver);
            }
        }));
    }

    private final void doClose() {
        Iterable $this$forEach$iv = this.socketsMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterSocket it = (JupyterSocket)element$iv;
            boolean bl = false;
            it.close();
        }
        this.zmqContext.close();
    }

    public /* synthetic */ JupyterSocketManagerImpl(long terminationTimeout, Function2 openSocketAction, DefaultConstructorMarker $constructor_marker) {
        this(terminationTimeout, (Function2<? super JupyterSocketInfo, ? super ZMQ.Context, ? extends JupyterSocket>)openSocketAction);
    }

    public static final /* synthetic */ void access$doClose(JupyterSocketManagerImpl $this) {
        $this.doClose();
    }
}

