/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.UtilKt;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.messaging.AbstractMessageHandler;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionCounter;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterBaseSockets;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.MessageRequestProcessorImpl;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHandlerImpl;", "Lorg/jetbrains/kotlinx/jupyter/messaging/AbstractMessageHandler;", "Ljava/io/Closeable;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "repl", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "commManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "messageFactoryProvider", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;", "executor", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;)V", "executionCounter", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;", "getRepl", "()Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "close", "", "createProcessor", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageRequestProcessor;", "message", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "kotlin-jupyter-kernel"})
public final class MessageHandlerImpl
extends AbstractMessageHandler
implements Closeable {
    @NotNull
    private final KernelLoggerFactory loggerFactory;
    @NotNull
    private final ReplForJupyter repl;
    @NotNull
    private final CommManagerInternal commManager;
    @NotNull
    private final MessageFactoryProvider messageFactoryProvider;
    @NotNull
    private final JupyterBaseSockets socketManager;
    @NotNull
    private final JupyterExecutor executor;
    @NotNull
    private final ExecutionCounter executionCounter;

    public MessageHandlerImpl(@NotNull KernelLoggerFactory loggerFactory, @NotNull ReplForJupyter repl, @NotNull CommManagerInternal commManager, @NotNull MessageFactoryProvider messageFactoryProvider, @NotNull JupyterBaseSockets socketManager2, @NotNull JupyterExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        Intrinsics.checkNotNullParameter((Object)commManager, (String)"commManager");
        Intrinsics.checkNotNullParameter((Object)messageFactoryProvider, (String)"messageFactoryProvider");
        Intrinsics.checkNotNullParameter((Object)socketManager2, (String)"socketManager");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.loggerFactory = loggerFactory;
        this.repl = repl;
        this.commManager = commManager;
        this.messageFactoryProvider = messageFactoryProvider;
        this.socketManager = socketManager2;
        this.executor = executor;
        this.executionCounter = new ExecutionCounter(1);
    }

    @NotNull
    public final ReplForJupyter getRepl() {
        return this.repl;
    }

    @NotNull
    public MessageRequestProcessor createProcessor(@NotNull RawMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (MessageRequestProcessor)new MessageRequestProcessorImpl(message, this.messageFactoryProvider, this.socketManager, this.commManager, this.executor, this.executionCounter, this.loggerFactory, this.repl);
    }

    @Override
    public void close() {
        UtilKt.closeIfPossible(this.repl);
    }
}

