/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import ch.qos.logback.classic.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.LoggingManager;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplCompilerException;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionCounter;
import org.jetbrains.kotlinx.jupyter.messaging.IdeCompatibleMessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteReply;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterBaseSockets;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketBase;
import org.jetbrains.kotlinx.jupyter.repl.CheckCompletenessResult;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.impl.ReplForJupyterImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/MessageRequestProcessorImpl;", "Lorg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor;", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "rawIncomingMessage", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "messageFactoryProvider", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;", "commManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "executor", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "executionCounter", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "repl", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;)V", "processIsCompleteRequest", "", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/IsCompleteRequest;", "kotlin-jupyter-kernel"})
public class MessageRequestProcessorImpl
extends IdeCompatibleMessageRequestProcessor
implements JupyterCommunicationFacility {
    public MessageRequestProcessorImpl(@NotNull RawMessage rawIncomingMessage, @NotNull MessageFactoryProvider messageFactoryProvider, @NotNull JupyterBaseSockets socketManager2, @NotNull CommManagerInternal commManager, @NotNull JupyterExecutor executor, @NotNull ExecutionCounter executionCounter, @NotNull KernelLoggerFactory loggerFactory, @NotNull ReplForJupyter repl) {
        Intrinsics.checkNotNullParameter((Object)rawIncomingMessage, (String)"rawIncomingMessage");
        Intrinsics.checkNotNullParameter((Object)messageFactoryProvider, (String)"messageFactoryProvider");
        Intrinsics.checkNotNullParameter((Object)socketManager2, (String)"socketManager");
        Intrinsics.checkNotNullParameter((Object)commManager, (String)"commManager");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)executionCounter, (String)"executionCounter");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        super(rawIncomingMessage, messageFactoryProvider, socketManager2, commManager, executor, executionCounter, loggerFactory, repl);
    }

    protected void processIsCompleteRequest(@NotNull IsCompleteRequest content) {
        String string;
        LoggingManager loggingManager;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ReplForJupyter replForJupyter = this.getRepl();
        ReplForJupyterImpl replForJupyterImpl = replForJupyter instanceof ReplForJupyterImpl ? (ReplForJupyterImpl)replForJupyter : null;
        LoggingManager loggingManager2 = loggingManager = replForJupyterImpl != null ? replForJupyterImpl.getLoggingManager() : null;
        if (loggingManager != null && !Intrinsics.areEqual((Object)loggingManager.mainLoggerLevel(), (Object)Level.OFF)) {
            loggingManager.disableLogging();
        }
        if (CommandsUtilKt.looksLikeReplCommand((String)content.getCode())) {
            string = "complete";
        } else {
            String result2;
            String string2;
            try {
                CheckCompletenessResult check = this.getRepl().checkComplete(content.getCode());
                string2 = check.isComplete() ? "complete" : "incomplete";
            }
            catch (ReplCompilerException ex) {
                string2 = "invalid";
            }
            string = result2 = string2;
        }
        String resStr = string;
        JupyterConnectionInternalKt.sendMessage((JupyterSocketBase)this.getSocketManager().getShell(), (Message)MessageFactoryKt.makeReplyMessage$default((MessageFactory)this.getMessageFactory(), (MessageType)MessageType.IS_COMPLETE_REPLY, null, null, null, null, (MessageContent)((MessageContent)new IsCompleteReply(resStr, null, 2, null)), (int)30, null));
    }
}

