/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.repl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import jupyter.kotlin.KotlinContext;
import jupyter.kotlin.KotlinFunctionInfo;
import jupyter.kotlin.KotlinVariableInfo;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.script.experimental.jvm.BasicJvmReplEvaluator;
import kotlin.script.experimental.jvm.KJvmEvaluatedSnippet;
import kotlin.script.experimental.util.LinkedSnippet;
import kotlin.script.experimental.util.LinkedSnippetImpl;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ#\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/ContextUpdater;", "", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "context", "Ljupyter/kotlin/KotlinContext;", "evaluator", "Lkotlin/script/experimental/jvm/BasicJvmReplEvaluator;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Ljupyter/kotlin/KotlinContext;Lkotlin/script/experimental/jvm/BasicJvmReplEvaluator;)V", "getContext", "()Ljupyter/kotlin/KotlinContext;", "lastProcessedSnippet", "Lkotlin/script/experimental/util/LinkedSnippet;", "Lkotlin/script/experimental/jvm/KJvmEvaluatedSnippet;", "logger", "Lorg/slf4j/Logger;", "findVariables", "", "fields", "", "Ljava/lang/reflect/Field;", "o", "([Ljava/lang/reflect/Field;Ljava/lang/Object;)V", "refreshMethods", "lines", "", "refreshVariables", "update", "Companion", "kotlin-jupyter-kernel"})
public final class ContextUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinContext context;
    @NotNull
    private final BasicJvmReplEvaluator evaluator;
    @NotNull
    private final Logger logger;
    @Nullable
    private LinkedSnippet<KJvmEvaluatedSnippet> lastProcessedSnippet;
    @NotNull
    private static final HashSet<Method> objectMethods;

    public ContextUpdater(@NotNull KernelLoggerFactory loggerFactory, @NotNull KotlinContext context, @NotNull BasicJvmReplEvaluator evaluator2) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)evaluator2, (String)"evaluator");
        this.context = context;
        this.evaluator = evaluator2;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
    }

    @NotNull
    public final KotlinContext getContext() {
        return this.context;
    }

    public final void update() {
        try {
            List newSnippets = new ArrayList();
            for (LinkedSnippetImpl lastSnippet = this.evaluator.getLastEvaluatedSnippet(); !Intrinsics.areEqual((Object)lastSnippet, this.lastProcessedSnippet) && lastSnippet != null; lastSnippet = lastSnippet.getPrevious()) {
                Object line = ((KJvmEvaluatedSnippet)lastSnippet.get()).getResult().getScriptInstance();
                if (line == null) continue;
                newSnippets.add(line);
            }
            CollectionsKt.reverse((List)newSnippets);
            this.refreshVariables(newSnippets);
            this.refreshMethods(newSnippets);
            this.lastProcessedSnippet = (LinkedSnippet)this.evaluator.getLastEvaluatedSnippet();
        }
        catch (ReflectiveOperationException e) {
            this.logger.error("Exception updating current variables", (Throwable)e);
        }
        catch (NullPointerException e) {
            this.logger.error("Exception updating current variables", (Throwable)e);
        }
    }

    private final void refreshMethods(List<? extends Object> lines) {
        for (Object object : lines) {
            Method[] methods = object.getClass().getMethods();
            Intrinsics.checkNotNull((Object)methods);
            for (Method method : methods) {
                KFunction function;
                if (objectMethods.contains(method) || Intrinsics.areEqual((Object)method.getName(), (Object)"main")) continue;
                Intrinsics.checkNotNull((Object)method);
                if (ReflectJvmMapping.getKotlinFunction((Method)method) == null) continue;
                this.context.addFunction(function.getName(), new KotlinFunctionInfo(function, object));
            }
        }
    }

    private final void refreshVariables(List<? extends Object> lines) throws ReflectiveOperationException {
        for (Object object : lines) {
            Field[] fields = object.getClass().getDeclaredFields();
            Intrinsics.checkNotNull((Object)fields);
            this.findVariables(fields, object);
        }
    }

    private final void findVariables(Field[] fields, Object o) throws IllegalAccessException {
        for (Field field : fields) {
            String fieldName = field.getName();
            Intrinsics.checkNotNull((Object)fieldName);
            if (StringsKt.contains$default((CharSequence)fieldName, (CharSequence)"$$implicitReceiver", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fieldName, (CharSequence)"script$", (boolean)false, (int)2, null)) continue;
            field.setAccessible(true);
            Object value = field.get(o);
            this.context.addVariable(fieldName, new KotlinVariableInfo(value, ReflectJvmMapping.getKotlinProperty((Field)field), field, o));
        }
    }

    static {
        Method[] methodArray = Object.class.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Method[] methodArray2 = methodArray;
        objectMethods = new HashSet(CollectionsKt.listOf((Object[])Arrays.copyOf(methodArray2, methodArray2.length)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R.\u0010\u0003\u001a\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004j\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/ContextUpdater$Companion;", "", "()V", "objectMethods", "Ljava/util/HashSet;", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashSet;", "kotlin-jupyter-kernel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

