/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.repl.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.jvm.impl.KJvmCompiledModule;
import kotlin.script.experimental.jvm.impl.KJvmCompiledModuleInMemory;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/impl/ClassWriter;", "", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "_outputDir", "", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "outputDir", "Ljava/nio/file/Path;", "getOutputDir", "()Ljava/nio/file/Path;", "writeClass", "", "classBytes", "", "path", "writeClasses", "code", "Lkotlin/script/experimental/api/SourceCode;", "classes", "Lkotlin/script/experimental/jvm/impl/KJvmCompiledScript;", "kotlin-jupyter-kernel"})
@SourceDebugExtension(value={"SMAP\nClassWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassWriter.kt\norg/jetbrains/kotlinx/jupyter/repl/impl/ClassWriter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n215#2,2:75\n*S KotlinDebug\n*F\n+ 1 ClassWriter.kt\norg/jetbrains/kotlinx/jupyter/repl/impl/ClassWriter\n*L\n46#1:75,2\n*E\n"})
public final class ClassWriter {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Path outputDir;

    public ClassWriter(@NotNull KernelLoggerFactory loggerFactory, @NotNull String _outputDir) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)_outputDir, (String)"_outputDir");
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        if (Intrinsics.areEqual((Object)_outputDir, (Object)"")) {
            Path tempDir = Files.createTempDirectory("kotlin-jupyter", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Path path2 = tempDir.toAbsolutePath();
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        } else {
            Path path3 = Paths.get(_outputDir, new String[0]);
            Intrinsics.checkNotNull((Object)path3);
            path = path3;
        }
        this.outputDir = path;
        this.logger.info("Created ClassWriter with path <" + this.outputDir + ">");
    }

    public /* synthetic */ ClassWriter(KernelLoggerFactory kernelLoggerFactory, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(kernelLoggerFactory, string);
    }

    @NotNull
    public final Path getOutputDir() {
        return this.outputDir;
    }

    public final void writeClasses(@NotNull SourceCode code, @NotNull KJvmCompiledScript classes) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)classes, (String)"classes");
        try {
            KJvmCompiledModule kJvmCompiledModule = classes.getCompiledModule();
            Intrinsics.checkNotNull((Object)kJvmCompiledModule, (String)"null cannot be cast to non-null type kotlin.script.experimental.jvm.impl.KJvmCompiledModuleInMemory");
            KJvmCompiledModuleInMemory moduleInMemory = (KJvmCompiledModuleInMemory)kJvmCompiledModule;
            Map $this$forEach$iv = moduleInMemory.getCompilerOutputFiles();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                byte[] bytes = (byte[])entry.getValue();
                if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"class", (boolean)false, (int)2, null)) continue;
                Path path = this.outputDir.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                this.writeClass(bytes, path);
            }
        }
        catch (ClassCastException e) {
            this.logger.info("Compiled line " + code.getName() + " has no in-memory modules");
        }
        catch (NullPointerException e) {
            this.logger.info("Compiled line " + code.getName() + " has no in-memory modules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeClass(byte[] classBytes, Path path) {
        try {
            Closeable closeable = new FileOutputStream(((Object)path.toAbsolutePath()).toString());
            Throwable throwable = null;
            try {
                FileOutputStream fos = (FileOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedOutputStream(fos);
                Throwable throwable2 = null;
                try {
                    BufferedOutputStream out = (BufferedOutputStream)closeable2;
                    boolean bl2 = false;
                    out.write(classBytes);
                    out.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }
}

