/*
 * Decompiled with CFR 0.152.
 */
package jupyter.kotlin;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.MimeTypedResult;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.api.VariableState;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001a\u0010\n\u001a\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u001a\u001c\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"varsTableStyleClass", "", "variablesReport", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "getVariablesReport", "(Lorg/jetbrains/kotlinx/jupyter/api/Notebook;)Ljava/lang/String;", "variablesReportAsHTML", "Lorg/jetbrains/kotlinx/jupyter/api/MimeTypedResult;", "getVariablesReportAsHTML", "(Lorg/jetbrains/kotlinx/jupyter/api/Notebook;)Lorg/jetbrains/kotlinx/jupyter/api/MimeTypedResult;", "generateHTMLVarsReport", "variablesState", "", "Lorg/jetbrains/kotlinx/jupyter/api/VariableState;", "generateStyleSection", "borderPx", "", "paddingPx", "generateVarsTable", "lib"})
@SourceDebugExtension(value={"SMAP\nvariablesReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 variablesReport.kt\njupyter/kotlin/VariablesReportKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n215#2,2:84\n1855#3,2:86\n*S KotlinDebug\n*F\n+ 1 variablesReport.kt\njupyter/kotlin/VariablesReportKt\n*L\n19#1:84,2\n69#1:86,2\n*E\n"})
public final class VariablesReportKt {
    @NotNull
    public static final String varsTableStyleClass = "variables_table";

    @NotNull
    public static final MimeTypedResult getVariablesReportAsHTML(@NotNull Notebook $this$variablesReportAsHTML) {
        Intrinsics.checkNotNullParameter((Object)$this$variablesReportAsHTML, (String)"<this>");
        return ResultsKt.htmlResult$default((String)VariablesReportKt.generateHTMLVarsReport($this$variablesReportAsHTML.getVariablesState()), (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String getVariablesReport(@NotNull Notebook $this$variablesReport) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$variablesReport, (String)"<this>");
        if ($this$variablesReport.getVariablesState().isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$_get_variablesReport__u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$_get_variablesReport__u24lambda_u241.append("Visible vars: \n");
            Map $this$forEach$iv = $this$variablesReport.getVariablesState();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = (String)entry.getKey();
                VariableState currentState = (VariableState)entry.getValue();
                $this$_get_variablesReport__u24lambda_u241.append('\t' + name + " : " + currentState.getStringValue() + '\n');
            }
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        }
        return string;
    }

    @NotNull
    public static final String generateHTMLVarsReport(@NotNull Map<String, ? extends VariableState> variablesState) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(variablesState, (String)"variablesState");
        StringBuilder $this$generateHTMLVarsReport_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateHTMLVarsReport_u24lambda_u242.append(VariablesReportKt.generateStyleSection$default(0, 0, 3, null));
        if (variablesState.isEmpty()) {
            $this$generateHTMLVarsReport_u24lambda_u242.append("<h2 style=\"text-align:center;\">Variables State's Empty</h2>\n");
            String string = $this$generateHTMLVarsReport_u24lambda_u242.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        $this$generateHTMLVarsReport_u24lambda_u242.append("<h2 style=\"text-align:center;\">Variables State</h2>\n");
        $this$generateHTMLVarsReport_u24lambda_u242.append(VariablesReportKt.generateVarsTable(variablesState));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String generateStyleSection(int borderPx, int paddingPx) {
        return StringsKt.trimIndent((String)("\n    <style>\n    table.variables_table, .variables_table th, .variables_table td {\n      border: " + borderPx + "px solid black;\n      border-collapse: collapse;\n      text-align:center;\n    }\n    .variables_table th, .variables_table td {\n      padding: " + paddingPx + "px;\n    }\n    </style>\n    \n    "));
    }

    static /* synthetic */ String generateStyleSection$default(int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            n2 = 5;
        }
        return VariablesReportKt.generateStyleSection(n, n2);
    }

    private static final String generateVarsTable(Map<String, ? extends VariableState> variablesState) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateVarsTable_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateVarsTable_u24lambda_u244.append("<table class=\"variables_table\" style=\"width:80%;margin-left:auto;margin-right:auto;\" align=\"center\">\n  <tr>\n    <th>Variable</th>\n    <th>Value</th>\n  </tr>\n");
        Iterable $this$forEach$iv = variablesState.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            $this$generateVarsTable_u24lambda_u244.append(StringsKt.trimIndent((String)("\n                <tr>\n                    <td>" + (String)it.getKey() + "</td>\n                    <td><pre>" + ((VariableState)it.getValue()).getStringValue() + "</pre></td>\n                </tr>\n                ")));
        }
        $this$generateVarsTable_u24lambda_u244.append("\n</table>\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

