/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.config;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007\u001a\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u0014\u001a\u00020\u0007\u001a\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f*\u00020\u0007\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0005\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"currentKernelVersion", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "getCurrentKernelVersion", "()Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "currentKernelVersion$delegate", "Lkotlin/Lazy;", "currentKotlinVersion", "", "getCurrentKotlinVersion", "()Ljava/lang/String;", "currentKotlinVersion$delegate", "runtimeProperties", "", "getRuntimeProperties", "()Ljava/util/Map;", "runtimeProperties$delegate", "getFromRuntimeProperties", "property", "propertyDescription", "readResourceAsIniFile", "fileName", "classLoader", "Ljava/lang/ClassLoader;", "parseIniConfig", "shared-compiler"})
public final class RuntimePropertiesKt {
    @NotNull
    private static final Lazy runtimeProperties$delegate = LazyKt.lazy((Function0)runtimeProperties.2.INSTANCE);
    @NotNull
    private static final Lazy currentKernelVersion$delegate = LazyKt.lazy((Function0)currentKernelVersion.2.INSTANCE);
    @NotNull
    private static final Lazy currentKotlinVersion$delegate = LazyKt.lazy((Function0)currentKotlinVersion.2.INSTANCE);

    @NotNull
    public static final Map<String, String> parseIniConfig(@NotNull String $this$parseIniConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$parseIniConfig, (String)"<this>");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)$this$parseIniConfig), (Function1)parseIniConfig.1.INSTANCE), (Function1)parseIniConfig.2.INSTANCE), (Function1)parseIniConfig.3.INSTANCE));
    }

    @NotNull
    public static final Map<String, String> readResourceAsIniFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getSystemClassLoader()");
        return RuntimePropertiesKt.readResourceAsIniFile(fileName, classLoader);
    }

    @NotNull
    public static final Map<String, String> readResourceAsIniFile(@NotNull String fileName, @NotNull ClassLoader classLoader) {
        Map<String, String> map;
        Map<String, String> map2;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        URL uRL = classLoader.getResource(fileName);
        if (uRL == null) {
            map2 = null;
        } else {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            String string = new String(byArray, charset);
            map2 = map = RuntimePropertiesKt.parseIniConfig(string);
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private static final Map<String, String> getRuntimeProperties() {
        Lazy lazy = runtimeProperties$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public static final String getFromRuntimeProperties(@NotNull String property, @NotNull String propertyDescription) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)propertyDescription, (String)"propertyDescription");
        String string = RuntimePropertiesKt.getRuntimeProperties().get(property);
        if (string == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Compiler artifact should contain ", (Object)propertyDescription).toString());
        }
        return string;
    }

    @NotNull
    public static final KotlinKernelVersion getCurrentKernelVersion() {
        Lazy lazy = currentKernelVersion$delegate;
        return (KotlinKernelVersion)lazy.getValue();
    }

    @NotNull
    public static final String getCurrentKotlinVersion() {
        Lazy lazy = currentKotlinVersion$delegate;
        return (String)lazy.getValue();
    }
}

