/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.execution;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.exceptions.UtilKt;
import org.jetbrains.kotlinx.jupyter.execution.ExecutionResult;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J6\u0010\u0015\u001a\u00020\u00132'\u0010\u0016\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0017\u00a2\u0006\u0002\b\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ8\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\b\b\u0000\u0010\u001e*\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001e0$H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0011R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl;", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "executionInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "executorIsShuttingDown", "", "executorThread", "Ljava/lang/Thread;", "logger", "Lorg/slf4j/Logger;", "tasksQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl$Task;", "close", "", "interruptExecution", "launchJob", "runnable", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "runExecution", "Lorg/jetbrains/kotlinx/jupyter/execution/ExecutionResult;", "T", "name", "", "classLoader", "Ljava/lang/ClassLoader;", "body", "Lkotlin/Function0;", "Companion", "Task", "shared-compiler"})
public final class JupyterExecutorImpl
implements JupyterExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayBlockingQueue<Task<?>> tasksQueue;
    @NotNull
    private final AtomicBoolean executionInProgress;
    private boolean executorIsShuttingDown;
    @NotNull
    private final Thread executorThread;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final String IDLE_EXECUTOR_NAME = "<idle>";
    private static final int MAX_QUEUED_TASKS = 256;

    public JupyterExecutorImpl(@NotNull KernelLoggerFactory loggerFactory2) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory2, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.tasksQueue = new ArrayBlockingQueue(256);
        this.executionInProgress = new AtomicBoolean(false);
        this.executorThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)IDLE_EXECUTOR_NAME, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ JupyterExecutorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    while (!JupyterExecutorImpl.access$getExecutorIsShuttingDown$p(this.this$0)) {
                        ((Task)JupyterExecutorImpl.access$getTasksQueue$p(this.this$0).take()).execute();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }), (int)23, null);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }

    @Override
    @NotNull
    public <T> ExecutionResult<T> runExecution(@NotNull String name, @Nullable ClassLoader classLoader, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader classLoader3 = classLoader2;
        Intrinsics.checkNotNull((Object)classLoader3);
        Task<T> task = new Task<T>(name, classLoader3, body);
        this.tasksQueue.put(task);
        return task.join();
    }

    @Override
    public void interruptExecution() {
        this.logger.info("Stopping execution...");
        if (this.executionInProgress.get()) {
            Thread execution = this.executorThread;
            String executionName = execution.getName();
            this.logger.info("Stopping " + executionName + "...");
            execution.interrupt();
            this.logger.info(executionName + " interrupted");
            Thread.sleep(100L);
            if (Intrinsics.areEqual((Object)execution.getName(), (Object)executionName)) {
                try {
                    execution.stop();
                    this.logger.info(executionName + " stopped");
                }
                catch (UnsupportedOperationException e) {
                    this.logger.warn("We tried to stop " + executionName + " thread, but it's not supported in the current version of JRE", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void launchJob(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, runnable, (int)3, null);
    }

    @Override
    public void close() {
        this.tasksQueue.clear();
        this.executorIsShuttingDown = true;
        this.interruptExecution();
        this.executorThread.interrupt();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, (String)"Jupyter executor was shut down", null, (int)2, null);
    }

    public static final /* synthetic */ boolean access$getExecutorIsShuttingDown$p(JupyterExecutorImpl $this) {
        return $this.executorIsShuttingDown;
    }

    public static final /* synthetic */ ArrayBlockingQueue access$getTasksQueue$p(JupyterExecutorImpl $this) {
        return $this.tasksQueue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl$Companion;", "", "()V", "IDLE_EXECUTOR_NAME", "", "MAX_QUEUED_TASKS", "", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl$Task;", "T", "", "name", "", "classLoader", "Ljava/lang/ClassLoader;", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function0;)V", "resultFuture", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/kotlinx/jupyter/execution/ExecutionResult;", "execute", "", "join", "shared-compiler"})
    private final class Task<T> {
        @NotNull
        private final String name;
        @NotNull
        private final ClassLoader classLoader;
        @NotNull
        private final Function0<T> body;
        @NotNull
        private final CompletableFuture<ExecutionResult<T>> resultFuture;

        public Task(@NotNull String name, @NotNull ClassLoader classLoader, Function0<? extends T> body) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            Intrinsics.checkNotNullParameter(body, (String)"body");
            this.name = name;
            this.classLoader = classLoader;
            this.body = body;
            this.resultFuture = new CompletableFuture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() {
            ExecutionResult executionResult;
            Object object;
            if (!(!this.resultFuture.isDone())) {
                boolean $i$a$-require-JupyterExecutorImpl$Task$execute$22 = false;
                String $i$a$-require-JupyterExecutorImpl$Task$execute$22 = "Task " + this.name + " was already executed";
                throw new IllegalArgumentException($i$a$-require-JupyterExecutorImpl$Task$execute$22.toString());
            }
            Thread myThread = Thread.currentThread();
            myThread.setName(this.name);
            myThread.setContextClassLoader(this.classLoader);
            Throwable execException = null;
            try {
                JupyterExecutorImpl.this.executionInProgress.set(true);
                object = this.body.invoke();
            }
            catch (Throwable e) {
                execException = e;
                object = null;
            }
            finally {
                myThread.setName(JupyterExecutorImpl.IDLE_EXECUTOR_NAME);
                JupyterExecutorImpl.this.executionInProgress.set(false);
                if (Thread.interrupted()) {
                    JupyterExecutorImpl.this.logger.info("Clearing interrupted status");
                }
            }
            Object execRes = object;
            Throwable exception = execException;
            if (exception == null) {
                Object object2 = execRes;
                Intrinsics.checkNotNull((Object)object2);
                executionResult = new ExecutionResult.Success<Object>(object2);
            } else {
                executionResult = UtilKt.isInterruptedException(exception) ? (ExecutionResult)ExecutionResult.Interrupted.INSTANCE : (ExecutionResult)new ExecutionResult.Failure(exception);
            }
            ExecutionResult result2 = executionResult;
            this.resultFuture.complete(result2);
        }

        @NotNull
        public final ExecutionResult<T> join() {
            ExecutionResult<T> executionResult = this.resultFuture.join();
            Intrinsics.checkNotNullExpressionValue(executionResult, (String)"join(...)");
            return executionResult;
        }
    }
}

