/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResource;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceFallbacksBundle;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceLocation;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourcePathType;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.ResourcesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/CssLibraryResourcesProcessor;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResourcesProcessor;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "(Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;)V", "loadCssAsText", "", "bundle", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourceFallbacksBundle;", "classLoader", "Ljava/lang/ClassLoader;", "wrapLibrary", "resource", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResource;", "shared-compiler"})
public final class CssLibraryResourcesProcessor
implements LibraryResourcesProcessor {
    @NotNull
    private final HttpClient httpClient;

    public CssLibraryResourcesProcessor(@NotNull HttpClient httpClient2) {
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        this.httpClient = httpClient2;
    }

    private final String loadCssAsText(ResourceFallbacksBundle bundle, ClassLoader classLoader) {
        List exceptions = new ArrayList();
        for (ResourceLocation resourceLocation : bundle.getLocations()) {
            String string;
            String path = resourceLocation.getPath();
            try {
                String string2;
                switch (WhenMappings.$EnumSwitchMapping$0[resourceLocation.getType().ordinal()]) {
                    case 1: {
                        string2 = StringsKt.trimIndent((String)("\n                        <link rel=\"stylesheet\" href=\"" + path + "\">\n                        "));
                        break;
                    }
                    case 2: {
                        string2 = CssLibraryResourcesProcessor.loadCssAsText$wrapInTag(HttpUtilKt.getHttp((HttpClient)this.httpClient, (String)path).getText());
                        break;
                    }
                    case 3: {
                        string2 = CssLibraryResourcesProcessor.loadCssAsText$wrapInTag(FilesKt.readText$default((File)new File(path), null, (int)1, null));
                        break;
                    }
                    case 4: {
                        string2 = CssLibraryResourcesProcessor.loadCssAsText$wrapInTag(ResourcesKt.loadResourceFromClassLoader(path, classLoader));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                string = string2;
            }
            catch (IOException e) {
                exceptions.add(e);
                continue;
            }
            return string;
        }
        throw new Exception("No resource fallback found! Related exceptions: " + exceptions);
    }

    @Override
    @NotNull
    public String wrapLibrary(@NotNull LibraryResource resource, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return CollectionsKt.joinToString$default((Iterable)resource.getBundles(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<ResourceFallbacksBundle, CharSequence>(this, classLoader){
            final /* synthetic */ CssLibraryResourcesProcessor this$0;
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.this$0 = $receiver;
                this.$classLoader = $classLoader;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ResourceFallbacksBundle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CssLibraryResourcesProcessor.access$loadCssAsText(this.this$0, it, this.$classLoader);
            }
        }), (int)30, null);
    }

    private static final String loadCssAsText$wrapInTag(String text) {
        return StringsKt.trimIndent((String)("\n                <style>\n                " + text + "\n                </style>\n                "));
    }

    public static final /* synthetic */ String access$loadCssAsText(CssLibraryResourcesProcessor $this, ResourceFallbacksBundle bundle, ClassLoader classLoader) {
        return $this.loadCssAsText(bundle, classLoader);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourcePathType.values().length];
            try {
                nArray[ResourcePathType.URL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.URL_EMBEDDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.LOCAL_PATH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.CLASSPATH_PATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

