/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.Brackets;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryInfoCache;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryReferenceParser;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryReferenceParserImpl;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolutionInfoParser;
import org.jetbrains.kotlinx.jupyter.libraries.Parameter;
import org.jetbrains.kotlinx.jupyter.libraries.UtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParserImpl;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParser;", "libraryInfoCache", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;)V", "defaultParsers", "", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolutionInfoParser;", "parseLibraryReference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "string", "parseReferenceWithArgs", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "parseResolutionInfo", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibraryReferenceParserImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryReferenceParserImpl.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParserImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1194#2,2:55\n1222#2,4:57\n766#2:61\n857#2,2:62\n*S KotlinDebug\n*F\n+ 1 LibraryReferenceParserImpl.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParserImpl\n*L\n52#1:55,2\n52#1:57,4\n13#1:61\n13#1:62,2\n*E\n"})
public final class LibraryReferenceParserImpl
implements LibraryReferenceParser {
    @NotNull
    private final LibraryInfoCache libraryInfoCache;
    @NotNull
    private final Map<String, LibraryResolutionInfoParser> defaultParsers;

    /*
     * WARNING - void declaration
     */
    public LibraryReferenceParserImpl(@NotNull LibraryInfoCache libraryInfoCache2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)libraryInfoCache2, (String)"libraryInfoCache");
        this.libraryInfoCache = libraryInfoCache2;
        Object object = new LibraryResolutionInfoParser[]{LibraryResolutionInfoParser.Companion.make("ref", CollectionsKt.listOf((Object)new Parameter.Required("ref")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)new Function1<Map<String, ? extends String>, LibraryResolutionInfo>(this){
            final /* synthetic */ LibraryReferenceParserImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LibraryResolutionInfo invoke(@NotNull Map<String, String> args) {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                String string = args.get("ref");
                if (string == null) {
                    throw new IllegalStateException("Argument 'ref' should be specified".toString());
                }
                return LibraryReferenceParserImpl.access$getLibraryInfoCache$p(this.this$0).getLibraryInfoByRef(string);
            }
        })), LibraryResolutionInfoParser.Companion.make("file", CollectionsKt.listOf((Object)new Parameter.Required("path")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)defaultParsers.2.INSTANCE)), LibraryResolutionInfoParser.Companion.make("dir", CollectionsKt.listOf((Object)new Parameter.Required("dir")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)defaultParsers.3.INSTANCE)), LibraryResolutionInfoParser.Companion.make("url", CollectionsKt.listOf((Object)new Parameter.Required("url")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)defaultParsers.4.INSTANCE)), LibraryResolutionInfoParser.Companion.make("classpath", CollectionsKt.emptyList(), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)defaultParsers.5.INSTANCE))};
        object = CollectionsKt.listOf((Object[])object);
        LibraryReferenceParserImpl libraryReferenceParserImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LibraryResolutionInfoParser libraryResolutionInfoParser = (LibraryResolutionInfoParser)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        libraryReferenceParserImpl.defaultParsers = destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<LibraryReference, List<Variable>> parseReferenceWithArgs(@NotNull String string) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Pair<String, List<Variable>> pair = UtilKt.parseLibraryName(string);
        String fullName = (String)pair.component1();
        List vars = (List)pair.component2();
        LibraryReference reference = this.parseLibraryReference(fullName);
        Iterable $this$filter$iv = vars;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Variable it = (Variable)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it.getName()) || !StringsKt.isBlank((CharSequence)it.getValue());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List processedVars = (List)destination$iv$iv;
        return TuplesKt.to((Object)reference, (Object)processedVars);
    }

    @Override
    @NotNull
    public LibraryReference parseLibraryReference(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int sepIndex = StringsKt.indexOf$default((CharSequence)string, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (sepIndex == -1) {
            return new LibraryReference((LibraryResolutionInfo)new AbstractLibraryResolutionInfo.Default(null, 1, null), string);
        }
        String string2 = string.substring(0, sepIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String nameString = string2;
        String string3 = string.substring(sepIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String infoString = string3;
        LibraryResolutionInfo info = this.parseResolutionInfo(infoString);
        return new LibraryReference(info, nameString);
    }

    private final LibraryResolutionInfo parseResolutionInfo(String string) {
        if (StringsKt.isBlank((CharSequence)string)) {
            return new AbstractLibraryResolutionInfo.Default(null, 1, null);
        }
        Pair<String, List<Variable>> pair = UtilKt.parseCall(string, Brackets.Companion.getSQUARE());
        String type = (String)pair.component1();
        List vars = (List)pair.component2();
        LibraryResolutionInfoParser libraryResolutionInfoParser = this.defaultParsers.get(type);
        if (libraryResolutionInfoParser == null || (libraryResolutionInfoParser = libraryResolutionInfoParser.getInfo(vars)) == null) {
            libraryResolutionInfoParser = new AbstractLibraryResolutionInfo.Default(type);
        }
        return libraryResolutionInfoParser;
    }

    public static final /* synthetic */ LibraryInfoCache access$getLibraryInfoCache$p(LibraryReferenceParserImpl $this) {
        return $this.libraryInfoCache;
    }
}

