/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.jetbrains.kotlinx.jupyter.common.Status;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtil;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "fallback", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "httpUtil", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;)V", "getFallback", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "setFallback", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;)V", "logger", "Lorg/slf4j/Logger;", "get", "string", "", "tryGetAsDir", "dirName", "tryGetAsFile", "fileName", "tryGetAsRef", "ref", "tryGetAsURL", "url", "shared-compiler"})
public final class StandardResolutionInfoProvider
implements ResolutionInfoProvider {
    @NotNull
    private LibraryResolutionInfo fallback;
    @NotNull
    private final LibraryHttpUtil httpUtil;
    @NotNull
    private final Logger logger;

    public StandardResolutionInfoProvider(@NotNull KernelLoggerFactory loggerFactory2, @NotNull LibraryResolutionInfo fallback, @NotNull LibraryHttpUtil httpUtil) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        Intrinsics.checkNotNullParameter((Object)httpUtil, (String)"httpUtil");
        this.fallback = fallback;
        this.httpUtil = httpUtil;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory2, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
    }

    @Override
    @NotNull
    public LibraryResolutionInfo getFallback() {
        return this.fallback;
    }

    @Override
    public void setFallback(@NotNull LibraryResolutionInfo libraryResolutionInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryResolutionInfo, (String)"<set-?>");
        this.fallback = libraryResolutionInfo;
    }

    @Override
    @NotNull
    public LibraryResolutionInfo get(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (((CharSequence)string).length() == 0) {
            return this.getFallback();
        }
        LibraryResolutionInfo libraryResolutionInfo = this.tryGetAsRef(string);
        if (libraryResolutionInfo == null && (libraryResolutionInfo = this.tryGetAsDir(string)) == null && (libraryResolutionInfo = this.tryGetAsFile(string)) == null && (libraryResolutionInfo = this.tryGetAsURL(string)) == null) {
            libraryResolutionInfo = this.getFallback();
        }
        return libraryResolutionInfo;
    }

    private final LibraryResolutionInfo tryGetAsRef(String ref) {
        return this.httpUtil.getLibraryDescriptorsManager().checkRefExistence(ref) ? (LibraryResolutionInfo)this.httpUtil.getLibraryInfoCache().getLibraryInfoByRef(ref) : null;
    }

    private final LibraryResolutionInfo tryGetAsDir(String dirName) {
        File file = new File(dirName);
        return file.isDirectory() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByDir(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsFile(String fileName) {
        File file = new File(fileName);
        return file.isFile() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByFile(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsURL(String url) {
        ResponseWrapper responseWrapper;
        try {
            responseWrapper = HttpUtilKt.getHttp((HttpClient)this.httpUtil.getHttpClient(), (String)url);
        }
        catch (Throwable e) {
            this.logger.warn("Unable to load library by URL " + url, e);
            return null;
        }
        ResponseWrapper response2 = responseWrapper;
        return ResponseKt.getSuccessful((Status)response2.getStatus()) ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByURL(new URL(url)) : null;
    }
}

