/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.repl.creating;

import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.KernelRunMode;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommManager;
import org.jetbrains.kotlinx.jupyter.api.outputs.DisplayHandler;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtil;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryInfoCache;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryReferenceParser;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.SocketDisplayHandler;
import org.jetbrains.kotlinx.jupyter.repl.MavenRepositoryCoordinates;
import org.jetbrains.kotlinx.jupyter.repl.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.repl.config.DefaultReplSettings;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplComponentsProviderBase;
import org.jetbrains.kotlinx.jupyter.repl.embedded.InMemoryReplResultsHolder;
import org.jetbrains.kotlinx.jupyter.util.StringUtilKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u001f00H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020800H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/creating/DefaultReplComponentsProvider;", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/ReplComponentsProviderBase;", "_settings", "Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;", "_communicationFacility", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "_commManager", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;", "_inMemoryResultsHolder", "Lorg/jetbrains/kotlinx/jupyter/repl/embedded/InMemoryReplResultsHolder;", "(Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;Lorg/jetbrains/kotlinx/jupyter/repl/embedded/InMemoryReplResultsHolder;)V", "httpUtil", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "getHttpUtil", "()Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "provideCommManager", "provideCommunicationFacility", "provideDebugPort", "", "()Ljava/lang/Integer;", "provideDisplayHandler", "Lorg/jetbrains/kotlinx/jupyter/api/outputs/DisplayHandler;", "provideExplicitClientType", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "provideHomeDir", "Ljava/io/File;", "provideHttpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "provideInMemoryReplResultsHolder", "provideKernelRunMode", "Lorg/jetbrains/kotlinx/jupyter/api/KernelRunMode;", "provideLibraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "provideLibraryInfoCache", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;", "provideLibraryReferenceParser", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParser;", "provideLibraryResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "provideLoggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "provideMavenRepositories", "", "Lorg/jetbrains/kotlinx/jupyter/repl/MavenRepositoryCoordinates;", "provideResolutionInfoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "provideRuntimeProperties", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplRuntimeProperties;", "provideScriptClasspath", "provideScriptReceivers", "", "shared-compiler"})
public class DefaultReplComponentsProvider
extends ReplComponentsProviderBase {
    @NotNull
    private final DefaultReplSettings _settings;
    @NotNull
    private final JupyterCommunicationFacility _communicationFacility;
    @NotNull
    private final CommManager _commManager;
    @NotNull
    private final InMemoryReplResultsHolder _inMemoryResultsHolder;
    @NotNull
    private final Lazy logger$delegate;

    public DefaultReplComponentsProvider(@NotNull DefaultReplSettings _settings, @NotNull JupyterCommunicationFacility _communicationFacility, @NotNull CommManager _commManager, @NotNull InMemoryReplResultsHolder _inMemoryResultsHolder) {
        Intrinsics.checkNotNullParameter((Object)_settings, (String)"_settings");
        Intrinsics.checkNotNullParameter((Object)_communicationFacility, (String)"_communicationFacility");
        Intrinsics.checkNotNullParameter((Object)_commManager, (String)"_commManager");
        Intrinsics.checkNotNullParameter((Object)_inMemoryResultsHolder, (String)"_inMemoryResultsHolder");
        this._settings = _settings;
        this._communicationFacility = _communicationFacility;
        this._commManager = _commManager;
        this._inMemoryResultsHolder = _inMemoryResultsHolder;
        this.logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ DefaultReplComponentsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Logger invoke() {
                return KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)this.this$0.getLoggerFactory(), (KClass)Reflection.getOrCreateKotlinClass(this.this$0.getClass()));
            }
        }));
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    @Override
    @NotNull
    public KernelLoggerFactory provideLoggerFactory() {
        return this._settings.getLoggerFactory();
    }

    @Override
    @NotNull
    public ResolutionInfoProvider provideResolutionInfoProvider() {
        return this._settings.getReplConfig().getResolutionInfoProvider();
    }

    @Override
    @NotNull
    public DisplayHandler provideDisplayHandler() {
        return new SocketDisplayHandler(this._communicationFacility, this.getNotebook());
    }

    @Override
    @NotNull
    public List<File> provideScriptClasspath() {
        return this._settings.getKernelConfig().getScriptClasspath();
    }

    @Override
    @Nullable
    public File provideHomeDir() {
        return this._settings.getKernelConfig().getHomeDir();
    }

    @Override
    @NotNull
    public List<MavenRepositoryCoordinates> provideMavenRepositories() {
        return this._settings.getReplConfig().getMavenRepositories();
    }

    @Override
    @Nullable
    public LibraryResolver provideLibraryResolver() {
        return this._settings.getReplConfig().getLibraryResolver();
    }

    @Override
    @NotNull
    public ReplRuntimeProperties provideRuntimeProperties() {
        return this._settings.getRuntimeProperties();
    }

    @Override
    @NotNull
    public List<Object> provideScriptReceivers() {
        return this._settings.getReplConfig().getScriptReceivers();
    }

    @Override
    @NotNull
    public KernelRunMode provideKernelRunMode() {
        return this._settings.getReplConfig().getKernelRunMode();
    }

    @Override
    @NotNull
    public JupyterCommunicationFacility provideCommunicationFacility() {
        return this._communicationFacility;
    }

    @Override
    @NotNull
    public CommManager provideCommManager() {
        return this._commManager;
    }

    @Override
    @Nullable
    public Integer provideDebugPort() {
        return this._settings.getKernelConfig().getDebugPort();
    }

    @Override
    @Nullable
    public JupyterClientType provideExplicitClientType() {
        JupyterClientType jupyterClientType2;
        String string = this._settings.getKernelConfig().getClientType();
        if (string != null) {
            JupyterClientType jupyterClientType3;
            String typeName = string;
            boolean bl = false;
            try {
                jupyterClientType3 = JupyterClientType.valueOf((String)StringUtilKt.toUpperCaseAsciiOnly(typeName));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warn("Unknown client type: " + typeName);
                jupyterClientType3 = null;
            }
            jupyterClientType2 = jupyterClientType3;
        } else {
            jupyterClientType2 = null;
        }
        return jupyterClientType2;
    }

    private final LibraryHttpUtil getHttpUtil() {
        return this._settings.getReplConfig().getHttpUtil();
    }

    @Override
    @NotNull
    public HttpClient provideHttpClient() {
        return this.getHttpUtil().getHttpClient();
    }

    @Override
    @NotNull
    public LibraryDescriptorsManager provideLibraryDescriptorsManager() {
        return this.getHttpUtil().getLibraryDescriptorsManager();
    }

    @Override
    @NotNull
    public LibraryInfoCache provideLibraryInfoCache() {
        return this.getHttpUtil().getLibraryInfoCache();
    }

    @Override
    @NotNull
    public LibraryReferenceParser provideLibraryReferenceParser() {
        return this.getHttpUtil().getLibraryReferenceParser();
    }

    @Override
    @NotNull
    public InMemoryReplResultsHolder provideInMemoryReplResultsHolder() {
        return this._inMemoryResultsHolder;
    }
}

