/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.testkit;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.nulls.MatchersKt;
import io.kotest.matchers.types.TypeMatchersKt;
import java.io.File;
import java.util.List;
import jupyter.kotlin.DependsOn;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.jvm.util.JvmClasspathUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.MimeTypedResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalRequestData;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.result.EvalResultEx;
import org.jetbrains.kotlinx.jupyter.testkit.ReplProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010\u000e\u001a\u00020\n2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00012\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00012\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ(\u0010\u0010\u001a\u0002H\u0011\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0087\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\t\u001a\u00060\nj\u0002`\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/testkit/JupyterReplTestCase;", "", "replProvider", "Lorg/jetbrains/kotlinx/jupyter/testkit/ReplProvider;", "(Lorg/jetbrains/kotlinx/jupyter/testkit/ReplProvider;)V", "repl", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "execError", "", "code", "", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "execEx", "Lorg/jetbrains/kotlinx/jupyter/repl/result/EvalResultEx;", "execHtml", "execRaw", "execRendered", "T", "execTyped", "(Ljava/lang/String;)Ljava/lang/Object;", "execSuccess", "Lorg/jetbrains/kotlinx/jupyter/repl/result/EvalResultEx$Success;", "Companion", "test-kit"})
@SourceDebugExtension(value={"SMAP\nJupyterReplTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterReplTestCase.kt\norg/jetbrains/kotlinx/jupyter/testkit/JupyterReplTestCase\n+ 2 matchers.kt\nio/kotest/matchers/types/MatchersKt\n+ 3 TypeMatchers.kt\nio/kotest/matchers/types/TypeMatchersKt\n*L\n1#1,62:1\n45#1,2:84\n47#1:93\n138#2,4:63\n142#2,2:68\n138#2,4:70\n142#2,2:75\n75#2,4:77\n79#2,2:82\n75#2,4:86\n79#2,2:91\n48#3:67\n48#3:74\n39#3:81\n39#3:90\n*S KotlinDebug\n*F\n+ 1 JupyterReplTestCase.kt\norg/jetbrains/kotlinx/jupyter/testkit/JupyterReplTestCase\n*L\n51#1:84,2\n51#1:93\n25#1:63,4\n25#1:68,2\n35#1:70,4\n35#1:75,2\n46#1:77,4\n46#1:82,2\n51#1:86,4\n51#1:91,2\n25#1:67\n35#1:74\n46#1:81\n51#1:90\n*E\n"})
public abstract class JupyterReplTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplForJupyter repl;
    private static final ClassLoader currentClassLoader;
    @NotNull
    private static final List<File> scriptClasspath;

    public JupyterReplTestCase(@NotNull ReplProvider replProvider) {
        Intrinsics.checkNotNullParameter((Object)replProvider, (String)"replProvider");
        this.repl = replProvider.invoke(scriptClasspath);
    }

    public /* synthetic */ JupyterReplTestCase(ReplProvider replProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            replProvider = ReplProvider.Companion.getWithoutLibraryResolution();
        }
        this(replProvider);
    }

    @NotNull
    public final EvalResultEx execEx(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.repl.evalEx(new EvalRequestData(code, 0, false, false, 14, null));
    }

    @NotNull
    public final EvalResultEx.Success execSuccess(@NotNull String code) {
        EvalResultEx result;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        EvalResultEx $this$shouldBeTypeOf$iv = result = this.execEx(code);
        boolean $i$f$shouldBeTypeOf = false;
        boolean $i$f$beOfType = false;
        Matcher matcher$iv = TypeMatchersKt.beOfType((KClass)Reflection.getOrCreateKotlinClass(EvalResultEx.Success.class));
        ShouldKt.shouldBe((Object)$this$shouldBeTypeOf$iv, (Object)matcher$iv);
        EvalResultEx evalResultEx = $this$shouldBeTypeOf$iv;
        if (evalResultEx == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlinx.jupyter.repl.result.EvalResultEx.Success");
        }
        EvalResultEx.Success cfr_ignored_0 = (EvalResultEx.Success)evalResultEx;
        return (EvalResultEx.Success)result;
    }

    @Nullable
    public final Object execRendered(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.execSuccess(code).getRenderedValue();
    }

    @NotNull
    public final Throwable execError(@NotNull String code) {
        EvalResultEx result;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        EvalResultEx $this$shouldBeTypeOf$iv = result = this.execEx(code);
        boolean $i$f$shouldBeTypeOf = false;
        boolean $i$f$beOfType = false;
        Matcher matcher$iv = TypeMatchersKt.beOfType((KClass)Reflection.getOrCreateKotlinClass(EvalResultEx.Error.class));
        ShouldKt.shouldBe((Object)$this$shouldBeTypeOf$iv, (Object)matcher$iv);
        EvalResultEx evalResultEx = $this$shouldBeTypeOf$iv;
        if (evalResultEx == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlinx.jupyter.repl.result.EvalResultEx.Error");
        }
        EvalResultEx.Error cfr_ignored_0 = (EvalResultEx.Error)evalResultEx;
        return ((EvalResultEx.Error)result).getError();
    }

    @Nullable
    public final Object execRaw(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.execSuccess(code).getInternalResult().getResult().getValue();
    }

    @JvmName(name="execTyped")
    public final /* synthetic */ <T> T execTyped(String code) {
        Object res;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        boolean $i$f$execTyped = false;
        Object $this$shouldBeInstanceOf$iv = res = this.execRendered(code);
        boolean $i$f$shouldBeInstanceOf = false;
        boolean $i$f$beInstanceOf = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Matcher matcher$iv = TypeMatchersKt.beInstanceOf((KClass)Reflection.getOrCreateKotlinClass(Object.class));
        ShouldKt.shouldBe((Object)$this$shouldBeInstanceOf$iv, (Object)matcher$iv);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)res;
    }

    @NotNull
    public final String execHtml(@NotNull String code) {
        Object res$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        JupyterReplTestCase this_$iv = this;
        boolean $i$f$execTyped = false;
        Object $this$shouldBeInstanceOf$iv$iv = res$iv = this_$iv.execRendered(code);
        boolean $i$f$shouldBeInstanceOf = false;
        boolean $i$f$beInstanceOf = false;
        Matcher matcher$iv$iv = TypeMatchersKt.beInstanceOf((KClass)Reflection.getOrCreateKotlinClass(MimeTypedResult.class));
        ShouldKt.shouldBe((Object)$this$shouldBeInstanceOf$iv$iv, (Object)matcher$iv$iv);
        Object object = $this$shouldBeInstanceOf$iv$iv;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlinx.jupyter.api.MimeTypedResult");
        }
        MimeTypedResult cfr_ignored_0 = (MimeTypedResult)object;
        MimeTypedResult res = (MimeTypedResult)res$iv;
        String html = (String)res.get((Object)"text/html");
        MatchersKt.shouldNotBeNull((Object)html);
        return html;
    }

    public JupyterReplTestCase() {
        this(null, 1, null);
    }

    static {
        ClassLoader classLoader = currentClassLoader = DependsOn.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"currentClassLoader");
        List list = JvmClasspathUtilKt.classpathFromClassloader$default((ClassLoader)classLoader, (boolean)false, (int)2, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        scriptClasspath = list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/testkit/JupyterReplTestCase$Companion;", "", "()V", "currentClassLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "scriptClasspath", "", "Ljava/io/File;", "test-kit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

