/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.benchmark.BenchmarkConfiguration;
import kotlinx.benchmark.BenchmarkDescriptor;
import kotlinx.benchmark.ReportBenchmarkResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lkotlinx/benchmark/ReportBenchmarksStatistics;", "", "values", "", "([D)V", "size", "", "getSize", "()I", "getValues", "()[D", "max", "", "mean", "median", "min", "standardDeviation", "valueAt", "quantile", "Companion", "kotlinx-benchmark-runtime"})
public final class ReportBenchmarksStatistics {
    @NotNull
    private final double[] values;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final double[] getValues() {
        return this.values;
    }

    public final int getSize() {
        return this.values.length;
    }

    public final double valueAt(double quantile) {
        double d;
        block9: {
            block8: {
                if (quantile < 0.0 || quantile > 1.0) break block8;
                double d2 = quantile;
                boolean bl = false;
                if (!Double.isNaN(d2)) break block9;
            }
            throw (Throwable)new IllegalArgumentException(quantile + " is not in [0..1]");
        }
        if (this.getSize() == 0) {
            return 0.0;
        }
        double pos = quantile * (double)(this.values.length + 1);
        int index = (int)pos;
        if (index < 1) {
            d = this.values[0];
        } else if (index >= this.values.length) {
            d = this.values[this.values.length - 1];
        } else {
            double lower = this.values[index - 1];
            double upper = this.values[index];
            boolean bl = false;
            d = lower + (pos - Math.floor(pos)) * (upper - lower);
        }
        return d;
    }

    public final double median() {
        return this.valueAt(0.5);
    }

    public final double min() {
        double d;
        switch (this.getSize()) {
            case 0: {
                d = 0.0;
                break;
            }
            default: {
                d = this.values[0];
            }
        }
        return d;
    }

    public final double max() {
        double d;
        switch (this.getSize()) {
            case 0: {
                d = 0.0;
                break;
            }
            default: {
                d = this.values[ArraysKt.getLastIndex((double[])this.values)];
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public final double mean() {
        void var3_3;
        double[] $this$sumByDouble$iv = this.values;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        double[] dArray = $this$sumByDouble$iv;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            void it;
            double element$iv;
            double d = element$iv = dArray[i];
            double d2 = sum$iv;
            boolean bl = false;
            void var15_11 = it;
            sum$iv = d2 + var15_11;
        }
        return (double)(var3_3 / (double)this.getSize());
    }

    /*
     * WARNING - void declaration
     */
    public final double standardDeviation() {
        if (this.getSize() <= 1) {
            return 0.0;
        }
        double mean = this.mean();
        double[] $this$sumByDouble$iv = this.values;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        double[] dArray = $this$sumByDouble$iv;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            void it;
            double element$iv;
            double d = element$iv = dArray[i];
            double d2 = sum$iv;
            boolean bl = false;
            void var17_13 = it - mean;
            boolean bl2 = false;
            boolean bl3 = false;
            void it2 = var17_13;
            boolean bl4 = false;
            void var26_19 = it2 * it2;
            sum$iv = d2 + var26_19;
        }
        double sum = sum$iv;
        double variance = sum / (double)ArraysKt.getLastIndex((double[])this.values);
        boolean bl = false;
        return Math.sqrt(variance);
    }

    public ReportBenchmarksStatistics(@NotNull double[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.values = ArraysKt.sortedArray((double[])values);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lkotlinx/benchmark/ReportBenchmarksStatistics$Companion;", "", "()V", "createResult", "Lkotlinx/benchmark/ReportBenchmarkResult;", "benchmark", "Lkotlinx/benchmark/BenchmarkDescriptor;", "params", "", "", "config", "Lkotlinx/benchmark/BenchmarkConfiguration;", "samples", "", "kotlinx-benchmark-runtime"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ReportBenchmarkResult createResult(@NotNull BenchmarkDescriptor<?> benchmark, @NotNull Map<String, String> params, @NotNull BenchmarkConfiguration config, @NotNull double[] samples) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter(benchmark, (String)"benchmark");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
            ReportBenchmarksStatistics statistics = new ReportBenchmarksStatistics(samples);
            double score = statistics.mean();
            double d = samples.length;
            boolean bl = false;
            double errorMargin = 1.96 * (statistics.standardDeviation() / Math.sqrt(d));
            Iterable $this$associate$iv = CollectionsKt.listOf((Object[])new Double[]{0.0, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999, 1.0});
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)(it * (double)100), (Object)statistics.valueAt(it));
                boolean bl3 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map percentiles = destination$iv$iv;
            return new ReportBenchmarkResult(config, benchmark, params, score, errorMargin, (Pair<Double, Double>)TuplesKt.to((Object)(score - errorMargin), (Object)(score + errorMargin)), percentiles, samples);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

