/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.benchmark.CommonBenchmarkAnnotationsKt;
import kotlinx.benchmark.ReportBenchmarksStatisticsKt$WhenMappings;
import kotlinx.benchmark.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmh.annotations.Mode;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\"\u0010\f\u001a\u00020\t*\u00020\t2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\t2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u001a\"\u0010\u000e\u001a\u00020\u0001*\u00020\t2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\u000f"}, d2={"unitText", "", "mode", "Lorg/openjdk/jmh/annotations/Mode;", "Lkotlinx/benchmark/Mode;", "unit", "Ljava/util/concurrent/TimeUnit;", "Lkotlinx/benchmark/BenchmarkTimeUnit;", "formatSignificant", "", "precision", "", "nanosToSample", "nanosToText", "sampleToText", "kotlinx-benchmark-runtime"})
public final class ReportBenchmarksStatisticsKt {
    @NotNull
    public static final String formatSignificant(double $this$formatSignificant, int precision) {
        boolean bl = false;
        double d = Math.log10($this$formatSignificant);
        boolean bl2 = false;
        int d2 = RangesKt.coerceAtLeast((int)(precision - (int)Math.ceil(d)), (int)0);
        return UtilsKt.format($this$formatSignificant, d2);
    }

    @NotNull
    public static final String nanosToText(double $this$nanosToText, @NotNull Mode mode2, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double value = ReportBenchmarksStatisticsKt.nanosToSample($this$nanosToText, mode2, unit);
        switch (ReportBenchmarksStatisticsKt$WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + " ops/" + CommonBenchmarkAnnotationsKt.toText(unit);
                break;
            }
            case 2: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + ' ' + CommonBenchmarkAnnotationsKt.toText(unit) + "/op";
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return string;
    }

    @NotNull
    public static final String unitText(@NotNull Mode mode2, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        switch (ReportBenchmarksStatisticsKt$WhenMappings.$EnumSwitchMapping$1[mode2.ordinal()]) {
            case 1: {
                string = "ops/" + CommonBenchmarkAnnotationsKt.toText(unit);
                break;
            }
            case 2: {
                string = CommonBenchmarkAnnotationsKt.toText(unit) + "/op";
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return string;
    }

    @NotNull
    public static final String sampleToText(double $this$sampleToText, @NotNull Mode mode2, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double value = $this$sampleToText;
        switch (ReportBenchmarksStatisticsKt$WhenMappings.$EnumSwitchMapping$2[mode2.ordinal()]) {
            case 1: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + " ops/" + CommonBenchmarkAnnotationsKt.toText(unit);
                break;
            }
            case 2: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + ' ' + CommonBenchmarkAnnotationsKt.toText(unit) + "/op";
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return string;
    }

    public static final double nanosToSample(double $this$nanosToSample, @NotNull Mode mode2, @NotNull TimeUnit unit) {
        double d;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long multiplier = CommonBenchmarkAnnotationsKt.toMultiplier(unit);
        switch (ReportBenchmarksStatisticsKt$WhenMappings.$EnumSwitchMapping$3[mode2.ordinal()]) {
            case 1: {
                d = (double)multiplier / $this$nanosToSample;
                break;
            }
            case 2: {
                d = $this$nanosToSample / (double)multiplier;
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return d;
    }
}

