/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.benchmark.CommonBenchmarkAnnotationsKt;
import kotlinx.benchmark.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmh.annotations.Mode;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u001e\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a\u0012\u0010\n\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\u0001\u001a\"\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a\"\u0010\u0011\u001a\u00020\u0003*\u00020\u00012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a\"\u0010\u0012\u001a\u00020\u0003*\u00020\u00012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"zeroThreshold", "", "unitText", "", "mode", "Lorg/openjdk/jmh/annotations/Mode;", "Lkotlinx/benchmark/Mode;", "unit", "Ljava/util/concurrent/TimeUnit;", "Lkotlinx/benchmark/BenchmarkTimeUnit;", "formatSignificant", "precision", "", "isApproximateZero", "", "isNaNOrZero", "nanosToSample", "nanosToText", "sampleToText", "kotlinx-benchmark-runtime"})
public final class ReportBenchmarksStatisticsKt {
    private static final double zeroThreshold = 1.0 / Math.pow(10.0, 3) / (double)2;

    @NotNull
    public static final String formatSignificant(double $this$formatSignificant, int precision) {
        int d = RangesKt.coerceAtLeast((int)(precision - (int)Math.ceil(Math.log10($this$formatSignificant))), (int)0);
        return UtilsKt.format$default($this$formatSignificant, d, false, 2, null);
    }

    public static final boolean isNaNOrZero(double $this$isNaNOrZero) {
        return Double.isNaN($this$isNaNOrZero) || ReportBenchmarksStatisticsKt.isApproximateZero($this$isNaNOrZero);
    }

    public static final boolean isApproximateZero(double $this$isApproximateZero) {
        return $this$isApproximateZero < zeroThreshold;
    }

    @NotNull
    public static final String nanosToText(double $this$nanosToText, @NotNull Mode mode2, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double value = ReportBenchmarksStatisticsKt.nanosToSample($this$nanosToText, mode2, unit);
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + " ops/" + CommonBenchmarkAnnotationsKt.toText(unit);
                break;
            }
            case 2: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + ' ' + CommonBenchmarkAnnotationsKt.toText(unit) + "/op";
                break;
            }
            default: {
                throw new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return string;
    }

    @NotNull
    public static final String unitText(@NotNull Mode mode2, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                string = "ops/" + CommonBenchmarkAnnotationsKt.toText(unit);
                break;
            }
            case 2: {
                string = CommonBenchmarkAnnotationsKt.toText(unit) + "/op";
                break;
            }
            default: {
                throw new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return string;
    }

    @NotNull
    public static final String sampleToText(double $this$sampleToText, @NotNull Mode mode2, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double value = $this$sampleToText;
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + " ops/" + CommonBenchmarkAnnotationsKt.toText(unit);
                break;
            }
            case 2: {
                string = ReportBenchmarksStatisticsKt.formatSignificant(value, 6) + ' ' + CommonBenchmarkAnnotationsKt.toText(unit) + "/op";
                break;
            }
            default: {
                throw new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return string;
    }

    public static final double nanosToSample(double $this$nanosToSample, @NotNull Mode mode2, @NotNull TimeUnit unit) {
        double d;
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long multiplier = CommonBenchmarkAnnotationsKt.toMultiplier(unit);
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                d = (double)multiplier / $this$nanosToSample;
                break;
            }
            case 2: {
                d = $this$nanosToSample / (double)multiplier;
                break;
            }
            default: {
                throw new UnsupportedOperationException(mode2 + " is not supported");
            }
        }
        return d;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.Throughput.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.AverageTime.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

