/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.benchmark.jvm;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.benchmark.BenchmarkProgress;
import kotlinx.benchmark.jvm.PrintOutputFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.IterationType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkotlinx/benchmark/jvm/JmhOutputFormat;", "Lkotlinx/benchmark/jvm/PrintOutputFormat;", "reporter", "Lkotlinx/benchmark/BenchmarkProgress;", "suiteName", "", "(Lkotlinx/benchmark/BenchmarkProgress;Ljava/lang/String;)V", "lastBenchmarkStart", "getLastBenchmarkStart$kotlinx_benchmark_runtime", "()Ljava/lang/String;", "setLastBenchmarkStart$kotlinx_benchmark_runtime", "(Ljava/lang/String;)V", "endBenchmark", "", "result", "Lorg/openjdk/jmh/results/BenchmarkResult;", "endRun", "", "Lorg/openjdk/jmh/results/RunResult;", "getBenchmarkId", "params", "Lorg/openjdk/jmh/infra/BenchmarkParams;", "iteration", "benchParams", "Lorg/openjdk/jmh/infra/IterationParams;", "", "iterationResult", "data", "Lorg/openjdk/jmh/results/IterationResult;", "println", "s", "startBenchmark", "startRun", "kotlinx-benchmark-runtime"})
public final class JmhOutputFormat
extends PrintOutputFormat {
    @NotNull
    private final BenchmarkProgress reporter;
    @NotNull
    private final String suiteName;
    @NotNull
    private String lastBenchmarkStart;

    public JmhOutputFormat(@NotNull BenchmarkProgress reporter, @NotNull String suiteName) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)suiteName, (String)"suiteName");
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        super(printStream, null, 2, null);
        this.reporter = reporter;
        this.suiteName = suiteName;
        this.lastBenchmarkStart = "";
    }

    @NotNull
    public final String getLastBenchmarkStart$kotlinx_benchmark_runtime() {
        return this.lastBenchmarkStart;
    }

    public final void setLastBenchmarkStart$kotlinx_benchmark_runtime(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastBenchmarkStart = string;
    }

    public void startRun() {
        this.reporter.startSuite(this.suiteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRun(@NotNull Collection<? extends RunResult> result) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter(result, (String)"result");
        ByteArrayOutputStream $this$endRun_u24lambda_u241 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        Closeable closeable = new PrintStream((OutputStream)$this$endRun_u24lambda_u241, true, "UTF-8");
        Throwable throwable = null;
        try {
            PrintStream it = (PrintStream)closeable;
            boolean bl2 = false;
            ResultFormatFactory.getInstance((ResultFormatType)ResultFormatType.TEXT, (PrintStream)it).writeOut(result);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String summary = byteArrayOutputStream.toString("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)summary, (String)"summary");
        this.reporter.endSuite(this.suiteName, summary);
    }

    public void startBenchmark(@NotNull BenchmarkParams benchParams) {
        Intrinsics.checkNotNullParameter((Object)benchParams, (String)"benchParams");
        String benchmarkId2 = this.getBenchmarkId(benchParams);
        this.reporter.startBenchmark(this.suiteName, benchmarkId2);
        this.lastBenchmarkStart = benchmarkId2;
    }

    public void endBenchmark(@Nullable BenchmarkResult result) {
        if (result != null) {
            BenchmarkParams benchmarkParams = result.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)benchmarkParams, (String)"result.params");
            String benchmarkId2 = this.getBenchmarkId(benchmarkParams);
            Result value = result.getPrimaryResult();
            String string = value.extendedInfo();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.extendedInfo()");
            String message = ((Object)StringsKt.trim((CharSequence)string)).toString();
            this.reporter.endBenchmark(this.suiteName, benchmarkId2, BenchmarkProgress.FinishStatus.Success, message);
        } else {
            this.reporter.endBenchmarkException(this.suiteName, this.lastBenchmarkStart, "<ERROR>", "");
        }
    }

    private final String getBenchmarkId(BenchmarkParams params) {
        String string;
        String benchmarkName = params.getBenchmark();
        Collection paramKeys = params.getParamsKeys();
        if (paramKeys.isEmpty()) {
            string = benchmarkName;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(benchmarkName);
            Intrinsics.checkNotNullExpressionValue((Object)paramKeys, (String)"paramKeys");
            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)paramKeys, null, (CharSequence)" | ", null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(params){
                final /* synthetic */ BenchmarkParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(String it) {
                    return it + '=' + this.$params.getParam(it);
                }
            }), (int)29, null)).toString();
        }
        String benchmarkId2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)benchmarkId2, (String)"benchmarkId");
        return benchmarkId2;
    }

    public void iteration(@NotNull BenchmarkParams benchParams, @NotNull IterationParams params, int iteration) {
        Intrinsics.checkNotNullParameter((Object)benchParams, (String)"benchParams");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    public void iterationResult(@NotNull BenchmarkParams benchParams, @NotNull IterationParams params, int iteration, @NotNull IterationResult data) {
        Intrinsics.checkNotNullParameter((Object)benchParams, (String)"benchParams");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IterationType iterationType = params.getType();
        switch (iterationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[iterationType.ordinal()]) {
            case 1: {
                this.println("Warm-up " + iteration + ": " + data.getPrimaryResult());
                break;
            }
            case 2: {
                this.println("Iteration " + iteration + ": " + data.getPrimaryResult());
                break;
            }
            case -1: {
                throw new UnsupportedOperationException("Iteration type not set");
            }
        }
        this.flush();
    }

    @Override
    public void println(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (!StringsKt.startsWith$default((String)s, (String)"#", (boolean)false, (int)2, null)) {
            this.reporter.output(this.suiteName, this.lastBenchmarkStart, s);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IterationType.values().length];
            try {
                nArray[IterationType.WARMUP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IterationType.MEASUREMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

